/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.util.MailMsg;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.dialup.server.event.wifi.WiFiGetLoginsOnEmailEvent;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class ActionWiFiGetPassword
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        this.rootNode.setAttribute("status", "");
        String error = this.doit(this.request, this.mid);
        if (error != null) {
            this.rootNode.setAttribute("status", "error");
            this.rootNode.appendChild(this.rootNode.getOwnerDocument().createTextNode(error));
        }
    }

    private String doit(HttpServletRequest request, int mid) throws BGException {
        String email = request.getParameter("wifi.email");
        Object error = null;
        if (error == null && Utils.isBlankString((String)email)) {
            throw new BGMessageException(" \u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u0432\u0435\u0441\u0442\u0438 email1 ");
        }
        List<Integer> cids = this.getCidsByEmail(email);
        if (cids.size() == 0) {
            throw new BGMessageException(" \u0412\u0430\u0448 email \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d ");
        }
        ArrayList<Pair<String, String>> loginPasswords = new ArrayList<Pair<String, String>>();
        for (Integer cid : cids) {
            loginPasswords.addAll(this.getUserPasswords(mid, cid));
        }
        WiFiGetLoginsOnEmailEvent event = new WiFiGetLoginsOnEmailEvent(loginPasswords, mid, -1, this.userId);
        try {
            EventProcessor.getInstance().request((QueueEvent)event);
        }
        catch (BGException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 \u043f\u0438\u0441\u044c\u043c\u0430 \u0438\u0437 \u0441\u043a\u0440\u0438\u043f\u0442\u0430.", (Throwable)e);
        }
        String text = event.getEmailText();
        String subject = event.getEmailSubject();
        if (Utils.isEmptyString((String)text)) {
            text = this.getText(loginPasswords);
        }
        if (Utils.isEmptyString((String)subject)) {
            subject = "\u043f\u0430\u0440\u043e\u043b\u0438 \u043a WiFi ";
        }
        new MailMsg((Preferences)this.setup).sendMessage(email, subject, text);
        return null;
    }

    private String getText(List<Pair<String, String>> loginPasswords) {
        StringBuffer buf = new StringBuffer();
        buf.append(" \u0417\u0434\u0440\u0430\u0432\u0441\u0442\u0432\u0443\u0439\u0442\u0435 \n");
        buf.append(" \u0412\u043e\u0442 \u0432\u0430\u0448 \u0441\u043f\u0438\u0441\u043e\u043a \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0438 \u043f\u0430\u0440\u043e\u043b\u0435\u0439:  \n");
        for (Pair<String, String> pair : loginPasswords) {
            buf.append("######################################################\n");
            buf.append("  login:" + (String)pair.getFirst() + "\n");
            buf.append("  password:" + (String)pair.getSecond() + "\n");
            buf.append("######################################################\n");
        }
        return buf.toString();
    }

    private List<Integer> getCidsByEmail(String email) throws BGException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            log.debug("getting email  for email=" + email);
            int emailParamId = this.moduleSetup.getInt("mail.contract.param.code", -1);
            String query = "SELECT contract.id FROM contract  LEFT JOIN  contract_parameter_type_3 as mail ON contract.id=mail.cid  WHERE  mail.pid=? AND mail.email like ? ";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, emailParamId);
            ps.setString(2, "%" + email + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private List<Pair<String, String>> getUserPasswords(int mid, int cid) throws BGException {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        try {
            Pair pair;
            log.debug("getting alias  for mid=" + mid + ";cid=" + cid);
            String query = "SELECT * FROM user_login_" + mid + " WHERE cid=? AND ( isNull(date1) OR date1<=now() ) AND ( isNull(date2) OR date2>=now() )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                pair = new Pair((Object)rs.getString("login"), (Object)rs.getString("pswd"));
                result.add(pair);
            }
            rs.close();
            ps.close();
            query = "SELECT alias.login_alias, login.*  FROM  user_alias_" + mid + " as alias LEFT JOIN user_login_" + mid + " as login  ON alias.login_id=login.id WHERE login.cid =?   AND ( isNull(date1) OR date1<=now() ) AND ( isNull(date2) OR date2>=now() )";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                pair = new Pair((Object)rs.getString("login_alias"), (Object)rs.getString("pswd"));
                result.add((Pair<String, String>)pair);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

