/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server;

import bitel.billing.server.call.bean.NAS;
import bitel.billing.server.call.bean.NasManager;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.modules.dialup.server.traffic.NASServiceConfig;
import ru.bitel.bgbilling.modules.dialup.server.traffic.Traffic;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class TrafficSelector {
    private Map<Integer, File> nasLogPath = new HashMap<Integer, File>();
    private File currentLogDirPath;
    private List<NasData> nasIdList = new ArrayList<NasData>();

    public TrafficSelector(Connection con, int mid, Logger log) {
        NasManager nu = new NasManager(con, mid);
        List nasList = nu.getNasList(null);
        for (NAS nas : nasList) {
            nu.setNasConfig(nas);
            Preferences nasConfig = nas.getConfig();
            if (nasConfig == null) continue;
            String logPath = nasConfig.get("netflow.log.path", null);
            if (Utils.notBlankString((String)logPath)) {
                File file = new File(logPath);
                if (!file.exists() || !file.isDirectory()) {
                    log.error("Not exist folder " + logPath);
                    continue;
                }
                this.nasLogPath.put(nas.getId(), file);
            }
            this.nasIdList.add(new NasData(nas.getId(), nasConfig, log));
        }
    }

    public List<NasData> getNasIdList() {
        return this.nasIdList;
    }

    public void setNasId(int id) throws Exception {
        this.currentLogDirPath = this.nasLogPath.get(id);
        if (this.currentLogDirPath == null) {
            throw new BGException("Not found netflow logs for nas. NAS id=" + id);
        }
    }

    public IPHourlyDataLog getHourBinaryLog(Calendar hour) {
        return new IPHourlyDataLog(this.currentLogDirPath, hour);
    }

    public static class NasData {
        private int id;
        private NASServiceConfig serviceConfig;

        public NasData(int id, Preferences nasConfig, Logger log) {
            this.id = id;
            this.serviceConfig = new NASServiceConfig((ParameterMap)nasConfig, log);
        }

        public int getId() {
            return this.id;
        }

        public List<Traffic> getTrafficConfig(String realm, String port) {
            return this.serviceConfig.getTrafficConfig(realm, port);
        }
    }
}

