/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGControlPanelDateWithTime;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.print.HtmlPrinter;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.crm.client.RegisterPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class TaskEditor
extends RegisterPanel {
    static final String MODULE_CONTRACT = "contract";
    static final String MODULE_CONTRACT_OBJECT = "contract.object";
    private String module = "ru.bitel.bgbilling.plugins.crm";
    private int taskTypeId = 0;
    private int taskGroupId = 0;
    private int taskContractId = 0;
    private String taskExecutors = "";
    private String taskContractTitle;
    private JButton contractOpenButton = new JButton();
    private JLabel open_L = new JLabel();
    private JLabel accept_L = new JLabel();
    private JLabel close_L = new JLabel();
    private JLabel lastmod_L = new JLabel();
    private BGComboBox<ComboBoxItem> taskTypeCB = new BGComboBox();
    private BGComboBox<ComboBoxItem> group_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> status_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> address_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> addressObject_CB = new BGComboBox();
    private BGControlPanelListSelect executors_P = new BGControlPanelListSelect();
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private BGTable tableLog = new BGTable();
    private JTextArea comment = new JTextArea();
    private JTextArea resolution_TA = new JTextArea();
    private JTextField problemId = new JTextField();
    private BGControlPanelDateWithTime targetDate_P = new BGControlPanelDateWithTime();
    private BGControlPanelDateNoB executeDate_P = new BGControlPanelDateNoB();
    private BGPluginClient plugin = null;

    public TaskEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.crm");
        Font font = new Font("Dialog", 0, 14);
        this.open_L.setFont(font);
        this.accept_L.setFont(font);
        this.close_L.setFont(font);
        this.lastmod_L.setFont(font);
        this.executors_P.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0438  "));
        this.taskTypeCB.addActionListener(e -> this.doTaskType());
        this.group_CB.addActionListener(e -> this.doTaskGroup());
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)new JLabel("Id \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel5.add((Component)new JLabel("\u0422\u0438\u043f \u0437\u0430\u0434\u0430\u0447\u0438:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel5.add((Component)new JLabel("\u0421\u0440\u043e\u043a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel5.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel5.add((Component)this.problemId, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        jPanel5.add((Component)this.taskTypeCB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        jPanel5.add((Component)this.targetDate_P, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        jPanel5.add((Component)this.executeDate_P, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.jTabbedPane.add((Component)this.getCommentPanel(), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        this.jTabbedPane.add((Component)this.getResolutionPanel(), "\u0420\u0435\u0437\u043e\u043b\u044e\u0446\u0438\u044f");
        this.jTabbedPane.add((Component)this.getUserTimePanel(), "\u041b\u043e\u0433");
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 "));
        centerPanel.setMinimumSize(new Dimension(230, 0));
        centerPanel.setPreferredSize(new Dimension(300, 0));
        centerPanel.setMaximumSize(new Dimension(300, 0));
        centerPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        centerPanel.add((Component)this.status_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        centerPanel.add((Component)this.executors_P, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        centerPanel.add((Component)this.group_CB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 "));
        leftPanel.setMinimumSize(new Dimension(193, 300));
        leftPanel.setPreferredSize(new Dimension(193, 300));
        leftPanel.add((Component)jPanel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.jTabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(953, 399));
        this.add(this.getContractPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(centerPanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(leftPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getBottomPnel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
    }

    private JPanel getUserTimePanel() {
        this.tableLog.setHeader(this.plugin.getResourceBundle(), this.plugin.getTable("task_log"), "task_log");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.tableLog), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getContractPanel() {
        this.addressObject_CB.addActionListener(e -> this.addressObjectSelectionChanged());
        this.contractOpenButton.addActionListener(e -> this.contractOpenButton_actionPerformed(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0414\u043e\u0433\u043e\u0432\u043e\u0440 "));
        panel.add((Component)this.contractOpenButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.addressObject_CB, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.address_CB, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getResolutionPanel() {
        this.resolution_TA.setMargin(new Insets(3, 3, 3, 3));
        this.resolution_TA.setLineWrap(true);
        this.resolution_TA.setWrapStyleWord(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.resolution_TA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getCommentPanel() {
        this.comment.setMargin(new Insets(3, 3, 3, 3));
        this.comment.setLineWrap(true);
        this.comment.setWrapStyleWord(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getBottomPnel() {
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> this.okButton_actionPerformed(e));
        JButton okEmailButton = new JButton("OK + EMail");
        okEmailButton.addActionListener(e -> this.save(true));
        JButton okPrintButton = new JButton("OK + \u041f\u0435\u0447\u0430\u0442\u044c \u043d\u0430\u0440\u044f\u0434\u0430");
        okPrintButton.addActionListener(e -> this.print());
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        cancelButton.addActionListener(e -> this.cancelButton_actionPerformed(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(Box.createHorizontalStrut(8), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)okEmailButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)okPrintButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)cancelButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private void addressObjectSelectionChanged() {
        ComboBoxItem item = (ComboBoxItem)this.addressObject_CB.getSelectedItem();
        if (item != null) {
            ClientUtils.buildComboBox(this.address_CB, (Node)((Node)item.get("list")), null);
        }
    }

    public void setData() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        if (this.id.equals("new")) {
            this.taskTypeCB.setEnabled(true);
            this.jTabbedPane.setSelectedIndex(0);
            this.targetDate_P.setDateString("");
            this.executeDate_P.setDateString("");
            this.comment.setText("");
            this.resolution_TA.setText("");
            this.executors_P.setListValues("");
            this.open_L.setText("");
            this.accept_L.setText("");
            this.close_L.setText("");
            this.lastmod_L.setText("");
            this.contractOpenButton.setEnabled(false);
            this.contractOpenButton.setText(" ");
            this.taskTypeCB.setSelectedIndex(this.taskTypeCB.getItemCount() > 0 ? 0 : -1);
            this.status_CB.setSelectedIndex(this.status_CB.getItemCount() > 0 ? 0 : -1);
            this.buildAddressCombo(String.valueOf(this.getContractId()), "", "");
            this.taskTypeId = 0;
            this.taskGroupId = 0;
            this.taskExecutors = "";
        } else {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetRegisterTask");
            request.setAttribute("id", this.id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setDocument(doc);
            }
        }
        this.getTaskLog();
    }

    private void getTaskLog() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("RegisterTaskLogTable");
        request.setAttribute("id", this.id);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.tableLog.updateData(doc);
        }
    }

    private void buildAddressCombo(String cid, String selected, String objectId) {
        ComboBoxItem item;
        Request request = new Request();
        request.setModule(MODULE_CONTRACT);
        request.setContractId(cid);
        request.setAction("ContractAddressList");
        DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            item = new ComboBoxItem((Object)"0", " --- ");
            item.put("list", (Object)XMLUtils.selectElement((Node)doc, (String)"//list"));
            model.addElement(item);
        }
        request = new Request();
        request.setModule(MODULE_CONTRACT_OBJECT);
        request.setContractId(cid);
        request.setAction("AddressParamValueList");
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element objects = XMLUtils.selectElement((Node)doc, (String)"//objects");
            NodeList list = objects.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                Element object = (Element)list.item(i);
                item = new ComboBoxItem((Object)object.getAttribute("id"), object.getAttribute("title"));
                item.put("list", (Object)object);
                model.addElement(item);
            }
        }
        this.addressObject_CB.setModel(model);
        ClientUtils.setComboBoxSelection(this.addressObject_CB, (Object)objectId);
        this.addressObjectSelectionChanged();
        ClientUtils.setComboBoxSelection(this.address_CB, (Object)selected);
    }

    public void setDocument(Document doc) {
        Element task = XMLUtils.selectElement((Node)doc, (String)"//task");
        this.targetDate_P.setDateString(task.getAttribute("target_date_and_time"));
        this.executeDate_P.setDateString(task.getAttribute("execute_date"));
        this.taskContractTitle = task.getAttribute(MODULE_CONTRACT);
        this.taskContractId = Utils.parseInt((String)task.getAttribute("contract_id"), (int)-1);
        this.contractOpenButton.setText(Utils.notEmptyString((String)this.taskContractTitle) ? this.taskContractTitle : " ");
        this.contractOpenButton.setEnabled(this.taskContractId > 0);
        this.open_L.setText(task.getAttribute("open"));
        this.accept_L.setText(task.getAttribute("accept"));
        this.close_L.setText(task.getAttribute("close"));
        this.lastmod_L.setText(task.getAttribute("lastmod"));
        ClientUtils.setComboBoxSelection(this.status_CB, (Object)task.getAttribute("status"));
        this.comment.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//comment")));
        this.resolution_TA.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//resolution")));
        this.buildAddressCombo(task.getAttribute("contract_id"), task.getAttribute("apid"), task.getAttribute("aObjectId"));
        this.taskTypeCB.setEnabled(this.setup.get("crm.task.type.update", "false").equalsIgnoreCase("true"));
        this.problemId.setText(task.getAttribute("problemId"));
        this.taskTypeId = Utils.parseInt((String)task.getAttribute("type"));
        this.taskGroupId = Utils.parseInt((String)task.getAttribute("group"));
        this.taskExecutors = task.getAttribute("executors");
        ClientUtils.setComboBoxSelection(this.taskTypeCB, (int)this.taskTypeId);
        this.executors_P.setListValues(this.taskExecutors);
        this.group_CB.setEnabled(true);
        this.executors_P.setEnabled(true);
    }

    private void init() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ListDirectory");
        request.setAttribute("mode", 16);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.taskTypeCB.setModel((ComboBoxModel)ClientUtils.buildComboBoxWithDefault((Node)XMLUtils.selectElement((Node)doc, (String)"//directory"), null));
        }
        this.group_CB.setEnabled(false);
        this.executors_P.setEnabled(false);
    }

    public void contractOpenButton_actionPerformed(ActionEvent actionEvent) {
        this.openContract(this.taskContractId);
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        this.save(false);
    }

    private void save(boolean sendEmail) {
        try {
            Request request = this.getUpdateRequest(sendEmail);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setVisible(false);
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private Request getUpdateRequest(boolean sendEmail) throws BGException {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateRegisterTask");
        request.setAttribute("id", this.id);
        if (this.getContractId() == -1) {
            request.setContractId(this.taskContractId);
        } else {
            request.setContractId(this.getContractId());
        }
        ComboBoxItem typeItem = (ComboBoxItem)this.taskTypeCB.getSelectedItem();
        if (typeItem == null || "-1".equals(typeItem.getObject().toString())) {
            throw new BGException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0438\u043f \u0437\u0430\u0434\u0430\u0447\u0438!");
        }
        request.setAttribute("type", typeItem.getObject());
        ComboBoxItem groupItem = (ComboBoxItem)this.group_CB.getSelectedItem();
        request.setAttribute("group", groupItem == null ? "0" : groupItem.getObject());
        ComboBoxItem statusItem = (ComboBoxItem)this.status_CB.getSelectedItem();
        Object status = statusItem.getObject();
        request.setAttribute("status", status);
        ComboBoxItem addressItem = (ComboBoxItem)this.address_CB.getSelectedItem();
        if (addressItem != null) {
            request.setAttribute("apid", addressItem.getObject());
        } else {
            request.setAttribute("apid", "0");
        }
        addressItem = (ComboBoxItem)this.addressObject_CB.getSelectedItem();
        if (addressItem != null) {
            request.setAttribute("aObjectId", addressItem.getObject());
        }
        request.setAttribute("target_date_and_time", this.targetDate_P.getDateString());
        String executeDate = this.executeDate_P.getDateString();
        request.setAttribute("execute_date", executeDate);
        request.setAttribute("executors", this.executors_P.getListValues());
        request.setAttribute("comment", this.comment.getText());
        request.setAttribute("resolution", this.resolution_TA.getText());
        request.setAttribute("problemId", this.problemId.getText().trim());
        if (sendEmail) {
            request.setAttribute("send.mail", "1");
        }
        return request;
    }

    private void print() {
        Request request;
        try {
            request = this.getUpdateRequest(false);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return;
        }
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            String id = this.id;
            if (id.equals("new")) {
                id = XMLUtils.selectElement((Node)doc, (String)"//task").getAttribute("id");
            }
            request = new Request();
            request.setModule(this.module);
            request.setAction("PrintRegisterTaskOrder");
            request.setAttribute("id", id);
            request.setAttribute("contentType", "html");
            try {
                new HtmlPrinter(TransferManager.getString((Request)request), 800, 600);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setVisible(false);
        }
    }

    public void setStatusData(Element list) {
        this.status_CB.setModel((ComboBoxModel)ClientUtils.buildComboBox((Node)list, (String)""));
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void setProblemId(String id) {
        this.problemId.setText(id);
    }

    private void doTaskType() {
        this.taskTypeId = Utils.parseInt((String)this.taskTypeCB.getSelectedId());
        this.group_CB.removeAllItems();
        ((DefaultListModel)this.executors_P.getList().getModel()).removeAllElements();
        if (this.taskTypeId > 0) {
            this.buildGroupList(this.group_CB, this.taskTypeId, String.valueOf(this.taskGroupId));
            DefaultComboBoxModel boxModel = (DefaultComboBoxModel)this.group_CB.getModel();
            for (int index = 0; index < boxModel.getSize(); ++index) {
                ComboBoxItem comboBoxItem;
                Object itemObject = boxModel.getElementAt(index);
                if (!(itemObject instanceof ComboBoxItem) || this.taskGroupId != Utils.parseInt((String)(comboBoxItem = (ComboBoxItem)itemObject).getObject().toString())) continue;
                this.setExecutors(this.executors_P, this.taskGroupId);
                this.executors_P.setListValues(this.taskExecutors);
                break;
            }
        }
        this.group_CB.setEnabled(this.taskTypeId > 0);
        this.executors_P.setEnabled(this.taskTypeId > 0);
    }

    private void doTaskGroup() {
        int taskGroupId = Utils.parseInt((String)this.group_CB.getSelectedId());
        if (taskGroupId > 0) {
            this.setExecutors(this.executors_P, taskGroupId);
            this.executors_P.setListValues(this.taskExecutors);
        } else {
            ((DefaultListModel)this.executors_P.getList().getModel()).removeAllElements();
        }
    }
}

