/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCallManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.common.TimeUtils;

public class ActionGetRegisterCall
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        Element callElement = this.createElement(this.rootNode, "call");
        RegisterCall call = new RegisterCallManager(this.con).getCallById(id);
        if (call != null) {
            RegisterProblemManager registerManager;
            RegisterProblem problem;
            if (call.getRegisterProblemId() > 0 && (problem = (registerManager = new RegisterProblemManager(this.con)).getProblemByID(call.getRegisterProblemId())) != null) {
                String statusList = this.plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
                Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
                callElement.setAttribute("problem_id", String.valueOf(problem.getId()));
                callElement.setAttribute("problem_status", statusMap.get(problem.getStatus()));
                this.stringToLines(this.createElement(callElement, "problem_comment"), problem.getComment());
                this.stringToLines(this.createElement(callElement, "problem_resolution"), problem.getResolution());
            }
            if (call.getContractId() > 0) {
                callElement.setAttribute("contract", call.getContractTitle());
                callElement.setAttribute("contract_id", String.valueOf(call.getContractId()));
                if (call.getObjectId() > 0) {
                    callElement.setAttribute("object", call.getObjectTitle());
                    callElement.setAttribute("object_id", String.valueOf(call.getObjectId()));
                }
            }
            callElement.setAttribute("subject", String.valueOf(call.getSubjectId()));
            callElement.setAttribute("group", String.valueOf(call.getGroupId()));
            Element commentElement = this.createElement(callElement, "comment");
            this.stringToLines(commentElement, call.getComment());
            try (UserManager userManager = new UserManager(this.con);){
                User user = (User)userManager.get(call.getUserId());
                if (user != null) {
                    callElement.setAttribute("user", user.getName());
                } else {
                    callElement.setAttribute("user", "???");
                }
            }
            callElement.setAttribute("time", TimeUtils.format((Date)call.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
        }
    }
}

