/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.MessageDigest;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt.LoginGetInfo;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt.LoginGetInfoRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt.LoginGetInfoResponse;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt.LoginTryRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt.LoginTryResponse;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt.LogoutRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt.Request;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt.Response;
import ru.bitel.common.Utils;

public class CerbercryptServerConnection {
    private static final Logger log = LogManager.getLogger();
    private String host;
    private int port;
    private String login;
    private String pswd;
    private int timeout = -1;
    private Socket socket;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPswd(String pswd) {
        this.pswd = pswd;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void auth() throws Exception {
        LoginGetInfoRequest getInfoRequest = new LoginGetInfoRequest();
        LoginGetInfoResponse getInfoResponse = (LoginGetInfoResponse)this.sendRequest(getInfoRequest);
        byte[] salt = null;
        List<LoginGetInfo> list = getInfoResponse.getInfoRecordList();
        for (LoginGetInfo getInfo : list) {
            if (!getInfo.login.equals(this.login)) continue;
            salt = getInfo.salt;
            break;
        }
        byte[] pswd = this.pswd.getBytes("ISO-8859-1");
        MessageDigest digest = MessageDigest.getInstance("MD2");
        digest.update(pswd, 0, pswd.length);
        digest.update(salt, 0, salt.length);
        LoginTryRequest tryRequest = new LoginTryRequest();
        tryRequest.setLogin(this.login);
        tryRequest.setMd2Hash(digest.digest());
        LoginTryResponse tryResponse = (LoginTryResponse)this.sendRequest(tryRequest);
        if (tryResponse.getAccessMask() == null) {
            throw new Exception("Auth error login: " + this.login + "; pswd: " + this.pswd + "; salt: " + Utils.bytesToString((byte[])salt));
        }
    }

    public void logout() throws Exception {
        LogoutRequest logoutRequest = new LogoutRequest();
        this.sendRequest(logoutRequest);
        this.socket.close();
    }

    public Response sendRequest(Request req) throws Exception {
        Response result = null;
        if (this.socket == null) {
            log.debug("open socket " + this.host + ":" + this.port + "...");
            this.socket = new Socket(this.host, this.port);
            this.socket.setKeepAlive(true);
            if (this.timeout != -1) {
                this.socket.setSoTimeout(this.timeout);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("send request " + req.getClass().getSimpleName() + "...");
        }
        OutputStream out = this.socket.getOutputStream();
        out.write(req.toBytes());
        out.flush();
        InputStream input = this.socket.getInputStream();
        byte[] header = new byte[12];
        input.read(header, 0, 12);
        result = req.getResponse();
        result.parseHeader(header);
        if (log.isDebugEnabled()) {
            log.debug("get response " + result.getClass().getSimpleName() + ": status=" + result.getStatus() + ", datalength=" + result.getDataLength());
        }
        if (result.getDataLength() > 0) {
            byte[] data = new byte[result.getDataLength()];
            input.read(data, 0, result.getDataLength());
            result.parseData(data);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        byte[] pswd = "pswd".getBytes();
        byte[] salt = "salt".getBytes();
        MessageDigest digest = MessageDigest.getInstance("MD2");
        digest.update(pswd, 0, pswd.length);
        digest.update(salt, 0, salt.length);
        System.out.println(new String(digest.digest()));
    }
}

