/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.cdcas30;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import ru.bitel.common.Utils;

public class BitArrayOutputStream
extends ByteArrayOutputStream {
    private int iBuffer;
    private int iBitCount;

    public BitArrayOutputStream(int bytes) {
        super(bytes);
    }

    private synchronized void writeBit(int aBit) throws IOException {
        if (aBit != 0 && aBit != 1) {
            throw new IOException(aBit + " is not a bit");
        }
        this.iBuffer |= aBit << 7 - this.iBitCount;
        ++this.iBitCount;
        if (this.iBitCount == 8) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.iBitCount > 0) {
            super.write((byte)this.iBuffer);
            this.iBitCount = 0;
            this.iBuffer = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public synchronized void writeBits(int aValue, int aNumBits) throws IOException {
        for (int i = aNumBits - 1; i >= 0; --i) {
            this.writeBit(aValue >> i & 1);
        }
    }

    public void writeTimeT32(Date time) throws IOException {
        this.writeBits((int)(time.getTime() / 1000L), 32);
    }

    public static void main(String[] args) throws IOException {
        BitArrayOutputStream databody = new BitArrayOutputStream(666);
        databody.writeBits(1, 8);
        databody.writeBits(1, 16);
        System.out.println(Utils.bytesToString((byte[])databody.toByteArray()));
        databody.close();
        databody = new BitArrayOutputStream(666);
        databody.writeTimeT32(new Date(105, 2, 8, 15, 1, 40));
        databody.writeTimeT32(new Date(130, 11, 31, 0, 0, 0));
        System.out.println(Utils.bytesToString((byte[])databody.toByteArray()));
        databody.close();
        TimeZone.setDefault(TimeZone.getTimeZone("CTT"));
        Date d = new Date(1110265300000L);
        System.out.println(d);
        d = new Date(1924876800000L);
        System.out.println(d);
    }
}

