/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus.StarrusPrinter;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;

public class DeviceStatus {
    int Version1;
    int Version2;
    int Build;
    LocalDate SoftwareDate;
    LocalDate LeasedTo;
    EMode Mode;
    EFNStatus FNStatus;
    ECurrentPrinterStatus LastPrinterStatus;
    LocalDate FNExpirationDate;
    List<EFNFlags> FNFlags;
    List<ECurrentPrinterStatus> CurrentPrinterStatus;
    LocalDateTime CurrentDateTime;
    int LeaseMode;
    String FNSerialNumber;
    long FNLastFiscalDocumentNumber;
    int LeaseExpiredSoon;
    LocalDateTime FNLastFiscalDocumentDate;

    public void load(JSONObject status) {
        this.Version1 = status.getJSONArray("Version").getInt(0);
        this.Version2 = status.getJSONArray("Version").getInt(1);
        this.Build = status.getInt("Build");
        this.SoftwareDate = StarrusPrinter.parseDate(status.getJSONObject("SoftwareDate"));
        this.LeasedTo = StarrusPrinter.parseDate(status.getJSONObject("LeasedTo"));
        this.Mode = EMode.getMode(status.getInt("Mode"));
        this.FNStatus = EFNStatus.getStatus(status.getInt("FNStatus"));
        this.LastPrinterStatus = ECurrentPrinterStatus.getStatus(status.getInt("LastPrinterStatus"));
        this.FNExpirationDate = StarrusPrinter.parseDate(status.getJSONObject("FNExpirationDate"));
        int byteFNFlags = status.getInt("FNFlags");
        this.FNFlags = new ArrayList<EFNFlags>();
        for (int bit = 0; bit < 8; ++bit) {
            if (!FrkUtils.testBit(byteFNFlags, bit)) continue;
            this.FNFlags.add(EFNFlags.getFlag(bit));
        }
        this.CurrentPrinterStatus = new ArrayList<ECurrentPrinterStatus>();
        int byteCurrentPrinterStatus = status.getInt("CurrentPrinterStatus");
        for (int bit = 0; bit < 8; ++bit) {
            if (!FrkUtils.testBit(byteCurrentPrinterStatus, bit)) continue;
            this.CurrentPrinterStatus.add(ECurrentPrinterStatus.getStatus(bit));
        }
        this.CurrentDateTime = StarrusPrinter.parseDateTime(status.getJSONObject("CurrentDate"), status.getJSONObject("CurrentTime"));
        this.LeaseMode = status.getInt("LeaseMode");
        this.FNSerialNumber = this.getFNSerialNumber(status.getJSONArray("FNSerialNumber"));
        this.FNLastFiscalDocumentNumber = status.getLong("FNLastFiscalDocumentNumber");
        this.LeaseExpiredSoon = status.getInt("LeaseExpiredSoon");
        this.FNLastFiscalDocumentDate = StarrusPrinter.parseDateTime(status.getJSONObject("FNLastFiscalDocumentDate"));
    }

    private String getFNSerialNumber(JSONArray arr) {
        StringBuilder sb = new StringBuilder();
        for (Object c : arr) {
            sb.append((char)((Integer)c).intValue());
        }
        return sb.toString();
    }

    public static enum EMode {
        MODE_0(0, "\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u043f\u043e\u0441\u043b\u0435 \u0441\u0442\u0430\u0440\u0442\u0430"),
        MODE_2(2, "\u0421\u043c\u0435\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430"),
        MODE_3(3, "\u0421\u043c\u0435\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430 \u0431\u043e\u043b\u0435\u0435 24 \u0447\u0430\u0441\u043e\u0432"),
        MODE_4(4, "\u0421\u043c\u0435\u043d\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430"),
        MODE_6(6, "\u041e\u0436\u0438\u0434\u0430\u0435\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b"),
        MODE_8(8, "\u041e\u0442\u043a\u0440\u044b\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043f\u0440\u0438\u0445\u043e\u0434\u0430"),
        MODE_24(24, "\u041e\u0442\u043a\u0440\u044b\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0440\u0430\u0441\u0445\u043e\u0434\u0430"),
        MODE_40(40, "\u041e\u0442\u043a\u0440\u044b\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043f\u0440\u0438\u0445\u043e\u0434\u0430"),
        MODE_56(56, "\u041e\u0442\u043a\u0440\u044b\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0440\u0430\u0441\u0445\u043e\u0434\u0430"),
        MODE_255(255, "\u0424\u0430\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430"),
        MODE_UNK(666, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e");

        private int code;
        private String name;

        private EMode(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public String toString() {
            return "#" + this.code + ":" + this.name;
        }

        public static EMode getMode(int code) {
            for (EMode st : (EMode[])EMode.class.getEnumConstants()) {
                if (st.code != code) continue;
                return st;
            }
            return MODE_UNK;
        }
    }

    public static enum EFNStatus {
        STATUS_0(0, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430"),
        STATUS_1(1, "\u0413\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u044c \u043a \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438"),
        STATUS_3(3, "\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c"),
        STATUS_7(7, "\u041f\u043e\u0441\u0442-\u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c, \u0438\u0434\u0451\u0442 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0432 \u041e\u0424\u0414"),
        STATUS_15(15, "\u0427\u0442\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0430\u0440\u0445\u0438\u0432\u0430 \u0424\u041d"),
        STATUS_UNK(666, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e");

        private int code;
        private String name;

        private EFNStatus(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public String toString() {
            return "#" + this.code + ":" + this.name;
        }

        public static EFNStatus getStatus(int code) {
            for (EFNStatus st : (EFNStatus[])EFNStatus.class.getEnumConstants()) {
                if (st.code != code) continue;
                return st;
            }
            return STATUS_UNK;
        }
    }

    public static enum ECurrentPrinterStatus {
        STATUS_0(0, 1, "\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u0432 \u043e\u0444\u0444\u043b\u0430\u0439\u043d\u0435"),
        STATUS_1(1, 2, "\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0430\u0441\u044c \u0431\u0443\u043c\u0430\u0433\u0430"),
        STATUS_2(2, 4, "\u0411\u0443\u043c\u0430\u0433\u0430 \u0441\u043a\u043e\u0440\u043e \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u0442\u0441\u044f"),
        STATUS_3(3, 8, "\u041e\u0442\u043a\u0440\u044b\u0442\u0430 \u043a\u0440\u044b\u0448\u043a\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430"),
        STATUS_4(4, 16, "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430"),
        STATUS_5(5, 32, "\u041d\u0435\u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430"),
        STATUS_6(6, 64, "\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u043f\u0440\u0438\u0441\u043b\u0430\u043b \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442"),
        STATUS_7(7, 128, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e"),
        STATUS_UNK(666, 666, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e");

        private int bit;
        private String name;

        private ECurrentPrinterStatus(int bit, int val, String name) {
            this.bit = bit;
            this.name = name;
        }

        public String toString() {
            return this.name + "(" + this.bit + ")";
        }

        public static ECurrentPrinterStatus getStatus(int bit) {
            for (ECurrentPrinterStatus st : (ECurrentPrinterStatus[])ECurrentPrinterStatus.class.getEnumConstants()) {
                if (st.bit != bit) continue;
                return st;
            }
            return STATUS_UNK;
        }
    }

    public static enum EFNFlags {
        FLAG_0(0, 1, "\u0421\u0440\u043e\u0447\u043d\u0430\u044f \u0437\u0430\u043c\u0435\u043d\u0430 \u041a\u0421 (\u0434\u043e \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f 3 \u0434\u043d\u044f)"),
        FLAG_1(1, 2, "\u0418\u0441\u0447\u0435\u0440\u043f\u0430\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430 \u041a\u0421 (\u0434\u043e \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f 30 \u0434\u043d\u0435\u0439)"),
        FLAG_2(2, 4, "\u041f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0430\u043c\u044f\u0442\u0438 \u0424\u041d (\u0410\u0440\u0445\u0438\u0432 \u0424\u041d \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043d\u0430 90 %)"),
        FLAG_3(3, 8, "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u041e\u0424\u0414"),
        FLAG_4(4, 16, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e"),
        FLAG_5(5, 32, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e"),
        FLAG_6(6, 64, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e"),
        FLAG_7(7, 128, "\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0424\u041d"),
        FLAG_UNK(666, 666, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e");

        private int bit;
        private String name;

        private EFNFlags(int bit, int val, String name) {
            this.bit = bit;
            this.name = name;
        }

        public String toString() {
            return this.name + "(" + this.bit + ")";
        }

        public static EFNFlags getFlag(int bit) {
            for (EFNFlags st : (EFNFlags[])EFNFlags.class.getEnumConstants()) {
                if (st.bit != bit) continue;
                return st;
            }
            return FLAG_UNK;
        }
    }
}

