<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
<xsl:import href="layout.xsl"/>

<xsl:output encoding="UTF-8" method='html' indent='yes'/>

<xsl:variable name="mid" select="/data/@mid"/>
<xsl:variable name="activateType" select="/data/@activateType"/>

<xsl:template match="/">
	<xsl:call-template name="main">
  		<xsl:with-param name="mode" select="'pub'"/>
  	</xsl:call-template>
</xsl:template>


<xsl:template name="title">
	<xsl:choose>
		<xsl:when test="/data/@action='ContractList'">Активация карты</xsl:when>
		<xsl:otherwise>Активация карты: <xsl:value-of select="/data/@activate"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="/data">
	<xsl:choose>
		<xsl:when test="@action='ContractConfirm'">
			<xsl:call-template name="ContractConfirm"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="ContractCreate"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="ContractCreate">

	<strong>Создание договора по карте</strong>

	<div class="report">
		<form method="post" action="{$PUBEXECUTER}?action=CreateContract&amp;module=card&amp;mid={$mid}">
			<input type="hidden" name="activateType" value="{$activateType}"/>
			<input type="hidden" name="activate" value="1"/>
	
			<table width="500" border="0" cellpadding="0" cellspacing="0">
	
			<xsl:if test="not(/data/contract)">
	
			<xsl:for-each select="/data/errors/error">
			<xsl:choose>
				<xsl:when test="@type = 'param'">
					<tr><td colspan="2">
						<div class="errorMessage"><xsl:value-of select="@desc"/></div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'captcha'">
					<tr><td colspan="2">
						<div class="errorMessage">Введите символы, показанные на картинке</div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'card_pswd_empty'">
					<tr><td colspan="2">
						<div class="errorMessage">Введите PIN-код карты</div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'card_notfound'">
					<tr><td colspan="2">	
						<div class="errorMessage">Карта не найдена</div>						
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'card_pswd'">
					<tr><td colspan="2">
						<div class="errorMessage">Неверный PIN-код карты</div>						
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'card_expired'">
					<tr><td colspan="2">	
						<div class="errorMessage">Карта просрочена</div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'card_blocked'">
					<tr><td colspan="2">
						<div class="errorMessage">Карта заблокирована</div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'card_activated_contract'">
					<tr><td colspan="2">
						<div class="errorMessage">Карта уже активирована</div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'card_activeted_balance'">
					<tr><td colspan="2">
						<div class="errorMessage">Карта уже активирована для пополнения баланса</div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'card_service'">
					<tr><td colspan="2">	
						<div class="errorMessage">Вы не можете активировать эту карту для данной услуги</div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'accept'">
					<tr><td colspan="2">
						<div class="errorMessage">Необходимо принять договор оферты для продолжения</div>
					</td></tr>
				</xsl:when>
				<xsl:when test="@type = 'passwords_not_equal'">
					<tr><td colspan="2">
						<div class="errorMessage">Введенные номера PIN не совпадают</div>
					</td></tr>
				</xsl:when>			
				<xsl:when test="@type = 'other'">
					<tr><td colspan="2">
						<div class="errorMessage"><xsl:value-of select="@desc"/></div>
					</td></tr>
				</xsl:when>
			</xsl:choose>
			</xsl:for-each>

			<xsl:if test="/data/@status='error'">
				<tr><td colspan="2">
					<div class="errorMessage"><xsl:value-of select="/data/text()"/></div>
				</td></tr>
			</xsl:if>	

			<tr><td colspan="2"><hr/></td></tr>

			<xsl:for-each select="/data/params/param">
			<xsl:choose>
				<xsl:when test="@type = 'list'">
				<tr>
					<td><xsl:value-of select="@title"/></td>
					<td align="right">
						<select name="param_{@id}" style="width:250px;text-align:left;">
							<xsl:for-each select="list/item">
								<option value="{@id}">
								<xsl:if test="@id = ../../@value"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
								<xsl:value-of select="@title"/></option>
							</xsl:for-each>
						</select>
					</td>
				</tr>
				</xsl:when>
				<xsl:when test="@type = 'flag'">
				<tr>
					<td colspan="2">
						<label>
						<input type="checkbox" name="param_{@id}" value="1">
						<xsl:if test="@value = '1'"><xsl:attribute name="checked">1</xsl:attribute></xsl:if>
						</input>
						<xsl:value-of select="@title"/>
						</label>
					</td>
				</tr>
				</xsl:when>
				<xsl:when test="@type = 'phone'">
				<tr>
					<td><xsl:value-of select="@title"/></td>
					<td align="right"><input class="phone" name="param_{@id}" type="text" size="30" value="{@value}" style="width:250px;" onInput="doPhoneParamFormat(this);"/><div id="result_param_{@id}" style="color:red;"></div></td>
				</tr>
				</xsl:when>
				<xsl:otherwise>
				<tr>
					<td><xsl:value-of select="@title"/></td>
					<td align="right">
						<input name="param_{@id}" type="text" size="30" value="{@value}" style="width:250px;"/>
					</td>
				</tr>
				</xsl:otherwise>
			</xsl:choose>
			</xsl:for-each>
		
			<xsl:if test="/data/params/@useTariff = '1'">
			<tr>
				<td>Выберите тарифный план:</td>
				<td align="right">
					<select name="tariff" style="width:250px;text-align:left;">
						<xsl:for-each select="/data/tariffs/tariff"><option value="{@id}"><xsl:value-of select="@title"/></option></xsl:for-each>
					</select>
				</td>
			</tr>
			</xsl:if>
		
			<tr><td colspan="2"><label><input type="checkbox" name="accept" value="1"/>Я принимаю договор оферты.</label></td></tr>
			<tr><td colspan="2"><hr/></td></tr>
			<tr><td colspan="2">Введите символы, показанные на картинке:</td></tr>
			<tr>
				<td valign="middle" style="height:50px;">
				<img src="{$PUBEXECUTER}?module=card&amp;action=CreateContract&amp;mid={$mid}&amp;getcaptcha={/data/@rand}&amp;useDigist=true"/></td>
				<td align="right">
				<input type="text" size="30" name="captcha" style="width:250px;"/><br/>
				Буквы вводятся без учета регистра.
				</td>
			</tr>
		
			<tr><td colspan="2">Введите логин и пароль карты:</td></tr>
			<tr>
				<td>Номер карты:</td>
				<td align="right"><input type="text" size="30" name="login" value="" style="width:250px;"/></td>
			</tr>
			<tr>
				<td>PIN-код карты:</td>
				<td align="right"><input type="password" size="30" name="pswd" value="" style="width:250px;"/></td>
			</tr>
			<tr>
				<td>Повторите PIN-код карты:</td>
				<td align="right"><input type="password" size="30" name="pswd2" value="" style="width:250px;"/></td>
			</tr>

			<tr>
				<!-- 
				<td colspan="2" align="right"><input type="submit" value="Создать договор"/></td>
				-->
				<td colspan="2" align="right">
					<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'Создать договор'"/>
					</xsl:call-template>
				</td>
			</tr>

			</xsl:if>
		
			<tr><td colspan="2"><hr/></td></tr>

			<xsl:if test="/data/contract">
				<tr><td colspan="2">
					<div class="infoMessage">
						Договор создан.<br/><br/>
						<xsl:apply-templates select="/data/contract"/>
					</div>
				</td></tr>
			</xsl:if>

			</table>
		</form>
	</div>
	
	<!-- заполняем мэп priceMap[id]=price; -->
	<xsl:text disable-output-escaping="yes">
		<![CDATA[
<script type="text/javascript">
<!--
    	]]>
    </xsl:text>

		function checkLoadFunction()
		{
			if ( typeof sortPrefixs == 'function' )
			{
				sortPrefixs();
			}
			else
			{
				setTimeout( "checkLoadFunction()", 1000 );
			}
		}
		
		prefixs = "<xsl:value-of select="/data/phonesFormats/@format"/>".split(',');
		checkLoadFunction();

	<xsl:text disable-output-escaping="yes">
		<![CDATA[
//-->
</script>   
    	]]>
	</xsl:text>
	
</xsl:template>

<xsl:template match="contract">
	Номер договора <xsl:value-of select="@title"/><br/>
<!-- Пароль web-статистики: <xsl:value-of select="@pswd"/><br/>  -->	
	<xsl:variable name="url"><xsl:value-of select="/data/@statisticUrl"/></xsl:variable>
	Чтобы воспользоваться услугой используйте2 номер/PIN-код карты в качестве логина/пароля.<br/>
	Для операций с договором Вы можете воспользоваться
	<a href="{$url}">страницей статистики</a>.<br/>
	В качестве логина доступа
	используйте номер договора, в качестве пароля - PIN-код карты.
</xsl:template>


<xsl:template name="ContractConfirm">

	<strong>Подтвердите введенные данные </strong>
	<div class="report">
		<form method="post" action="{$PUBEXECUTER}?action=CreateContract&amp;module=card&amp;mid={$mid}">
			<input type="hidden" name="activateType" value="{$activateType}"/>
			<input type="hidden" name="confirm" value="1"/>

			<table width="500" border="0" cellpadding="0" cellspacing="0">
	
				<xsl:for-each select="/data/params/param">
				<xsl:choose>
				<xsl:when test="@type = 'list'">
					<tr>
						<td><xsl:value-of select="@title"/></td>

						<td align="right">
							<select name="param_{@id}" style="width:250px;text-align:left;" disabled="true">
								<xsl:for-each select="list/item">
									<option value="{@id}">
									<xsl:if test="@id = ../../@value"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
									<xsl:value-of select="@title"/></option>
								</xsl:for-each>
							</select>
						</td>
					</tr>
				</xsl:when>
				<xsl:when test="@type = 'flag'">
					<tr>
						<td colspan="2"><label><input type="checkbox" name="param_{@id}" value="1" disabled="true">
						<xsl:if test="@value = '1'"><xsl:attribute name="checked">1</xsl:attribute></xsl:if>
						</input>
						<xsl:value-of select="@title"/></label></td>
					</tr>
				</xsl:when>
				<xsl:when test="@type = 'phone'">
					<tr>
						<td><xsl:value-of select="@title"/></td>
						<td align="right">
							<xsl:value-of select="@value"/>
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td><xsl:value-of select="@title"/></td>
						<td align="right">
							<xsl:value-of select="@value"/>
						</td>
						<xsl:variable name="val" select="@value"/>
					
						<input type="hidden" name="{@id}" value="{@value}">
						<!--  
						<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
						-->
						</input>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		
			</xsl:for-each>

			<tr>
				<td>Номер карты:</td>
				<td align="right">
					<xsl:value-of select="/data/params/@login"/>
				</td>
			</tr>
			
			<!--
			<tr>
				<td colspan="1" align="right"><a href="{$PUBEXECUTER}?action=CreateContract&amp;module=card&amp;mid={$mid}&amp;return=true">Назад</a></td>
				<td colspan="1" align="right"><input type="submit" value="Создать договор"/></td>
			</tr>
			-->
			<tr>
				<td align="right">
					<xsl:call-template name="rawLinkButton">
						<xsl:with-param name="title" select="'Назад'"/>
						<xsl:with-param name="url"><xsl:value-of select="$PUBEXECUTER"/>?action=CreateContract&amp;module=card&amp;mid=<xsl:value-of select="$mid"/>&amp;return=true</xsl:with-param>
						<xsl:with-param name="align" select="'center'"/>
					</xsl:call-template>
				</td>
				<td align="right">
					<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'Создать договор'"/>
					</xsl:call-template>
				</td>
			</tr>

			<tr><td colspan="2"><hr/></td></tr>

			</table>
		</form>
	</div>	
	
</xsl:template>


<xsl:template name="ContractList">


<!--
<form method='post' action='{$PUBEXECUTER}#idDivReport' name='~report'>
	<xsl:call-template name="action"/>	
	
	<xsl:call-template name="filters"/>
	<input type="hidden" name="debug" value="1"/>
	
	<xsl:call-template name="~report">
		<xsl:with-param name="node" select="aliases"/>
		<xsl:with-param name="data">

		<table cellspacing='1' style="width:700px;">
		<thead>
		<tr>
			<td>Номер</td>
			<td>ФИО</td>
			<td>Email</td>
        </tr>
		</thead>
		<tbody>
		<xsl:for-each select="aliases/alias">
		<tr>
			<td><xsl:value-of select="@alias"/></td>
			<td><xsl:value-of select="@fio"/></td>
			<td><xsl:value-of select="@email"/></td>
		</tr>
		</xsl:for-each>
		</tbody>
		</table>

	</xsl:with-param>
	</xsl:call-template>
	
</form>
-->

	<form method="post" action="{$PUBEXECUTER}#idDivReport">
		<xsl:call-template name="action"/>	
		<xsl:call-template name="filters"/>
		<input type="hidden" name="debug" value="1"/>
	</form>

	<div class="report">

		<xsl:call-template name="pagesBar">
			<xsl:with-param name="node" select="aliases"/>
			<xsl:with-param name="action" select="$PUBEXECUTER"/>
			<xsl:with-param name="data">
				<xsl:call-template name="action"/>
				<xsl:call-template name="filters_hidden"/>
				<input type="hidden" name="debug" value="1"/>				
			</xsl:with-param>
		</xsl:call-template>

		<table class="table800">
		<thead>
			<tr>
				<td>Номер</td>
				<td>ФИО</td>
				<td>Email</td>
       		</tr>
		</thead>
		<tbody>
			<xsl:for-each select="aliases/alias">
			<tr>
				<td><xsl:value-of select="@alias"/></td>
				<td><xsl:value-of select="@fio"/></td>
				<td><xsl:value-of select="@email"/></td>
			</tr>
			</xsl:for-each>
		</tbody>
		</table>

	</div>

</xsl:template>


<xsl:template name="filters">
	<table class="filter">
		<tr>
			<td>Номер:</td>
			<td><input type="text" name="alias" size="8" value="{/data/@alias}"/></td>
			<td>ФИО:</td>
			<td><input type="text" name="fio" size="25" value="{/data/@fio}"/></td>
			<td>Email:</td>
			<td><input type="text" name="email" size="20" value="{/data/@email}"/></td>
			<td style="text-align: right; padding-right: 22px;">
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template>
			</td>
		</tr>
	</table>
</xsl:template>


<xsl:template name="filters_hidden">
	<input type="hidden" name="alias" value="{/data/@alias}"/>
	<input type="hidden" name="fio" value="{/data/@fio}"/>
	<input type="hidden" name="email" value="{/data/@email}"/>	
</xsl:template>


</xsl:stylesheet>
