/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.web;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.DPayment;
import ru.bitel.bgbilling.modules.card.server.bean.DPaymentList;
import ru.bitel.bgbilling.modules.card.server.bean.DPaymentManager;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.util.FileDownload;

@Deprecated
public class ActionReportDealers
extends ActionBase {
    public void doAction() throws SQLException, BGException, BGException {
        if (this.cid <= 0 && this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Period period = this.getPeriodByYearsAndDays();
        String items = this.getParameterValues("items");
        Page page = this.getPage();
        List selected = Utils.toIntegerList((String)items);
        Element itemsEl = this.createElement(this.rootNode, "items");
        DealerManager dm = new DealerManager(this.con, this.mid);
        List<Dealer> itemList = dm.getDealersByContractId(this.cid, 2);
        block0: for (Dealer item : itemList) {
            Element itemEl = this.addListItem(itemsEl, item.getId(), item.getTitle());
            for (Integer id : selected) {
                if (id.intValue() != item.getId()) continue;
                itemEl.setAttribute("selected", "1");
                selected.remove(id);
                continue block0;
            }
        }
        if (items != null) {
            boolean file = "1".equals(this.getParameter("file", null));
            String output = this.getParameter("output", "html");
            boolean zip = "1".equals(this.getParameter("zip", null));
            if (file) {
                page.setPageSize(-1);
            }
            DPaymentManager dman = new DPaymentManager((Preferences)this.moduleSetup, this.con, this.mid);
            List<DPaymentList> list = dman.getDealerPaymentReport(items, period.getDateFrom(), period.getDateTo(), page);
            int totalNumber = 0;
            BigDecimal totalCost = BigDecimal.ZERO;
            Element dealers = this.createElement(this.rootNode, "dealers");
            for (int i = 0; i < list.size(); ++i) {
                DPaymentList dplist = list.get(i);
                Element dealer = this.createElement(dealers, "dealer");
                dealer.setAttribute("title", this.getDealerTitle(dplist, itemList));
                for (int j = 0; j < dplist.getPaymentList().size(); ++j) {
                    DPayment dp = dplist.getPaymentList().get(j);
                    Element payment = this.createElement(dealer, "payment");
                    payment.setAttribute("trans", dp.getTransId());
                    payment.setAttribute("datetime", TimeUtils.format((Date)dp.getDateTime(), (String)"dd.MM.yyyy HH:mm:ss"));
                    payment.setAttribute("contract", dp.getContractTitle());
                    payment.setAttribute("pt", dp.getPaymentComment());
                    payment.setAttribute("summa", Utils.formatCost((BigDecimal)dp.getSumma()));
                }
                dealer.setAttribute("totalnumber", String.valueOf(dplist.getNumber()));
                dealer.setAttribute("totalsumm", Utils.formatCost((float)dplist.getTotal()));
                totalNumber += dplist.getNumber();
                totalCost = totalCost.add(BigDecimal.valueOf(dplist.getTotal()));
            }
            page.setRecordCount(totalNumber);
            this.setPageAttribute(dealers, page);
            dealers.setAttribute("totalnumber", String.valueOf(totalNumber));
            dealers.setAttribute("totalsumm", Utils.formatCost((BigDecimal)totalCost));
            if (file) {
                String contentType;
                String ext;
                String xsl;
                Thread.currentThread().setPriority(1);
                this.request.setAttribute("contentType", (Object)"binary");
                if ("html".equals(output)) {
                    xsl = "card_idealer_payments.xsl";
                    ext = ".html";
                    contentType = "text/html";
                } else {
                    xsl = "card_idealer_payments_csv.xsl";
                    ext = ".csv";
                    contentType = "application/csv";
                }
                ContractDao contractDao = new ContractDao(this.con, 0);
                Contract contract = (Contract)contractDao.get(this.cid);
                String fileName = FileDownload.transliterationFileName((String)((String)(contract != null ? contract.getTitle() + "_" : "") + "dpayments_" + period.getDateFromCalendar().get(1) + "_" + period.getDateToCalendar().get(2) + "1"));
                this.rootNode.setAttribute("contractTitle", contract.getTitle());
                this.rootNode.setAttribute("comment", contract.getComment());
                this.rootNode.setAttribute("date1", TimeUtils.formatDate((Date)period.getDateFrom()));
                this.rootNode.setAttribute("date2", TimeUtils.formatDate((Date)period.getDateTo()));
                XSLManager.getInstance().transform(this.response, xsl, (Source)new DOMSource(this.rootNode.getOwnerDocument()), null, contentType, fileName + ext, zip);
            }
        }
    }

    private String getDealerTitle(DPaymentList list, List<Dealer> dealerlist) {
        if (list.getPaymentList() != null && list.getPaymentList().size() > 0) {
            int listid = list.getPaymentList().get(0).getDealerId();
            for (Dealer d : dealerlist) {
                if (d.getId() != listid) continue;
                return d.getTitle();
            }
        }
        return "";
    }
}

