/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;

public class BotStatisticTableModel
extends BGTableModel<StatisticNote> {
    private BotManagerService botManagerService;
    private final List<Bot> bots = new ArrayList<Bot>();
    private final List<BotDialog> dialogs = new ArrayList<BotDialog>();

    public BotStatisticTableModel(String name, BotManagerService botManagerService) {
        super(name);
        this.botManagerService = botManagerService;
    }

    protected void initColumns() {
        this.addColumnId();
        this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, -1, -1, "contractId", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", Column.DateTime.class, -1, 150, -1, "lastMessageTime", true);
        this.addColumn("\u0411\u043e\u0442", -1, 150, -1, "botId", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("ID \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", Long.class, -1, -1, -1, "messengerUserId", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0451\u043d\u043d\u044b\u0439 \u0434\u0438\u0430\u043b\u043e\u0433", -1, -1, -1, "lastViewedDialogId", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
    }

    public Object getValueAt(StatisticNote note, int column) throws BGException {
        String identifier = this.getIdentifier(column);
        if ("botId".equals(identifier)) {
            Optional<Bot> bot = this.bots.stream().filter(b -> b.getId() == note.getBotId()).findFirst();
            return bot.isPresent() ? bot.get().getTitle() : Integer.valueOf(note.getBotId());
        }
        if ("lastViewedDialogId".equals(identifier)) {
            Optional<BotDialog> dialog = this.dialogs.stream().filter(d -> d.getId() == note.getLastViewedDialogId()).findFirst();
            return dialog.isPresent() ? dialog.get().getTitle() : Integer.valueOf(note.getLastViewedDialogId());
        }
        return super.getValueAt((Object)note, column);
    }

    public void setData(List<StatisticNote> data) {
        try {
            this.bots.clear();
            this.bots.addAll(this.botManagerService.getBots());
            this.dialogs.clear();
            this.dialogs.addAll(this.botManagerService.getDialogs());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        super.setData(data);
    }
}

