/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.client.contract;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGControlPanelPluginControls;
import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.contract.PaymentAndChargeEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.xml.ws.soap.SOAPFaultException;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.kernel.contract.balance.client.PaymentAndChargeTreeTablePanel;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusCharge;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGSwingUtilites;

public class ContractPaymentBonusPanel
extends BGPanel
implements BGControlPanelPluginControls.IPluginControls {
    private PaymentAndChargeEditor editor = null;
    private FloatTextField summa = null;
    private BGButtonPanelRestoreOkCancelHelp okPanel = null;
    private PaymentAndChargeTreeTablePanel pcPanel = null;
    private BGControlPanelDateNoB date;
    private int cid;
    private JCheckBox payWithBonus = new JCheckBox();
    private JPanel hiddenPanel = new JPanel(new GridBagLayout());
    private SummaTextField balanceBonusField = new SummaTextField();
    private SummaTextField sumBonusField = new SummaTextField();
    private SummaTextField sumRealField = new SummaTextField();
    private JLabel errorText = new JLabel();
    private BigDecimal percent = null;
    private BigDecimal balanceBonus;
    private BigDecimal maxBonusRealSum;
    private BigDecimal rate;
    private int id = 0;
    private BonusCharge bonusEditCharge = null;
    private Charge chargeEdit = null;
    private BonusService service;
    private Preferences pluginSetup;

    public ContractPaymentBonusPanel() throws BGIllegalAccessException {
        try {
            this.service = (BonusService)this.getContext().getPort(BonusService.class);
            this.pluginSetup = ClientSetup.getInstance().getPluginParameterPreferences("ru.bitel.bgbilling.plugins.bonus");
            this.jbInit();
            this.payWithBonus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (ContractPaymentBonusPanel.this.payWithBonus.isSelected()) {
                        ContractPaymentBonusPanel.this.update();
                        ContractPaymentBonusPanel.this.hiddenPanel.setVisible(true);
                        ContractPaymentBonusPanel.this.summa.setEditable(false);
                    } else {
                        ContractPaymentBonusPanel.this.hiddenPanel.setVisible(false);
                        ContractPaymentBonusPanel.this.summa.setEditable(true);
                        BGSwingUtilites.setEnabled((Component)ContractPaymentBonusPanel.this.okPanel, (boolean)true);
                        ContractPaymentBonusPanel.this.errorText.setText("\u0421\u043e\u0432\u0435\u0442: \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0442\u0435 \u0436\u0435\u043b\u0430\u0435\u043c\u0443\u044e \u0431\u043e\u043d\u0443\u0441\u043d\u0443\u044e \u0441\u0443\u043c\u043c\u0443");
                        ContractPaymentBonusPanel.this.errorText.setForeground(Color.BLACK);
                    }
                }
            });
            this.sumBonusField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent arg0) {
                    if (ContractPaymentBonusPanel.this.payWithBonus.isSelected()) {
                        BigDecimal _maxBonusRealSum;
                        boolean isNegativeBalance = ContractPaymentBonusPanel.this.pluginSetup.getBoolean("balance.negative", false);
                        BigDecimal mainSum = Utils.parseBigDecimal((String)ContractPaymentBonusPanel.this.summa.getText(), (BigDecimal)BigDecimal.ZERO);
                        BigDecimal bonusRealSum = Utils.parseBigDecimal((String)ContractPaymentBonusPanel.this.sumBonusField.getText(), (BigDecimal)BigDecimal.ZERO).divide(ContractPaymentBonusPanel.this.rate, 3, RoundingMode.HALF_EVEN).stripTrailingZeros();
                        BigDecimal contractSum = mainSum.subtract(bonusRealSum);
                        ContractPaymentBonusPanel.this.errorText.setForeground(Color.RED);
                        BGSwingUtilites.setEnabled((Component)ContractPaymentBonusPanel.this.okPanel, (boolean)false);
                        if (bonusRealSum.compareTo(BigDecimal.ZERO) != 1 || bonusRealSum.compareTo(ContractPaymentBonusPanel.this.maxBonusRealSum) == 1 && !isNegativeBalance || contractSum.compareTo(BigDecimal.ZERO) < 0) {
                            ContractPaymentBonusPanel.this.errorText.setText("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430 \u0440\u0430\u0441\u0445\u043e\u0434\u0430 \u0438\u043b\u0438 \u0431\u043e\u043d\u0443\u0441\u043e\u0432");
                            if (ContractPaymentBonusPanel.this.balanceBonus.compareTo(BigDecimal.ZERO) == 0 && !isNegativeBalance) {
                                ContractPaymentBonusPanel.this.errorText.setText("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0431\u043e\u043d\u0443\u0441\u043e\u0432");
                            }
                            if (ContractPaymentBonusPanel.this.percent != null) {
                                if (ContractPaymentBonusPanel.this.percent.compareTo(BigDecimal.ZERO) > 0) {
                                    ContractPaymentBonusPanel.this.payWithBonus.setText("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438 (\u043c\u0430\u043a\u0441. " + ContractPaymentBonusPanel.this.percent.setScale(0, RoundingMode.DOWN) + "%)");
                                } else {
                                    ContractPaymentBonusPanel.this.payWithBonus.setText("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438");
                                    ContractPaymentBonusPanel.this.errorText.setText("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0430\u0441\u0445\u043e\u0434");
                                }
                            } else {
                                ContractPaymentBonusPanel.this.errorText.setText("\u041e\u043f\u043b\u0430\u0442\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u0440\u0430\u0441\u0445\u043e\u0434\u0430 \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
                                ContractPaymentBonusPanel.this.payWithBonus.setText("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438");
                            }
                            return;
                        }
                        if (isNegativeBalance && bonusRealSum.compareTo(_maxBonusRealSum = mainSum.multiply(ContractPaymentBonusPanel.this.percent.divide(new BigDecimal(100)), new MathContext(0, RoundingMode.DOWN))) > 0) {
                            ContractPaymentBonusPanel.this.errorText.setText("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0446\u0435\u043d\u0442!");
                            return;
                        }
                        ContractPaymentBonusPanel.this.errorText.setText("\u0421\u043e\u0432\u0435\u0442: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0436\u0435\u043b\u0430\u0435\u043c\u0443\u044e \u0431\u043e\u043d\u0443\u0441\u043d\u0443\u044e \u0441\u0443\u043c\u043c\u0443");
                        ContractPaymentBonusPanel.this.errorText.setForeground(Color.BLACK);
                        String sumReal = "?";
                        Object bonusString = ContractPaymentBonusPanel.this.balanceBonus.stripTrailingZeros().toPlainString();
                        if (bonusRealSum.scale() == 3) {
                            ContractPaymentBonusPanel.this.errorText.setText("\u0421\u0443\u043c\u043c\u0430 \u0431\u043e\u043d\u0443\u0441\u043e\u0432 \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435 \u043a\u0440\u0430\u0442\u043d\u0430\u044f \u0431\u043e\u043d\u0443\u0441\u043d\u0443\u043c\u0443 \u043a\u0443\u0440\u0441\u0443");
                            ContractPaymentBonusPanel.this.errorText.setForeground(Color.BLUE);
                        } else {
                            sumReal = contractSum.stripTrailingZeros().toPlainString();
                            bonusString = (String)bonusString + " - " + ContractPaymentBonusPanel.this.sumBonusField.getText() + " = " + ContractPaymentBonusPanel.this.balanceBonus.subtract(Utils.parseBigDecimal((String)ContractPaymentBonusPanel.this.sumBonusField.getText(), (BigDecimal)BigDecimal.ZERO)).stripTrailingZeros().toPlainString();
                        }
                        ContractPaymentBonusPanel.this.sumRealField.setText(sumReal);
                        ContractPaymentBonusPanel.this.balanceBonusField.setText((String)bonusString);
                        BGSwingUtilites.setEnabled((Component)ContractPaymentBonusPanel.this.okPanel, (boolean)true);
                    }
                }
            });
        }
        catch (SOAPFaultException e) {
            throw new BGIllegalAccessException();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit() throws Exception {
        this.payWithBonus.setSelected(false);
        this.balanceBonusField.setEditable(false);
        this.balanceBonusField.setBorder(new TitledBorder("\u0411\u043e\u043d\u0443\u0441\u043d\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
        this.sumBonusField.setBorder(new TitledBorder("\u0421\u0443\u043c\u043c\u0430 \u0441 \u0431\u043e\u043d\u0443\u0441\u043e\u0432"));
        this.sumRealField.setEditable(false);
        this.sumRealField.setBorder(new TitledBorder("\u0421\u0443\u043c\u043c\u0430 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        this.errorText.setText("\u0421\u043e\u0432\u0435\u0442: \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0442\u0435 \u0436\u0435\u043b\u0430\u0435\u043c\u0443\u044e \u0431\u043e\u043d\u0443\u0441\u043d\u0443\u044e \u0441\u0443\u043c\u043c\u0443");
        this.errorText.setFont(new Font(this.errorText.getFont().getName(), 1, this.errorText.getFont().getSize()));
        this.errorText.setForeground(Color.BLACK);
        this.hiddenPanel = new JPanel(new GridBagLayout());
        this.hiddenPanel.setVisible(false);
        this.hiddenPanel.add((Component)((Object)this.balanceBonusField), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 10), 0, 0));
        this.hiddenPanel.add((Component)((Object)this.sumBonusField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 1, new Insets(10, 0, 0, 10), 0, 0));
        this.hiddenPanel.add((Component)((Object)this.sumRealField), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.hiddenPanel.add((Component)this.errorText, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.payWithBonus, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.hiddenPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.payWithBonus.setText("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438");
        this.rate = new BigDecimal(this.service.rate());
    }

    public boolean beforeAdd(Component owner, Object ... data) {
        block6: {
            try {
                if (!(owner instanceof PaymentAndChargeEditor)) break block6;
                this.editor = (PaymentAndChargeEditor)owner;
                this.cid = this.editor.getContractId();
                this.okPanel = this.editor.getOkPanel();
                this.pcPanel = this.editor.getPcPanel();
                this.date = this.editor.getDatePanel();
                this.id = this.editor.getId();
                if (this.cid <= 0 || !this.service.pluginInclude(this.cid)) break block6;
                this.summa = this.editor.getSummaTextField();
                if (this.id > 0) {
                    this.bonusEditCharge = this.service.chargeBonus(this.id);
                    if (this.bonusEditCharge == null) {
                        return false;
                    }
                    try {
                        this.chargeEdit = ((ChargeService)this.getContext().getPort(ChargeService.class)).chargeGet(this.id);
                    }
                    catch (BGException e1) {
                        this.getContext().processException((Throwable)e1);
                    }
                    this.payWithBonus.setSelected(true);
                    this.payWithBonus.setEnabled(false);
                    this.hiddenPanel.setVisible(true);
                    this.summa.setEditable(false);
                    this.date.setEnabled(false);
                }
                this.summa.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        ContractPaymentBonusPanel.this.update();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        ContractPaymentBonusPanel.this.update();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        ContractPaymentBonusPanel.this.update();
                    }
                });
                this.pcPanel.getTreeTable().addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent arg0) {
                        block5: {
                            if (ContractPaymentBonusPanel.this.pcPanel.getSelectedId() != null) {
                                try {
                                    int pecentInt = ContractPaymentBonusPanel.this.service.percentOfBonus(ContractPaymentBonusPanel.this.pcPanel.getSelectedId().intValue());
                                    if (pecentInt <= 0) {
                                        ContractPaymentBonusPanel.this.percent = null;
                                        break block5;
                                    }
                                    ContractPaymentBonusPanel.this.percent = new BigDecimal(pecentInt);
                                }
                                catch (BGException e) {
                                    ContractPaymentBonusPanel.this.getContext().processException((Throwable)e);
                                }
                            } else {
                                ContractPaymentBonusPanel.this.percent = BigDecimal.ZERO;
                            }
                        }
                        ContractPaymentBonusPanel.this.update();
                    }
                });
                return true;
            }
            catch (BGException e) {
                this.getContext().processException((Throwable)e);
            }
        }
        return false;
    }

    public void doSetData(Component owner, Object ... data) {
        try {
            boolean result = false;
            if (this.editor.getMode() == 1) {
                if (this.id > 0 && this.service.chargeBonus(this.id) != null) {
                    this.summa.setText(this.service.chargeBonus(this.id).getSum().divide(this.rate).add(this.chargeEdit.getSum()).stripTrailingZeros().toPlainString());
                }
                result = true;
            }
            this.setVisible(result);
            this.update();
        }
        catch (BGException e) {
            e.printStackTrace();
        }
    }

    public boolean beforeAction(Component owner, Object ... data) {
        if (this.payWithBonus.isSelected()) {
            if (this.id < 1 && this.date.getDateCalendar().compareTo(TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)Calendar.getInstance())) != 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0411\u043e\u043d\u0443\u0441\u043d\u044b\u0439 \u0440\u0430\u0441\u0445\u043e\u0434 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0434\u0430\u0442\u0443!");
                return false;
            }
            boolean isNegativeBalance = this.pluginSetup.getBoolean("balance.negative", false);
            BigDecimal bonusRealSum = Utils.parseBigDecimal((String)this.sumBonusField.getText(), (BigDecimal)BigDecimal.ZERO).divide(this.rate, 3, RoundingMode.HALF_EVEN).stripTrailingZeros();
            if (bonusRealSum.compareTo(BigDecimal.ZERO) > 0 && (bonusRealSum.compareTo(this.maxBonusRealSum) != 1 || isNegativeBalance)) {
                BigDecimal delta = Utils.parseBigDecimal((String)this.summa.getText(), (BigDecimal)BigDecimal.ZERO).subtract(bonusRealSum);
                this.summa.setText(delta.stripTrailingZeros().toPlainString());
                this.sumBonusField.setText(this.round(bonusRealSum.multiply(this.rate)).stripTrailingZeros().toPlainString());
                return true;
            }
            return false;
        }
        return true;
    }

    public void doAction(Component owner, Object ... data) {
        try {
            if (this.payWithBonus.isSelected() && data[0] instanceof String) {
                int idCharge = Utils.parseInt((String)((String)data[0]), (int)-1);
                BigDecimal bonusSum = Utils.parseBigDecimal((String)this.sumBonusField.getText(), (BigDecimal)BigDecimal.ZERO);
                if (idCharge == -1 || !this.service.chargeUpdate(this.cid, new BonusCharge(this.id, this.id > 0 ? this.bonusEditCharge.getDate() : new Date(), bonusSum, idCharge))) {
                    if (this.id > 0) {
                        ((ChargeService)this.getContext().getPort(ChargeService.class)).chargeUpdate(this.chargeEdit);
                    } else if (idCharge > 0) {
                        ((ChargeService)this.getContext().getPort(ChargeService.class)).chargeDelete(this.cid, idCharge);
                    }
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043f\u0438\u0441\u0430\u0442\u044c \u0411\u043e\u043d\u0443\u0441\u044b, \u0440\u0430\u0441\u0445\u043e\u0434 \u043e\u0442\u043c\u0435\u043d\u0435\u043d!");
                }
            }
        }
        catch (Exception e) {
            this.getContext().processException((Throwable)e);
        }
    }

    private void update() {
        try {
            BonusCharge bonusCharge = this.service.chargeBonus(this.id);
            Calendar cal = Calendar.getInstance();
            if (this.id > 0 && bonusCharge != null) {
                cal.setTime(bonusCharge.getDate());
                cal.add(13, -1);
            }
            this.balanceBonus = this.round(this.service.balanceAdvanced(this.cid, cal.getTime(), bonusCharge == null ? null : Integer.valueOf(bonusCharge.getId()), true));
            this.balanceBonusField.setText(this.balanceBonus.stripTrailingZeros().toPlainString());
            if (this.editor != null && this.summa != null) {
                BigDecimal sum = Utils.parseBigDecimal((String)this.summa.getText(), (BigDecimal)BigDecimal.ZERO);
                if (this.percent == null || this.pcPanel.getSelectedId() == null) {
                    this.maxBonusRealSum = BigDecimal.ZERO;
                } else {
                    BigDecimal sumd = bonusCharge != null ? this.balanceBonus.divide(this.rate) : null;
                    this.maxBonusRealSum = this.service.bonusSummaMaxAdvanced(this.cid, this.pcPanel.getSelectedId().intValue(), sum, false, sumd);
                }
                if (this.id > 0 && bonusCharge != null) {
                    this.sumBonusField.setText(bonusCharge.getSum().stripTrailingZeros().toPlainString());
                    this.sumRealField.setText(sum.subtract(bonusCharge.getSum().divide(this.rate)).stripTrailingZeros().toPlainString());
                } else {
                    this.sumBonusField.setText(this.maxBonusRealSum.multiply(this.rate).stripTrailingZeros().toPlainString());
                    this.sumRealField.setText(sum.subtract(this.maxBonusRealSum).stripTrailingZeros().toPlainString());
                }
            }
        }
        catch (Exception e) {
            this.getContext().processException((Throwable)e);
        }
    }

    private BigDecimal round(BigDecimal value) {
        return value.setScale(0, RoundingMode.DOWN);
    }

    class SummaTextField
    extends BGTextField {
        SummaTextField() {
            Font font = this.getFont();
            this.setFont(new Font(font.getName(), 1, font.getSize() + 7));
            this.setHorizontalAlignment(0);
        }
    }
}

