/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.CheckTree;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.bean.NumerationPool;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.bgbilling.modules.bill.common.service.NumerationPoolService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;

public class DocTypePanel
extends BGUPanel {
    private DocumentType type = DocumentType.BILL;
    private DocTypeTableModel model;
    private BillService billService = null;
    private BGComboBox<ComboBoxItem> typeCombo = new BGComboBox();
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            DocTypePanel.this.model.setData(DocTypePanel.this.getBillService().docTypeList(DocTypePanel.this.type));
        }
    };

    protected void jbInit() {
        this.model = new DocTypeTableModel(DocTypePanel.class.getName());
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DocTypePanel.this.performAction("edit");
                }
            }
        });
        BGEditor editor = new BGEditor();
        editor.setMinimumSize(new Dimension(200, 300));
        editor.setPreferredSize(new Dimension(200, 300));
        editor.addForm((JComponent)((Object)new DocTypeEditor()));
        editor.setVisible(false);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u0412\u0438\u0434 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.typeCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.typeCombo.addItem((Object)new ComboBoxItem((Object)DocumentType.BILL, "\u0421\u0447\u0435\u0442\u0430"));
        this.typeCombo.addItem((Object)new ComboBoxItem((Object)DocumentType.INVOICE, "\u0421\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u044b, \u0423\u041f\u0414"));
        this.typeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocTypePanel.this.type = (DocumentType)((ComboBoxItem)DocTypePanel.this.typeCombo.getSelectedItem()).getObject();
                DocTypePanel.this.performAction("switchType");
                DocTypePanel.this.performAction("refresh");
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    private BillService getBillService() {
        if (this.billService == null) {
            this.billService = (BillService)((ClientContext)this.getContext()).getPort(BillService.class);
        }
        return this.billService;
    }

    class DocTypeTableModel
    extends BGTableModel<DocType> {
        public DocTypeTableModel(String name) {
            super(name, DocType.class);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0418\u043c\u044f \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", 100, 300, 500, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("XSL \u0448\u0430\u0431\u043b\u043e\u043d", 100, 200, 300, "pattern", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    }

    class DocTypeEditor
    extends BGUPanel {
        private DocType current = null;
        private BGTextField titleTf = new BGTextField();
        private BGTextField patternTf = new BGTextField();
        private JTextArea commentTa = new JTextArea();
        private BGUCheckList<IdTitle> posList = new BGUCheckList();
        private JCheckBox subContractPositions = new JCheckBox("\u041f\u043e\u0437\u0438\u0446\u0438\u0438 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0445 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        private JCheckBox nsubContractPositions = new JCheckBox("\u041f\u043e\u0437\u0438\u0446\u0438\u0438 \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0445 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        private BGConfigEditorPane configArea = new BGConfigEditorPane();
        private JCheckBox strongLessZero = new JCheckBox("\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u0441\u0443\u043c\u043c\u0435 \u0441\u0447\u0435\u0442\u0430 < 0");
        private JCheckBox lessOrEqualZero = new JCheckBox("\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u0441\u0443\u043c\u043c\u0435 \u0441\u0447\u0435\u0442\u0430 <= 0");
        private JTabbedPane editorTabs = new JTabbedPane();
        private BGUComboBox<NumerationPool> npCombo = new BGUComboBox();
        private ModTreeNode rootNodeXmlConsist = this.createNode("\u0412\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", null, 0, "0");
        private ModTreeNode contractNodeXmlConsist = this.createNode("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", null, 0, "0");
        private ModTreeNode modulesNodeXmlConsist = this.createNode("\u041c\u043e\u0434\u0443\u043b\u0438", null, 0, "0");
        private ModTreeNode pluginsNodeXmlConsist = this.createNode("\u041f\u043b\u0430\u0433\u0438\u043d\u044b", null, 0, "0");
        private CheckTree treeXmlConsist = new CheckTree(this.rootNodeXmlConsist);

        DocTypeEditor() {
        }

        private void getPositions() {
            try {
                List data = DocTypePanel.this.type == DocumentType.BILL ? DocTypePanel.this.getBillService().positionList(DocumentType.BILL) : DocTypePanel.this.getBillService().positionList(DocumentType.INVOICE);
                this.posList.setData(data != null ? data : new ArrayList());
            }
            catch (Exception ex) {
                ((ClientContext)this.getContext()).processException((Throwable)ex);
            }
        }

        private void fillNPCombo() {
            try {
                this.npCombo.setData(((NumerationPoolService)((ClientContext)this.getContext()).getPort(NumerationPoolService.class)).numerationPoolList());
            }
            catch (Exception ex) {
                ((ClientContext)this.getContext()).processException((Throwable)ex);
            }
        }

        protected void jbInit() {
            this.titleTf.setMinimumSize(new Dimension(200, 24));
            this.titleTf.setPreferredSize(new Dimension(300, 24));
            this.strongLessZero.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DocTypeEditor.this.strongLessZero.isSelected()) {
                        DocTypeEditor.this.lessOrEqualZero.setSelected(false);
                    }
                }
            });
            this.lessOrEqualZero.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DocTypeEditor.this.lessOrEqualZero.isSelected()) {
                        DocTypeEditor.this.strongLessZero.setSelected(false);
                    }
                }
            });
            this.posList.setBorder((Border)BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u041f\u043e\u0437\u0438\u0446\u0438\u0438 "), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            JPanel mainEditorTab = new JPanel(new GridBagLayout());
            mainEditorTab.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            mainEditorTab.add((Component)this.titleTf, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            mainEditorTab.add((Component)new JLabel("XSL \u0448\u0430\u0431\u043b\u043e\u043d:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            mainEditorTab.add((Component)this.patternTf, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            mainEditorTab.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            mainEditorTab.add((Component)new JScrollPane(this.commentTa), new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            mainEditorTab.add((Component)this.posList, new GridBagConstraints(2, 0, 1, 7, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            JPanel configEditorTab = new JPanel(new GridBagLayout());
            configEditorTab.add((Component)new JLabel("\u041f\u0443\u043b \u043d\u043e\u043c\u0435\u0440\u043e\u0432:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            configEditorTab.add((Component)this.npCombo, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            configEditorTab.add((Component)this.strongLessZero, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            configEditorTab.add((Component)this.lessOrEqualZero, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            configEditorTab.add((Component)this.subContractPositions, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            configEditorTab.add((Component)this.nsubContractPositions, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            configEditorTab.add(Box.createVerticalGlue(), new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            configEditorTab.add((Component)new JScrollPane((Component)this.configArea), new GridBagConstraints(1, 0, 1, 7, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            JPanel xml\u0421onsistEditorTab = new JPanel(new GridBagLayout());
            xml\u0421onsistEditorTab.add((Component)new JScrollPane((Component)this.treeXmlConsist), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.editorTabs.addTab("\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435", mainEditorTab);
            this.editorTabs.addTab("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430", configEditorTab);
            this.editorTabs.addTab("\u0421\u043e\u0441\u0442\u0430\u0432 XML", xml\u0421onsistEditorTab);
            this.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
            this.setLayout(new GridBagLayout());
            this.add(this.editorTabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("renewDirectory", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    try {
                        DocTypeEditor.this.editorTabs.setSelectedIndex(0);
                        DocTypeEditor.this.getPositions();
                        DocTypeEditor.this.fillNPCombo();
                        if (DocTypeEditor.this.contractNodeXmlConsist.getChildCount() == 0) {
                            MapHolder map = DocTypePanel.this.getBillService().xmlComposition();
                            DocTypeEditor.this.buildBranch((MapHolder<Integer, List<IdTitle>>)map, 0);
                            DocTypeEditor.this.buildBranch((MapHolder<Integer, List<IdTitle>>)map, 1);
                            DocTypeEditor.this.buildBranch((MapHolder<Integer, List<IdTitle>>)map, 2);
                            ClientUtils.expandTree((JTree)DocTypeEditor.this.treeXmlConsist, (DefaultMutableTreeNode)DocTypeEditor.this.rootNodeXmlConsist);
                        }
                    }
                    catch (BGException e1) {
                        ((ClientContext)DocTypeEditor.this.getContext()).processException((Throwable)e1);
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("switchType", "\u0421\u043c\u0435\u043d\u0430 \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DocTypeEditor.this.performActionClose();
                    DocTypeEditor.this.getPositions();
                }
            };
            new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DocTypeEditor.this.performAction("renewDirectory");
                    DocTypeEditor.this.current = new DocType();
                    DocTypeEditor.this.current.setDocumentType(DocTypePanel.this.type);
                    DocTypeEditor.this.current.setId(-1);
                    DocTypeEditor.this.titleTf.setText("");
                    DocTypeEditor.this.patternTf.setText("");
                    DocTypeEditor.this.commentTa.setText("");
                    DocTypeEditor.this.posList.setSelected(false);
                    DocTypeEditor.this.lessOrEqualZero.setSelected(false);
                    DocTypeEditor.this.strongLessZero.setSelected(false);
                    DocTypeEditor.this.subContractPositions.setSelected(false);
                    DocTypeEditor.this.nsubContractPositions.setSelected(false);
                    DocTypeEditor.this.configArea.setText("");
                    DocTypeEditor.this.npCombo.setSelectedItem((Object)DocTypePanel.this.type);
                    DocTypeEditor.this.treeXmlConsist.selNodes(DocTypeEditor.this.rootNodeXmlConsist);
                    DocTypeEditor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DocTypeEditor.this.current = (DocType)DocTypePanel.this.model.getSelectedRow();
                    if (DocTypeEditor.this.current != null) {
                        DocTypeEditor.this.performAction("renewDirectory");
                        DocTypeEditor.this.titleTf.setText(DocTypeEditor.this.current.getTitle());
                        DocTypeEditor.this.patternTf.setText(DocTypeEditor.this.current.getPattern());
                        DocTypeEditor.this.commentTa.setText(DocTypeEditor.this.current.getComment());
                        DocTypeEditor.this.posList.setSelected((Collection)DocTypeEditor.this.current.getPositionList());
                        DocTypeEditor.this.lessOrEqualZero.setSelected(DocTypeEditor.this.current.isCreateWhenLessOrEqZero());
                        DocTypeEditor.this.strongLessZero.setSelected(!DocTypeEditor.this.lessOrEqualZero.isSelected() && DocTypeEditor.this.current.isCreateWhenStronglyLessZero());
                        DocTypeEditor.this.subContractPositions.setSelected(DocTypeEditor.this.current.isSubContractPositions());
                        DocTypeEditor.this.nsubContractPositions.setSelected(DocTypeEditor.this.current.isNSubContractPositions());
                        DocTypeEditor.this.configArea.setText(DocTypeEditor.this.current.getSetupString());
                        DocTypeEditor.this.npCombo.setSelectedItem((Object)DocTypeEditor.this.current.getNpid());
                        DocTypeEditor.this.setSelectedNodes();
                        DocTypeEditor.this.performActionOpen();
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DocTypeEditor.this.current = (DocType)DocTypePanel.this.model.getSelectedRow();
                    if (DocTypeEditor.this.current != null && DocTypeEditor.this.current.getId() >= 0 && BGSwingUtilites.confirmDelete((Object)DocTypeEditor.this.current)) {
                        DocTypePanel.this.getBillService().docTypeDelete(DocTypeEditor.this.current.getId());
                        DocTypePanel.this.model.deleteRow(DocTypeEditor.this.current);
                        DocTypeEditor.this.performActionClose();
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (DocTypeEditor.this.current != null) {
                        DocTypeEditor.this.current.setTitle(DocTypeEditor.this.titleTf.getText());
                        DocTypeEditor.this.current.setPattern(DocTypeEditor.this.patternTf.getText());
                        DocTypeEditor.this.current.setComment(DocTypeEditor.this.commentTa.getText());
                        DocTypeEditor.this.current.setPositionList(DocTypeEditor.this.posList.getSelectedIds());
                        DocTypeEditor.this.current.setCreateWhenLessOrEqZero(DocTypeEditor.this.lessOrEqualZero.isSelected());
                        DocTypeEditor.this.current.setCreateWhenStronglyLessZero(DocTypeEditor.this.strongLessZero.isSelected());
                        DocTypeEditor.this.current.setSubContractPositions(DocTypeEditor.this.subContractPositions.isSelected());
                        DocTypeEditor.this.current.setNSubContractPositions(DocTypeEditor.this.nsubContractPositions.isSelected());
                        DocTypeEditor.this.current.setSetupString(DocTypeEditor.this.configArea.getText());
                        DocTypeEditor.this.current.setNpid(((NumerationPool)DocTypeEditor.this.npCombo.getSelectedItem()).getId());
                        DocTypeEditor.this.current.setXmlContractConsist(Utils.toIntegerSet((String)DocTypeEditor.this.treeXmlConsist.getCodes(DocTypeEditor.this.contractNodeXmlConsist, true)));
                        DocTypeEditor.this.current.setXmlModulesConsist(Utils.toIntegerSet((String)DocTypeEditor.this.treeXmlConsist.getCodes(DocTypeEditor.this.modulesNodeXmlConsist, true)));
                        DocTypeEditor.this.current.setXmlPluginsConsist(Utils.toIntegerSet((String)DocTypeEditor.this.treeXmlConsist.getCodes(DocTypeEditor.this.pluginsNodeXmlConsist, true)));
                        DocTypePanel.this.getBillService().docTypeUpdate(DocTypeEditor.this.current);
                        DocTypePanel.this.performAction("refresh");
                        DocTypeEditor.this.performActionClose();
                    }
                }
            };
        }

        private void buildBranch(MapHolder<Integer, List<IdTitle>> mapHolder, int key) {
            if (key == 0) {
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "leaf", 2, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "leaf", 1, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0411\u0430\u043b\u0430\u043d\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "leaf", 3, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0422\u0430\u0440\u0438\u0444\u044b", "leaf", 4, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b", "leaf", 5, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043e\u043f\u0446\u0438\u0438", "leaf", 6, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0423\u0441\u043b\u0443\u0433\u0438", "leaf", 7, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041e\u0431\u044a\u0435\u043a\u0442\u044b", "leaf", 9, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438", "leaf", 8, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041a\u043b\u0438\u0435\u043d\u0442", "leaf", 10, "0"));
                this.rootNodeXmlConsist.add((MutableTreeNode)this.contractNodeXmlConsist);
                return;
            }
            List list = (List)mapHolder.getMap().get(key);
            if (list != null) {
                ModTreeNode node = key == 1 ? this.modulesNodeXmlConsist : this.pluginsNodeXmlConsist;
                this.rootNodeXmlConsist.add((MutableTreeNode)node);
                for (IdTitle idTitle : list) {
                    node.add((MutableTreeNode)this.createNode(idTitle.getTitle(), "leaf", idTitle.getId(), "0"));
                }
            }
        }

        private void setSelectedNodes() {
            this.treeXmlConsist.deselectNode(this.rootNodeXmlConsist);
            this.treeXmlConsist.setNodeSelect(this.contractNodeXmlConsist, Utils.toSet((String)Utils.toString((Iterable)this.current.getXmlContractConsist())));
            this.treeXmlConsist.setNodeSelect(this.modulesNodeXmlConsist, Utils.toSet((String)Utils.toString((Iterable)this.current.getXmlModulesConsist())));
            this.treeXmlConsist.setNodeSelect(this.pluginsNodeXmlConsist, Utils.toSet((String)Utils.toString((Iterable)this.current.getXmlPluginsConsist())));
            this.treeXmlConsist.updateUI();
        }

        private ModTreeNode createNode(String title, String icon, int id, String type) {
            ModTreeNode node = new ModTreeNode(title, icon);
            node.setAttribute("id", (Object)("" + id));
            node.setAttribute("type", (Object)type);
            return node;
        }
    }
}

