/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.service;

import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.service.AttributeService;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeDao;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeTypeDao;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.bill.common.service.AttributeService")
public class AttributeServiceImpl
extends AbstractService
implements AttributeService {
    private AttributeDao attributeDao = null;
    private AttributeTypeDao attributeTypeDao = null;

    private AttributeDao getAttributeDao() throws BGIllegalArgumentException {
        if (this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (this.attributeDao == null) {
            this.attributeDao = new AttributeDao(this.getConnection(), this.moduleId);
        }
        return this.attributeDao;
    }

    private AttributeTypeDao getAttributeTypeDao() throws BGIllegalArgumentException {
        if (this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (this.attributeTypeDao == null) {
            this.attributeTypeDao = new AttributeTypeDao(this.getConnection(), this.moduleId);
        }
        return this.attributeTypeDao;
    }

    public void updateAttributeType(AttributeType attributeType) throws BGException, BGMessageException {
        if (attributeType == null || Utils.isBlankString((String)attributeType.getName()) || Utils.isBlankString((String)attributeType.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        this.getAttributeTypeDao().update(attributeType);
    }

    public void deleteAttributeType(int attributeTypeId) throws BGException, BGMessageException {
        this.getAttributeTypeDao().delete(attributeTypeId);
    }

    public List<AttributeType> attributeTypeList() throws BGException, BGMessageException {
        return this.getAttributeTypeDao().getAttributeTypeList();
    }

    public List<Attribute> attributeList(int contractId) throws BGException, BGMessageException {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return this.getAttributeDao().getAttributeListByCid(contractId);
    }

    public void updateAttribute(Attribute attribute) throws BGException, BGMessageException {
        if (attribute == null || attribute.getContractId() <= 0) {
            throw new BGIllegalArgumentException();
        }
        this.getAttributeDao().update(attribute);
    }

    public void deleteAttribute(int contractId, int attributeId) throws BGException, BGMessageException {
        if (contractId <= 0 || attributeId < 1) {
            throw new BGIllegalArgumentException();
        }
        this.getAttributeDao().delete(attributeId);
    }
}

