/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class AssistantDao
extends AbstractIdDao<AssistantAction> {
    private static final String TABLE_ASSISTANT_ACTION_USER_GROUP = "assistant_action_user_group";

    public AssistantDao(Connection con) {
        super(con, 0, "assistant_action");
    }

    public List<AssistantActionItem> assistantAstions() throws BGException {
        ArrayList<AssistantActionItem> list = new ArrayList<AssistantActionItem>();
        try (Statement statement = this.con.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT id, action_id, title, dependent, sort FROM " + this.tableName + " ORDER BY title");
            while (resultSet.next()) {
                AssistantActionItem item = new AssistantActionItem();
                item.setId(resultSet.getInt("id"));
                item.setActionId(resultSet.getString("action_id"));
                item.setTitle(resultSet.getString("title"));
                item.setDependent(resultSet.getInt("dependent") == 1);
                item.setSort(resultSet.getInt("sort"));
                list.add(item);
            }
            resultSet.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public void updateSortListAssistantAction(List<AssistantActionItem> assistantActions) throws BGException {
        String query = "UPDATE " + this.tableName + " SET sort=? WHERE id=?";
        try (PreparedStatement preparedStatement = this.con.prepareStatement(query);){
            for (AssistantActionItem assistantAction : assistantActions) {
                preparedStatement.setInt(1, assistantAction.getSort());
                preparedStatement.setInt(2, assistantAction.getId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<AssistantActionItem> assistantAstions(int userId) throws BGException {
        ArrayList<AssistantActionItem> list = new ArrayList<AssistantActionItem>();
        try {
            PreparedStatement psSelect = this.con.prepareStatement("SELECT DISTINCT aa.* FROM " + this.tableName + " AS aa LEFT JOIN assistant_action_user_group AS aaug ON aa.id=aaug.action_id WHERE aaug.user_group_id IN ( SELECT gid FROM bgs_user_group WHERE uid=? )");
            psSelect.setInt(1, userId);
            ResultSet resultSet = psSelect.executeQuery();
            while (resultSet.next()) {
                AssistantActionItem item = new AssistantActionItem();
                item.setId(resultSet.getInt("id"));
                item.setActionId(resultSet.getString("action_id"));
                item.setTitle(resultSet.getString("title"));
                item.setDependent(resultSet.getInt("dependent") == 1);
                item.setSort(resultSet.getInt("sort"));
                list.add(item);
            }
            resultSet.close();
            psSelect.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public AssistantAction get(int id) throws BGException {
        AssistantAction assistantAction = (AssistantAction)super.get(id);
        assistantAction.setUserGroupIds(this.getUserGroupIds(assistantAction.getId()));
        return assistantAction;
    }

    protected AssistantAction getFromRS(ResultSet rs) throws SQLException, BGException {
        AssistantAction assistantAction = new AssistantAction();
        assistantAction.setId(rs.getInt("id"));
        assistantAction.setTitle(rs.getString("title"));
        assistantAction.setConfig(rs.getString("config"));
        assistantAction.setActionId(rs.getString("action_id"));
        assistantAction.setActionClass(rs.getString("action_class"));
        assistantAction.setDependent(rs.getInt("dependent"));
        assistantAction.setSort(rs.getInt("sort"));
        return assistantAction;
    }

    protected void updateImpl(AssistantAction assistantAction) throws BGException, SQLException {
        try {
            String sqlSet = " SET  title=?, config=?, action_id=?, action_class=?, dependent=?, sort=?";
            if (assistantAction.getId() > 0) {
                int parameterIndex = 1;
                PreparedStatement psUpdate = this.con.prepareStatement("UPDATE " + this.tableName + sqlSet + " WHERE id=?");
                psUpdate.setString(parameterIndex++, assistantAction.getTitle());
                psUpdate.setString(parameterIndex++, assistantAction.getConfig());
                psUpdate.setString(parameterIndex++, assistantAction.getActionId());
                psUpdate.setString(parameterIndex++, assistantAction.getActionClass());
                psUpdate.setInt(parameterIndex++, assistantAction.getDependent());
                psUpdate.setInt(parameterIndex++, assistantAction.getSort());
                psUpdate.setInt(parameterIndex, assistantAction.getId());
                psUpdate.executeUpdate();
                psUpdate.close();
            } else {
                String query = "SELECT if( isnull( max(sort) ), 1, max(sort) + 1 ) FROM " + this.tableName;
                int sort = 0;
                PreparedStatement ps = this.con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    sort = rs.getInt(1);
                }
                ps.close();
                int parameterIndex = 1;
                PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + sqlSet, 1);
                psInsert.setString(parameterIndex++, assistantAction.getTitle());
                psInsert.setString(parameterIndex++, assistantAction.getConfig());
                psInsert.setString(parameterIndex++, assistantAction.getActionId());
                psInsert.setString(parameterIndex++, assistantAction.getActionClass());
                psInsert.setInt(parameterIndex++, assistantAction.getDependent());
                psInsert.setInt(parameterIndex, sort);
                psInsert.executeUpdate();
                psInsert.close();
                assistantAction.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
            PreparedStatement psDelete = this.con.prepareStatement("DELETE  FROM assistant_action_user_group WHERE action_id=?");
            psDelete.setInt(1, assistantAction.getId());
            psDelete.executeUpdate();
            psDelete.close();
            List userGroupIds = assistantAction.getUserGroupIds();
            if (userGroupIds != null && !userGroupIds.isEmpty()) {
                PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO assistant_action_user_group SET action_id=?, user_group_id=?");
                psInsert.setInt(1, assistantAction.getId());
                for (Integer userGroupId : userGroupIds) {
                    psInsert.setInt(2, userGroupId);
                    psInsert.executeUpdate();
                }
                psInsert.close();
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        try {
            PreparedStatement psDelete = this.con.prepareStatement("DELETE  FROM assistant_action_user_group WHERE action_id=?");
            psDelete.setInt(1, id);
            psDelete.executeUpdate();
            psDelete.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return super.deleteImpl(id);
    }

    public AssistantAction getByActionId(String actionId) throws BGException {
        AssistantAction assistantAction = (AssistantAction)this.get("action_id=?", new Object[]{actionId});
        if (assistantAction != null) {
            assistantAction.setUserGroupIds(this.getUserGroupIds(assistantAction.getId()));
        }
        return assistantAction;
    }

    public List<Integer> getUserGroupIds(int id) throws BGException {
        ArrayList<Integer> userGroupIds = new ArrayList<Integer>();
        try {
            PreparedStatement psSelect = this.con.prepareStatement("SELECT user_group_id FROM assistant_action_user_group WHERE action_id=?");
            psSelect.setInt(1, id);
            ResultSet rs = psSelect.executeQuery();
            while (rs.next()) {
                userGroupIds.add(rs.getInt(1));
            }
            rs.close();
            psSelect.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return userGroupIds;
    }
}

