/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.server.task.AssistRecurringRunTask;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class AssistPaymentRecurringManager {
    private Connection con;
    private int mid;

    public AssistPaymentRecurringManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
    }

    public int add(AssistPaymentRecurring pr) throws BGException {
        int result = 0;
        try {
            String query = "INSERT INTO assist_payment_recurring_" + this.mid + " (cid, date, amount, ordernumber, recurringMinAmount, recurringMaxAmount, recurringPeriod, recurringMaxDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, pr.getCid());
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)pr.getDate()));
            ps.setBigDecimal(3, pr.getAmount());
            ps.setLong(4, pr.getOrdernumber());
            ps.setBigDecimal(5, pr.getRecurringMinAmount());
            ps.setBigDecimal(6, pr.getRecurringMaxAmount());
            ps.setInt(7, pr.getRecurringPeriod());
            ps.setDate(8, TimeUtils.convertDateToSqlDate((Date)pr.getRecurringMaxDate()));
            ps.executeUpdate();
            result = ServerUtils.lastInsertId((PreparedStatement)ps);
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public static AssistPaymentRecurring getRecurringFromRS(ResultSet rs, boolean contractTitle) throws SQLException {
        AssistPaymentRecurring payment = new AssistPaymentRecurring();
        payment.setId(rs.getInt("id"));
        payment.setCid(rs.getInt("cid"));
        if (contractTitle) {
            payment.setContractTitle(rs.getString("con_title"));
            payment.setContractComment(rs.getString("con_comment"));
        }
        payment.setDate((Date)rs.getTimestamp("date"));
        payment.setAmount(rs.getBigDecimal("amount"));
        payment.setBillnumber(rs.getLong("billnumber"));
        payment.setOrdernumber(rs.getInt("ordernumber"));
        payment.setRecurringMinAmount(rs.getBigDecimal("recurringMinAmount"));
        payment.setRecurringMaxAmount(rs.getBigDecimal("recurringMaxAmount"));
        payment.setRecurringPeriod(rs.getInt("recurringPeriod"));
        payment.setRecurringMaxDate((Date)rs.getDate("recurringMaxDate"));
        return payment;
    }

    public boolean updateBillnumber(long ordernumber, int cid, long billnumber) throws BGException {
        boolean result = false;
        try {
            String query = "UPDATE assist_payment_recurring_" + this.mid + " SET billnumber=? WHERE ordernumber=? AND cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, billnumber);
            ps.setLong(2, ordernumber);
            ps.setInt(3, cid);
            result = ps.executeUpdate() > 0;
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<AssistPaymentRecurring> getRecurringList(int cid) throws BGException {
        ArrayList<AssistPaymentRecurring> result = new ArrayList<AssistPaymentRecurring>();
        try {
            String query = "SELECT apr.*, contract.title AS con_title, contract.comment AS con_comment  FROM assist_payment_recurring_" + this.mid + " as apr  LEFT JOIN contract ON contract.id=apr.cid  WHERE (CURDATE()<=apr.recurringMaxDate) ";
            if (cid > 0) {
                query = query + " AND (apr.cid=?) ";
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int i = 1;
            if (cid > 0) {
                ps.setInt(i++, cid);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(AssistPaymentRecurringManager.getRecurringFromRS(rs, true));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public AssistPaymentRecurring getRecurringForCid(int cid) throws BGException {
        List<AssistPaymentRecurring> list = this.getRecurringList(cid);
        return list.isEmpty() ? null : list.get(0);
    }

    public void deleteRecurringForCid(int cid) throws BGException {
        try {
            String query = "DELETE FROM assist_payment_recurring_" + this.mid + " WHERE cid=" + cid;
            Statement st = this.con.createStatement();
            st.executeUpdate(query);
            st.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void runRecurring(int cid, BigDecimal sum) {
        new RunTaskDataManager(this.con).addTask((RunTask)new AssistRecurringRunTask(this.mid, cid, sum));
    }
}

