/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.bean;

import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.alfabank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final Logger log = LogManager.getLogger();
    private static final String ORDER_STATUS_REGISTER = "0";
    private static final String ORDER_STATUS_APPROVED = "1";
    private static final String ORDER_STATUS_DEPOSITED = "2";
    private static final String ORDER_STATUS_REVERSED = "3";
    private static final String ORDER_STATUS_REFUNDED = "4";
    private static final String ORDER_STATUS_AUTHORIZATION = "5";

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "alfabank_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("contract_id"));
        transaction.setContractTitle(rs.getString("contract_title"));
        transaction.setPaymentId(rs.getInt("payment_id"));
        transaction.setCreateDate((Date)rs.getTimestamp("create_date"));
        transaction.setTransactionId(rs.getString("order_id"));
        transaction.setTransactionDate((Date)rs.getTimestamp("transaction_date"));
        transaction.setStatus(rs.getString("status"));
        transaction.setParameters(rs.getString("params"));
        transaction.setSum(rs.getBigDecimal("sum"));
        transaction.setAutopayment(rs.getBoolean("autopayment"));
        return transaction;
    }

    protected Transaction getImpl(int transactionId) throws BGException, SQLException {
        PreparedStatement ps = this.getByIdPS;
        if (ps == null) {
            ps = this.getByIdPS = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title FROM " + this.tableName + " AS pt LEFT JOIN contract AS c ON c.id=pt.contract_id WHERE pt.id=?");
        }
        ps.setInt(1, transactionId);
        ResultSet rs = ps.executeQuery();
        Transaction result = rs.next() ? this.getFromRS(rs) : null;
        rs.close();
        return result;
    }

    public boolean update(Transaction transaction, TransactionStatus newTransactionStatus) throws BGException {
        boolean result = false;
        if (transaction != null && newTransactionStatus != null) {
            try {
                StringBuilder query = new StringBuilder("UPDATE ").append(this.tableName).append(" SET ").append("status=?").append(" WHERE ").append("status=? AND id=?");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setString(index++, newTransactionStatus.getCode());
                ps.setString(index++, transaction.getStatus());
                ps.setInt(index++, transaction.getId());
                result = ps.executeUpdate() > 0;
                ps.close();
                if (result) {
                    transaction.setStatus(newTransactionStatus.getCode());
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            try {
                String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?, autopayment=?";
                int id = transaction.getId();
                StringBuilder query = new StringBuilder(id > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?, autopayment=?").append(id > 0 ? " WHERE id=?" : "");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getTransactionId());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                ps.setBoolean(index++, transaction.isAutopayment());
                if (id > 0) {
                    ps.setInt(index++, id);
                }
                ps.executeUpdate();
                if (id < 1) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void doCheckRequest(int contractId, boolean autopaymentTransaction) throws BGException {
        Page page = new Page(1, 25);
        String[] sort = new String[]{"createDate:1"};
        SearchResult searchResult = new SearchResult(null, page, sort);
        this.searchTransaction(searchResult, contractId, null, TransactionStatus.NEW.getCode(), autopaymentTransaction);
        for (Transaction transaction : searchResult.getList()) {
            JSONObject resultJsonObject;
            boolean error;
            block35: {
                block34: {
                    String orderStatus;
                    String errorCode;
                    String orderId = transaction.getTransactionId();
                    log.debug("alfabankTransactionId = {}", (Object)transaction.getId());
                    log.debug("alfabankTransactionOrderId = {}", (Object)orderId);
                    if (orderId == null) {
                        transaction.setStatus(TransactionStatus.ERROR.getCode());
                        this.update(transaction);
                        continue;
                    }
                    String userName = this.getUserName(autopaymentTransaction);
                    String userPswd = this.getUserPswd(autopaymentTransaction);
                    try {
                        userName = URLEncoder.encode(userName, "UTF-8");
                        userPswd = URLEncoder.encode(userPswd, "UTF-8");
                        orderId = URLEncoder.encode(orderId, "UTF-8");
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                    }
                    StringBuilder spec = new StringBuilder();
                    spec.append(this.moduleSetup.get("alfabank.rest.order.status.url", "https://test.paymentgate.ru/testpayment/rest/getOrderStatus.do")).append("?language=").append(this.moduleSetup.get("alfabank.rest.language", "ru")).append("&orderId=").append(orderId).append("&userName=").append(userName).append("&password=").append(userPswd);
                    log.debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)spec.toString());
                    StringBuilder resultJson = null;
                    try {
                        resultJson = this.doConnection(spec.toString(), "GET", true, null);
                        log.debug("\t\u041e\u0442\u0432\u0435\u0442: {}", (Object)String.valueOf(resultJson));
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage());
                    }
                    error = false;
                    resultJsonObject = new JSONObject(resultJson.toString());
                    String string = errorCode = resultJsonObject.has("ErrorCode") ? String.valueOf(resultJsonObject.get("ErrorCode")) : null;
                    if (errorCode != null && !ORDER_STATUS_REGISTER.equals(errorCode)) break block34;
                    String orderNumber = resultJsonObject.has("OrderNumber") ? String.valueOf(resultJsonObject.get("OrderNumber")) : null;
                    String string2 = orderStatus = resultJsonObject.has("OrderStatus") ? String.valueOf(resultJsonObject.get("OrderStatus")) : null;
                    if (orderStatus == null) break block35;
                    if (ORDER_STATUS_AUTHORIZATION.equals(orderStatus)) continue;
                    if (ORDER_STATUS_REGISTER.equals(orderStatus) || ORDER_STATUS_APPROVED.equals(orderStatus)) break block35;
                    if (ORDER_STATUS_DEPOSITED.equals(orderStatus)) {
                        if (!transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                            log.error("Transaction for ID = {} has status != 'created'", (Object)orderNumber);
                        } else if (transaction.getPaymentId() > 0) {
                            log.error("Transaction for ID = {} has paymentId > 0", (Object)orderNumber);
                        } else {
                            String bindingId;
                            this.addTransactionPayment(transaction, this.getParamString(resultJsonObject, transaction.getParameters()));
                            String clientId = resultJsonObject.has("clientId") ? String.valueOf(resultJsonObject.get("clientId")) : null;
                            String string3 = bindingId = resultJsonObject.has("bindingId") ? String.valueOf(resultJsonObject.get("bindingId")) : null;
                            if (clientId != null && bindingId != null) {
                                PeriodWithTime period;
                                AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
                                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                                if (autopayment != null && (period = autopayment.getPeriod()) != null && period.getDateFrom() == null) {
                                    period.setLocalDateTimeFrom(LocalDateTime.now());
                                    autopayment.setAccessToken(bindingId);
                                    autopaymentManager.updateAutopayment(autopayment);
                                }
                                autopaymentManager.close();
                            }
                        }
                    } else if (ORDER_STATUS_REVERSED.equals(orderStatus) || ORDER_STATUS_REFUNDED.equals(orderStatus)) {
                        if (!transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                            log.error("Transaction for ID = {} has status != 'ok'", (Object)orderNumber);
                            error = true;
                        } else if (transaction.getPaymentId() < 1) {
                            log.error("Transaction for ID = {} has paymentId < 1", (Object)orderNumber);
                            error = true;
                        } else {
                            Payment payment = null;
                            try (PaymentDao paymentDao = new PaymentDao(this.con);){
                                payment = (Payment)paymentDao.get(transaction.getPaymentId());
                                paymentDao.delete(transaction.getPaymentId());
                            }
                            transaction.setStatus(TransactionStatus.ERROR.getCode());
                            transaction.setPaymentId(0);
                            this.update(transaction);
                            if (payment != null) {
                                try (BalanceUtils bu = new BalanceUtils(this.con);){
                                    bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                                }
                                EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum().negate()));
                            }
                        }
                    } else {
                        error = true;
                    }
                    break block35;
                }
                error = true;
            }
            if (!error) continue;
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setTransactionDate(new Date());
            transaction.setParameters(this.getParamString(resultJsonObject, transaction.getParameters()));
            this.update(transaction);
        }
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId, String returnUrl) throws BGException {
        if (autopaymentTransaction || requestBindingId) {
            AlfabankAutopaymentSumEvent event = new AlfabankAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((AlfabankAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        Transaction transaction = new Transaction();
        transaction.setSum(sum);
        transaction.setContractId(contractId);
        transaction.setCreateDate(new Date());
        transaction.setAutopayment(autopaymentTransaction);
        this.update(transaction);
        String userName = this.getUserName(autopaymentTransaction);
        String userPswd = this.getUserPswd(autopaymentTransaction);
        String description = this.moduleSetup.get("alfabank.rest.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}");
        description = description.replace("{CONTRACT_TITLE}", contractTitle);
        try {
            userName = URLEncoder.encode(userName, "UTF-8");
            userPswd = URLEncoder.encode(userPswd, "UTF-8");
            description = URLEncoder.encode(description, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int currency = this.moduleSetup.getInt("alfabank.rest.currency", 0);
        try {
            returnUrl = Utils.isBlankString((String)returnUrl) ? URLEncoder.encode(this.moduleSetup.get("alfabank.rest.return.url", ""), "UTF-8") : URLEncoder.encode(returnUrl, "UTF-8");
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
        String billingName = this.moduleSetup.get("alfabank.billing.name", Setup.getSetup().get("billing.name"));
        StringBuilder spec = new StringBuilder();
        spec.append(this.moduleSetup.get("alfabank.rest.register.url", "https://test.paymentgate.ru/testpayment/rest/register.do")).append("?amount=").append(sum.multiply(new BigDecimal(100)).setScale(0)).append(currency > 0 ? "&currency=" : "").append(currency > 0 ? Integer.valueOf(currency) : "").append("&language=").append(this.moduleSetup.get("alfabank.rest.language", "ru")).append("&orderNumber=").append(transaction.getId()).append("&userName=").append(userName).append("&password=").append(userPswd).append("&description=").append(description).append("&returnUrl=").append(returnUrl);
        if (requestBindingId) {
            StringBuilder clientId = new StringBuilder();
            if (billingName != null) {
                clientId.append(billingName).append("_");
            }
            clientId.append(this.moduleId).append("_").append(contractId);
            spec.append("&clientId=").append(clientId.toString());
        }
        log.debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)spec.toString());
        StringBuilder resultJson = null;
        try {
            resultJson = this.doConnection(spec.toString(), "GET", true, null);
            log.debug("\t\u041e\u0442\u0432\u0435\u0442: {}", (Object)String.valueOf(resultJson));
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
        try {
            JSONObject resultJsonObject = new JSONObject(resultJson.toString());
            for (String key : new String[]{"orderId", "formUrl", "errorCode", "errorMessage"}) {
                if (!resultJsonObject.has(key)) continue;
                dataMap.put(key, resultJsonObject.get(key));
            }
        }
        catch (JSONException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
        if (dataMap.containsKey("orderId")) {
            transaction.setParameters("orderId=" + dataMap.get("orderId"));
            transaction.setTransactionId(String.valueOf(dataMap.get("orderId")));
            this.update(transaction);
        } else if (dataMap.containsKey("errorCode")) {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setParameters("errorCode=" + dataMap.get("errorCode") + "\nerrorMessage=" + dataMap.get("errorMessage"));
            this.update(transaction);
        } else {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setParameters("resultJson=" + resultJson.toString());
            this.update(transaction);
        }
        return transaction;
    }

    public String paymentOrderBinding(Transaction transaction, Autopayment autopayment) {
        String result = null;
        if (transaction != null && autopayment != null) {
            String userName = this.moduleSetup.get("alfabank.autopayment.rest.user.name", "autopaymentUser");
            String userPswd = this.moduleSetup.get("alfabank.autopayment.rest.user.pswd", "autopaymentPassword");
            String bindingId = autopayment.getAccessToken();
            try {
                userName = URLEncoder.encode(userName, "UTF-8");
                userPswd = URLEncoder.encode(userPswd, "UTF-8");
                bindingId = URLEncoder.encode(bindingId, "UTF-8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String url = this.moduleSetup.get("alfabank.rest.order.binding.url", "https://test.paymentgate.ru/testpayment/rest/paymentOrderBinding.do");
            StringBuilder spec = new StringBuilder().append("language=").append(this.moduleSetup.get("alfabank.rest.language", "ru")).append("&mdOrder=").append(transaction.getTransactionId()).append("&bindingId=").append(bindingId).append("&userName=").append(userName).append("&password=").append(userPswd);
            log.debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)url);
            log.debug("\t\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: {}", (Object)spec.toString());
            StringBuilder resultJson = null;
            try {
                resultJson = this.doConnection(url, "POST", true, spec.toString());
                log.debug("\t\u041e\u0442\u0432\u0435\u0442: {}", (Object)String.valueOf(resultJson));
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            if (resultJson != null) {
                StringBuilder resultData = new StringBuilder();
                JSONObject resultJsonObject = new JSONObject(resultJson.toString());
                if (resultJsonObject != null) {
                    if (resultJsonObject.has("errorCode")) {
                        resultData.append("errorCode=").append(resultJsonObject.getString("errorCode")).append("\n");
                    }
                    if (resultJsonObject.has("info")) {
                        resultData.append("info=").append(resultJsonObject.getString("info")).append("\n");
                    }
                    if (resultJsonObject.has("redirect")) {
                        resultData.append("redirect=").append(resultJsonObject.getString("redirect")).append("\n");
                    }
                    result = resultData.toString();
                }
            }
        }
        return result;
    }

    public void addTransactionPayment(Transaction transaction, String transactionParameters) throws BGException {
        if (this.update(transaction, TransactionStatus.APPROVED)) {
            Payment payment = new Payment();
            payment.setContractId(transaction.getContractId());
            payment.setSum(transaction.getSum());
            payment.setDate(new Date());
            payment.setTypeId(this.moduleSetup.getInt("alfabank.payment.type.id", 0));
            payment.setComment(this.moduleSetup.get("alfabank.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0410\u043b\u044c\u0444\u0430 \u0431\u0430\u043d\u043a\u0430").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
            PaymentDao paymentDao = new PaymentDao(this.con);
            paymentDao.update((Object)payment);
            paymentDao.close();
            BalanceUtils balanceUtils = new BalanceUtils(this.con);
            balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            balanceUtils.close();
            transaction.setPaymentId(payment.getId());
            transaction.setTransactionDate(new Date());
            transaction.setParameters(transactionParameters);
            this.update(transaction);
            EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
        }
    }

    private String getParamString(JSONObject resultJsonObject, String params) {
        StringBuilder builder = new StringBuilder(params);
        if (resultJsonObject != null) {
            Iterator iterator = resultJsonObject.keySet().iterator();
            while (iterator.hasNext()) {
                String key = String.valueOf(iterator.next());
                Object value = resultJsonObject.get(key);
                if (key == null || value == null) continue;
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(key).append("=").append(value);
            }
        }
        return builder.toString();
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(this.moduleSetup.getInt("alfabank.request.timeout", 10000));
    }

    private String getUserName(boolean autopayment) {
        return autopayment ? this.moduleSetup.get("alfabank.autopayment.rest.user.name", "autopaymentUser") : this.moduleSetup.get("alfabank.rest.user.name", "user");
    }

    private String getUserPswd(boolean autopayment) {
        return autopayment ? this.moduleSetup.get("alfabank.autopayment.rest.user.pswd", "autopaymentPassword") : this.moduleSetup.get("alfabank.rest.user.pswd", "password");
    }
}

