/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.agr.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.modules.agr.server.bean.TransactionManager;

public class Module
extends ModuleBase {
    private static final Logger log = LogManager.getLogger();

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.agr.server"};
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        Connection con = serverContext.getConnection();
        try (TransactionManager transactionDao = new TransactionManager(con, moduleId);){
            ContractDeleteEvent contractDeleteEvent;
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (contractCreateEvent.isCheck()) {
                    // empty if block
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                transactionDao.deleteTransactionByContractId(contractId);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

