/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.Constants;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u042e\u041a\u0430\u0441\u0441\u0430")
public class ActionDoTransaction
extends AbstractAction {
    private final String moduleName = "yoomoney";

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage());
            transactionManager.searchTransactionList((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        ArrayList<String[]> paymentTypes = new ArrayList<String[]>();
        String paymentTypesString = this.moduleSetup.get("yoomoney.payment.types", null);
        if (paymentTypesString != null) {
            for (String paymentTypeItem : paymentTypesString.split(";")) {
                paymentTypes.add(paymentTypeItem.split(":"));
            }
        } else {
            for (Map.Entry paymentType : this.moduleSetup.subIndexed("paymentType.").entrySet()) {
                String[] paymentTypeData = new String[]{((ParameterMap)paymentType.getValue()).get("paymentType"), ((ParameterMap)paymentType.getValue()).get("title")};
                paymentTypes.add(paymentTypeData);
            }
        }
        if (!paymentTypes.isEmpty()) {
            this.context.getRequest().setAttribute("paymentTypes", paymentTypes);
        }
        this.context.getRequest().setAttribute("paymentSumAmount", (Object)this.moduleSetup.get("yoomoney.payment.sum.amount", this.moduleSetup.get("paymentSumAmount", null)));
        this.context.getRequest().setAttribute("paymentSumPercent", (Object)this.moduleSetup.get("yoomoney.payment.sum.percent", this.moduleSetup.get("paymentSumPercent", "0")));
        this.paymentForm("yoomoney", Constants.class, AutopaymentManager.class);
    }

    public void pay() throws Exception {
        String formUrl;
        block15: {
            if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
                throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
            }
            BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal sumMin = this.moduleSetup.getBigDecimal("yoomoney.sum.min", new BigDecimal(100));
            BigDecimal sumMax = this.moduleSetup.getBigDecimal("yoomoney.sum.max", new BigDecimal(5000));
            String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                this.execute();
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
            }
            String paymentType = this.req.get("paymentType");
            String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
            String merchantReceipt = "";
            if (this.moduleSetup.getBoolean("yoomoney.fiscalization.enable", false)) {
                String customerContact = "";
                if (!Utils.isBlankString((String)customerAddress)) {
                    customerContact = customerAddress;
                }
                JSONObject priceJSON = new JSONObject();
                priceJSON.put("amount", (Object)sum);
                JSONObject itemJSON = new JSONObject();
                itemJSON.put("quantity", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.qty", 1));
                itemJSON.put("price", (Object)priceJSON);
                itemJSON.put("tax", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.tax", 2));
                itemJSON.put("text", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
                itemJSON.put("paymentMethodType", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.method.type", "full_prepayment"));
                itemJSON.put("paymentSubjectType", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.subject.type", "service"));
                JSONArray itemsJSON = new JSONArray();
                itemsJSON.put((Object)itemJSON);
                JSONObject merchantReceiptJSON = new JSONObject();
                merchantReceiptJSON.put("customerContact", (Object)customerContact);
                merchantReceiptJSON.put("taxSystem", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.tax.system", 1));
                merchantReceiptJSON.put("items", (Object)itemsJSON);
                try {
                    merchantReceipt = "&ym_merchant_receipt=" + URLEncoder.encode(merchantReceiptJSON.toString(), "UTF-8");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            formUrl = "";
            if (this.moduleSetup.get("yoomoney.api.key") != null) {
                try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
                    JSONObject data = transactionManager.getPaymentRequestJSON(sum, this.contractId, contractTitle);
                    String resultJson = transactionManager.doPaymentRequest(data.toString(), Setup.getSetup().get("billing.name", "") + System.currentTimeMillis());
                    if (resultJson != null) {
                        JSONObject result = new JSONObject(resultJson);
                        formUrl = String.valueOf(result.optQuery("/confirmation/confirmation_url"));
                        break block15;
                    }
                    this.execute();
                    throw new BGMessageException("resultJson = " + resultJson);
                }
            }
            formUrl = this.moduleSetup.get("yoomoney.url", "https://demomoney.yandex.ru/eshop.xml") + "?mid=" + this.moduleId + "&shopId=" + this.moduleSetup.get("yoomoney.shopId", "") + "&scid=" + this.moduleSetup.get("yoomoney.scid", "") + "&CustomerNumber=" + contractTitle + "&paymentType=" + (paymentType != null ? paymentType : "") + "&Sum=" + sum.toPlainString() + "&shopSuccessURL=" + this.moduleSetup.get("yoomoney.shopSuccessURL", "") + "&shopFailURL=" + this.moduleSetup.get("yoomoney.shopFailURL", "") + merchantReceipt;
        }
        try {
            this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.binary);
            this.context.getResponse().sendRedirect(formUrl);
            return;
        }
        catch (IOException ex) {
            this.execute();
            throw new BGMessageException(ex.getMessage());
        }
    }
}

