/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAbtractAccountRuntime;
import ru.bitel.common.Utils;

public class VoiceOperAccountRuntime
extends VoiceAbtractAccountRuntime<VoiceOperAccount> {
    private Pattern fromPortsPattern;
    private Pattern toPortsPattern;
    private Pattern fromNumberPattern;
    private Pattern toNumberPattern;
    private Pattern notFromNumberPattern;
    private Pattern notToNumberPattern;
    private Set<String> fromPorts = new HashSet<String>();
    private Set<String> toPorts = new HashSet<String>();

    public VoiceOperAccountRuntime(VoiceOperAccount account) {
        super(account);
        this.setAccount(account);
    }

    @Override
    public void setAccount(VoiceOperAccount account) {
        super.setAccount(account);
        this.fromPortsPattern = null;
        this.toPortsPattern = null;
        this.fromNumberPattern = null;
        this.toNumberPattern = null;
        this.fromPorts.clear();
        this.toPorts.clear();
        if (Utils.notBlankString((String)account.getRegexpFromPorts())) {
            this.fromPortsPattern = Pattern.compile(account.getRegexpFromPorts());
        }
        if (Utils.notBlankString((String)account.getRegexpToPorts())) {
            this.toPortsPattern = Pattern.compile(account.getRegexpToPorts());
        }
        if (Utils.notBlankString((String)account.getRegexpA())) {
            this.fromNumberPattern = Pattern.compile(account.getRegexpA());
        }
        if (Utils.notBlankString((String)account.getRegexpB())) {
            this.toNumberPattern = Pattern.compile(account.getRegexpB());
        }
        if (Utils.notBlankString((String)account.getNoRegexpA())) {
            this.notFromNumberPattern = Pattern.compile(account.getNoRegexpA());
        }
        if (Utils.notBlankString((String)account.getNoRegexpB())) {
            this.notToNumberPattern = Pattern.compile(account.getNoRegexpB());
        }
        if (account.getFromPortList().size() > 0) {
            this.fromPorts.addAll(account.getFromPortList().stream().map(p -> p.getPort()).collect(Collectors.toList()));
        }
        if (account.getToPortList().size() > 0) {
            this.toPorts.addAll(account.getToPortList().stream().map(p -> p.getPort()).collect(Collectors.toList()));
        }
    }

    public boolean isMatches(String fromNumber, String toNumber, String fromPort, String toPort) {
        if (this.fromPortsPattern != null && !this.fromPortsPattern.matcher(fromPort).find()) {
            return false;
        }
        if (this.toPortsPattern != null && !this.toPortsPattern.matcher(toPort).find()) {
            return false;
        }
        if (this.fromNumberPattern != null && !this.fromNumberPattern.matcher(fromNumber).find()) {
            return false;
        }
        if (this.toNumberPattern != null && !this.toNumberPattern.matcher(toNumber).find()) {
            return false;
        }
        if (this.notFromNumberPattern != null && this.notFromNumberPattern.matcher(fromNumber).find()) {
            return false;
        }
        if (this.notToNumberPattern != null && this.notToNumberPattern.matcher(toNumber).find()) {
            return false;
        }
        if (this.fromPorts.size() > 0 && !this.fromPorts.contains(fromPort)) {
            return false;
        }
        return this.toPorts.size() <= 0 || this.toPorts.contains(toPort);
    }
}

