/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.runtime;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.runtime.RuntimeMediatorWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.voice.common.mediation.RuntimeMediator;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceDevicesReloadEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.quartz.server.QuartzScheduler;

public class LogRuntimeProcessor
implements EventListener<VoiceDevicesReloadEvent>,
Lifecycle {
    private static final Logger logger = LogManager.getLogger();
    private VoiceApplication application;

    @ConstructorProperties(value={"app"})
    public LogRuntimeProcessor(VoiceApplication application) throws BGException {
        this.application = application;
        EventProcessor.getInstance().addListener((EventListener)this, VoiceDevicesReloadEvent.class, application.getModuleId(), null);
    }

    private void load() throws BGException {
        try {
            QuartzScheduler scheduler = QuartzScheduler.getInstance();
            String taskGroup = "mediator.runtime.group";
            for (VoiceDeviceRuntime deviceRuntime : this.application.getDeviceRuntimeMap().values()) {
                Preferences pref = new Preferences(deviceRuntime.getDevice().getConfig(), "\r\n");
                String cronTab = pref.get("log.runtime.cronTab");
                if (Utils.isEmptyString((String)cronTab)) continue;
                logger.info("add timetable for diviceId = " + deviceRuntime.getDevice().getId() + ";cronTab=" + cronTab);
                HashMap<String, Object> params = new HashMap<String, Object>();
                RuntimeMediator runtimeMediator = deviceRuntime.getMediatorRuntimeInstance();
                if (runtimeMediator == null) {
                    logger.warn("RuntimeMediator is empty, but log.runtime.cronTab is not empty");
                    continue;
                }
                String taskName = "mediator.runtime.device.id." + deviceRuntime.voiceDeviceId;
                if (!scheduler.schedulerExist(taskName)) {
                    scheduler.addScheduler(taskName, 1);
                    scheduler.startScheduler(taskName);
                } else {
                    scheduler.deleteAllTasks(taskName, taskGroup);
                }
                params.put("runtimeMediator", runtimeMediator);
                params.put("application", this.application);
                params.put("deviceId", deviceRuntime.getDevice().getId());
                scheduler.addTaskCron(RuntimeMediatorWorker.class, taskName, taskGroup, taskName, cronTab, params, this.application.getModuleId());
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void notify(VoiceDevicesReloadEvent e, EventListenerContext ctx) throws BGException {
        this.load();
    }

    public void start() throws Exception {
        this.load();
    }

    public void stop() throws Exception {
        QuartzScheduler scheduler = QuartzScheduler.getInstance();
        scheduler.stopAllSchedullers();
    }
}

