/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.reports.beeline;

import bitel.billing.module.common.BGControlPanelMonth;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.modules.voice.client.reports.beeline.VoiceReportBasePanel;
import ru.bitel.bgbilling.modules.voice.client.reports.beeline.VoiceReportBilPanel;
import ru.bitel.bgbilling.modules.voice.client.reports.beeline.VoiceReportCusPanel;
import ru.bitel.bgbilling.modules.voice.client.reports.beeline.VoiceReportOanPanel;
import ru.bitel.bgbilling.modules.voice.client.reports.beeline.VoiceReportVpnPanel;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceReportsService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class VoiceReportPanel
extends BGUPanel {
    private static final String KEY_REPORT_CUS = "cus";
    private static final String KEY_REPORT_BIL = "bil";
    private static final String KEY_REPORT_VPN = "vpn";
    private static final String KEY_REPORT_OAN = "oan";
    private boolean init = false;
    private TextPanel agentCode = null;
    private PeriodPanel reportPeriod = null;
    private ClassChooser classChooserCus = null;
    private ClassChooser classChooserBil = null;
    private ClassChooser classChooserVpn = null;
    private ClassChooser classChooserOan = null;
    private JTabbedPane tabbedPane = null;
    private JPanel classPanel = null;
    private CardLayout classCardLayout = null;
    private VoiceReportsService voiceReportService = null;
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            if (!VoiceReportPanel.this.init) {
                VoiceReportPanel.this.setAax(VoiceReportPanel.this.getVoiceReportsService().getParameter("aax"));
                VoiceReportPanel.this.init = true;
            }
            VoiceReportPanel.this.initClassChooserPanel();
        }
    };

    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getDataPanel(), (Component)this.getTabsPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
    }

    private void updateParameter(String key, String value) {
        try {
            this.getVoiceReportsService().updateParameter(key, value);
        }
        catch (BGException e1) {
            ClientUtils.showErrorMessageDialog((Throwable)e1);
        }
    }

    private JPanel getDataPanel() {
        ActionListener paramActionListener = e -> {
            this.setAax(this.agentCode.getText());
            this.updateParameter("aax", this.agentCode.getText());
        };
        this.agentCode = new TextPanel("\u041a\u043e\u0434 \u0430\u0433\u0435\u043d\u0442\u0430:", paramActionListener);
        PropertyChangeListener periodChangeListener = e -> {
            if ("date".equals(e.getPropertyName())) {
                this.setPeriod((LocalDate)e.getNewValue());
            }
        };
        this.reportPeriod = new PeriodPanel("\u041f\u0435\u0440\u0438\u043e\u0434:", periodChangeListener);
        this.classChooserCus = new ClassChooser("\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u044b (\u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a)", KEY_REPORT_CUS, "ru.bitel.bgbilling.modules.voice.api.server.reports.VoiceReport", "ru.bitel.bgbilling.modules.voice.api.server.reports.VoiceReportBase");
        this.classChooserBil = new ClassChooser("\u0421\u0447\u0435\u0442\u0430 \u0444\u0430\u043a\u0442\u0443\u0440\u044b (\u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a)", KEY_REPORT_BIL, "ru.bitel.bgbilling.modules.voice.api.server.reports.VoiceReport", "ru.bitel.bgbilling.modules.voice.api.server.reports.VoiceReportBase");
        this.classChooserVpn = new ClassChooser("\u0421\u0447\u0435\u0442\u0430 \u0444\u0430\u043a\u0442\u0443\u0440\u044b (\u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a)", KEY_REPORT_VPN, "ru.bitel.bgbilling.modules.voice.api.server.reports.VoiceReport", "ru.bitel.bgbilling.modules.voice.api.server.reports.VoiceReportBase");
        this.classChooserOan = new ClassChooser("\u041d\u043e\u043c\u0435\u0440\u043d\u0430\u044f \u0435\u043c\u043a\u043e\u0441\u0442\u044c (\u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a)", KEY_REPORT_OAN, "ru.bitel.bgbilling.modules.voice.api.server.reports.VoiceReport", "ru.bitel.bgbilling.modules.voice.api.server.reports.VoiceReportBase");
        this.classCardLayout = new CardLayout();
        this.classPanel = new JPanel(this.classCardLayout);
        this.classPanel.add((Component)this.classChooserCus, this.classChooserCus.getKey());
        this.classPanel.add((Component)this.classChooserBil, this.classChooserBil.getKey());
        this.classPanel.add((Component)this.classChooserVpn, this.classChooserVpn.getKey());
        this.classPanel.add((Component)this.classChooserOan, this.classChooserOan.getKey());
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.agentCode, new GridBagConstraints(0, gridx++, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.reportPeriod, new GridBagConstraints(0, gridx++, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.classPanel, new GridBagConstraints(0, gridx++, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JTabbedPane getTabsPanel() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add((Component)((Object)new VoiceReportCusPanel()), "\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u044b");
            this.tabbedPane.add((Component)((Object)new VoiceReportBilPanel()), "\u0421\u0447\u0435\u0442\u0430 \u0444\u0430\u043a\u0442\u0443\u0440\u044b (\u041a\u043b\u0438\u0435\u043d\u0442\u044b)");
            this.tabbedPane.add((Component)((Object)new VoiceReportVpnPanel()), "\u0421\u0447\u0435\u0442\u0430 \u0444\u0430\u043a\u0442\u0443\u0440\u044b (\u0410\u0433\u0435\u043d\u0442\u0430)");
            this.tabbedPane.add((Component)((Object)new VoiceReportOanPanel()), "\u041d\u043e\u043c\u0435\u0440\u043d\u0430\u044f \u0435\u043c\u043a\u043e\u0441\u0442\u044c");
            this.tabbedPane.addChangeListener(e -> {
                this.classCardLayout.show(this.classPanel, ((VoiceReportBasePanel)((Object)((Object)this.tabbedPane.getSelectedComponent()))).getKey());
                this.initClassChooserPanel();
            });
        }
        return this.tabbedPane;
    }

    private void initClassChooserPanel() {
        try {
            String key;
            switch (key = ((VoiceReportBasePanel)((Object)this.tabbedPane.getSelectedComponent())).getKey()) {
                case "cus": {
                    this.classChooserCus.performAction("refresh");
                    this.classChooserCus.setData(new JSONObject(this.getVoiceReportsService().getParameters(key)));
                    break;
                }
                case "bil": {
                    this.classChooserBil.performAction("refresh");
                    this.classChooserBil.setData(new JSONObject(this.getVoiceReportsService().getParameters(key)));
                    break;
                }
                case "vpn": {
                    this.classChooserVpn.performAction("refresh");
                    this.classChooserVpn.setData(new JSONObject(this.getVoiceReportsService().getParameters(key)));
                    break;
                }
                case "oan": {
                    this.classChooserOan.performAction("refresh");
                    this.classChooserOan.setData(new JSONObject(this.getVoiceReportsService().getParameters(key)));
                    break;
                }
            }
        }
        catch (Exception e1) {
            ClientUtils.showErrorMessageDialog((Throwable)e1);
        }
    }

    private VoiceReportsService getVoiceReportsService() {
        if (this.voiceReportService == null) {
            this.voiceReportService = (VoiceReportsService)((ClientContext)this.getContext()).getPort(VoiceReportsService.class);
        }
        return this.voiceReportService;
    }

    private void setAax(String aax) {
        this.agentCode.setText(aax);
        for (Component component : this.tabbedPane.getComponents()) {
            ((VoiceReportBasePanel)((Object)component)).setAax(aax);
        }
    }

    private void setPeriod(LocalDate date) {
        for (Component component : this.tabbedPane.getComponents()) {
            ((VoiceReportBasePanel)((Object)component)).setPeriod(date);
        }
    }

    class TextPanel
    extends JPanel {
        private ActionListener actionListener;
        private JTextField text;
        private JButton button;

        public TextPanel(String text, ActionListener actionListener) {
            super(new GridBagLayout());
            this.actionListener = null;
            this.text = new JTextField();
            this.button = new JButton(ClientUtils.getIcon((String)"edit"));
            this.actionListener = actionListener;
            this.button.addActionListener(e -> this.getDialog().setVisible(true));
            this.add((Component)new JLabel(text), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.getTextField(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.button, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
        }

        private JDialog getDialog() {
            JTextField editorTextField = new JTextField(20);
            Component[][] components = new Component[][]{{new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), editorTextField}};
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
            editorTextField.setText(this.text.getText());
            BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
            JDialog dialog = optionPane.getDialog();
            ((JButton)optionPane.getOptions()[0]).setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
            ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
                this.text.setText(editorTextField.getText());
                this.actionListener.actionPerformed(e);
                dialog.setVisible(false);
                dialog.dispose();
            });
            return dialog;
        }

        private JTextField getTextField() {
            this.text.setEnabled(false);
            this.text.setBackground(new JTextField().getBackground());
            this.text.setDisabledTextColor(Color.BLACK);
            this.text.setHorizontalAlignment(0);
            return this.text;
        }

        public String getText() {
            return this.text.getText();
        }

        public void setText(String text) {
            this.text.setText(text);
        }
    }

    class PeriodPanel
    extends JPanel {
        private BGControlPanelMonth panelMonth;

        public PeriodPanel(String text, PropertyChangeListener periodChangeListener) {
            super(new GridBagLayout());
            this.panelMonth = new BGControlPanelMonth();
            this.panelMonth.addPropertyChangeListener(periodChangeListener);
            this.add((Component)new JLabel(text), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.panelMonth, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    class ClassChooser
    extends JPanel {
        private String paramName;
        private ItemListener itemListener;
        private DynamicClassChooser dynamicClassChooser;
        private ParamTableModel paramTableModel;

        public ClassChooser(String labelTitle, String paramName, String iFaceName, String superClassName) {
            super(new GridBagLayout());
            this.paramName = null;
            this.itemListener = null;
            this.dynamicClassChooser = new DynamicClassChooser(true);
            this.paramTableModel = new ParamTableModel(ParamTableModel.class.getName());
            this.paramName = paramName;
            this.dynamicClassChooser.setIfaceName(iFaceName);
            this.dynamicClassChooser.setSuperclassName(superClassName);
            this.dynamicClassChooser.setDerivingIfaces(Collections.singleton(iFaceName));
            BGUTable table = new BGUTable((TableModel)((Object)this.paramTableModel));
            table.setSelectionMode(0);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    RowData rowData;
                    if (mouseEvent.getClickCount() == 2 && (rowData = (RowData)ClassChooser.this.paramTableModel.getSelectedRow()) != null) {
                        ClassChooser.this.getParamEditorDialog(rowData.getJson()).setVisible(true);
                    }
                }
            });
            JScrollPane scrollPane = new JScrollPane((Component)table);
            scrollPane.setMinimumSize(new Dimension(100, 150));
            scrollPane.setPreferredSize(new Dimension(100, 150));
            this.add((Component)new JLabel(labelTitle), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 0, 0), 0, 0));
            this.add((Component)this.dynamicClassChooser, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)scrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.itemListener = e -> {
                if (e.getStateChange() == 1) {
                    try {
                        VoiceReportPanel.this.getVoiceReportsService().updateParameter(paramName + "_class", this.dynamicClassChooser.getSelectedClass());
                    }
                    catch (BGException e1) {
                        ClientUtils.showErrorMessageDialog((Throwable)e1);
                    }
                }
            };
            this.dynamicClassChooser.getClassNamesBox().addItemListener(this.itemListener);
        }

        private JDialog getParamEditorDialog(JSONObject rowData) {
            JTextField keyTextField = new JTextField(30);
            keyTextField.setEditable(false);
            keyTextField.setBackground(new JTextField().getBackground());
            JTextField valueTextField = new JTextField(30);
            Component[][] components = new Component[][]{{new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440:"), keyTextField}, {new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), valueTextField}};
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
            keyTextField.setText(rowData.optString("name"));
            valueTextField.setText(rowData.optString("value"));
            BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
            JDialog dialog = optionPane.getDialog();
            ((JButton)optionPane.getOptions()[0]).setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
            ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
                VoiceReportPanel.this.updateParameter(this.paramName + "_" + rowData.optString("name"), valueTextField.getText());
                rowData.put("value", (Object)valueTextField.getText());
                dialog.setVisible(false);
                dialog.dispose();
            });
            return dialog;
        }

        public void setData(JSONObject jsonObject) {
            this.setSelectedItem(jsonObject.optString("className"));
            this.setParamData(jsonObject.optJSONArray("params"));
        }

        public void setSelectedItem(String className) {
            this.dynamicClassChooser.getClassNamesBox().removeItemListener(this.itemListener);
            int itemCount = this.dynamicClassChooser.getClassNamesBox().getItemCount();
            for (int index = 0; index < itemCount; ++index) {
                DynamicClass dynamicClass = (DynamicClass)this.dynamicClassChooser.getClassNamesBox().getItemAt(index);
                if (!dynamicClass.getClassName().equals(className)) continue;
                this.dynamicClassChooser.getClassNamesBox().setSelectedIndex(index);
                break;
            }
            this.dynamicClassChooser.getClassNamesBox().addItemListener(this.itemListener);
        }

        public void performAction(String action) {
            this.dynamicClassChooser.performAction(action);
        }

        public void setParamData(List<RowData> data) {
            this.paramTableModel.setData(data);
        }

        public void setParamData(JSONArray params) {
            ArrayList<RowData> data = new ArrayList<RowData>();
            if (params != null) {
                for (int index = 0; index < params.length(); ++index) {
                    data.add(new RowData(params.getJSONObject(index)));
                }
            }
            this.paramTableModel.setData(data);
        }

        public String getKey() {
            return this.paramName;
        }
    }

    class ParamTableModel
    extends BGTableModel<RowData> {
        public ParamTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 200, 200, 200, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 100, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RowData rowData, int column) throws BGException {
            return rowData.getJson().optString(this.getIdentifier(column));
        }
    }
}

