/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vepay.client;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.vepay.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.vepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vepay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.vepay.common.service.VepayService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            String contractTitle = TransactionPanel.this.contractTitleField.getText();
            AbstractTransactionStatus status = (AbstractTransactionStatus)TransactionPanel.this.statusComboBox.getSelectedItem();
            SearchResult searchResult = ((VepayService)((ClientContext)TransactionPanel.this.getContext()).getPort(VepayService.class)).searchTransactionList(TransactionPanel.this.getContractId(), contractTitle, status.getCode(), TransactionPanel.this.periodPanel.getPeriod(), TransactionPanel.this.getTable().getSort(), TransactionPanel.this.pagePanel.getPage());
            ((TransactionTableModel)TransactionPanel.this.transactionModel).setData(searchResult.getList());
            TransactionPanel.this.pagePanel.setPage(searchResult.getPage());
            TransactionPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            TransactionPanel.this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        }
    };

    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected JMenuItem getTransactionDataMenuItem() {
        return new JMenuItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedTransaction = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedTransaction != null && selectedTransaction instanceof Transaction) {
                        Transaction transaction = (Transaction)selectedTransaction;
                        JTextArea textArea = new JTextArea(transaction.getParameters(), 20, 50);
                        textArea.setMargin(new Insets(5, 5, 5, 5));
                        textArea.setEditable(false);
                        JScrollPane scrollPane = new JScrollPane(textArea);
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", 1);
                    }
                });
            }
        };
    }
}

