package ru.bitel.bgbilling.modules.tv.dyn.cti.tve;

/*import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.activation.DataSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.modules.tv.api.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.api.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.dyn.cti.tve.ws.messaging.InformingServiceWS;
import ru.bitel.bgbilling.modules.tv.dyn.cti.tve.ws.messaging.InformingServiceWSPortType;
import ru.bitel.bgbilling.plugins.dispatch.BGPluginInfo;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.LoggingSOAPHandlerClient;
import ru.bitel.common.model.Id;
import bitel.billing.common.TimeUtils;

public class TveDispatchSender
	implements Sender
{
	private static final Logger logger = LogManager.getLogger();

	private final ParameterMap pluginParams;
	private final List<Integer> tvModuleIdList;

	private final Set<Integer> tveDeviceIds;

	private final String senderTitle;
	private final String messageType;

	private final InformingServiceWSPortType informingService;

	public TveDispatchSender()
		throws MalformedURLException
	{
		final BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin( BGPluginInfo.id );
		pluginParams = plugin.getSetup();

		tvModuleIdList = Id.newIdList( ModuleCache.getInstance().getModulesList( "tv" ) );

		Set<Integer> tveDeviceIds = Utils.toIntegerSet( pluginParams.get( "tve.deviceIds", null ) );
		if( tveDeviceIds.size() == 0 )
		{
			this.tveDeviceIds = null;
		}
		else
		{
			this.tveDeviceIds = tveDeviceIds;
		}

		senderTitle = pluginParams.get( "tve.senderTitle", "BGBilling" );
		messageType = pluginParams.get( "tve.messageType", "INFO" );

		final String urlString = pluginParams.get( "tve.url", "http://127.0.0.1:8080" );
		final URL url = new URL( urlString );

		InformingServiceWS informingServiceWSService = new InformingServiceWS( new URL( url, "portal-facade-ng/InformingServiceWS?wsdl" ) );
		informingServiceWSService.setHandlerResolver( newHandlerResolver( informingServiceWSService ) );
		informingService = informingServiceWSService.getInformingServiceWSHttpPort();
		Map<String, Object> requestContext = ((BindingProvider)informingService).getRequestContext();
		requestContext.put( BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlString + "/portal-facade-ng/InformingServiceWS" );
	}

	private HandlerResolver newHandlerResolver( final javax.xml.ws.Service webService )
	{
		return new HandlerResolver()
		{
			@SuppressWarnings({ "rawtypes" })
			@Override
			public List<Handler> getHandlerChain( PortInfo portInfo )
			{
				List<Handler> result = new ArrayList<Handler>();
				result.add( new LoggingSOAPHandlerClient( webService, logger, Level.INFO ) );
				return result;
			}
		};
	}

	@Override
	public void send( final Contact contract, final String title, final String messageBody, final List<DataSource> messageFiles )
		throws BGException
	{
		final Date date = new Date();
		final Date timeExpires = TimeUtils.plusPeriod( date, Calendar.DATE, 1 );

		informingService.sendMessage( title, senderTitle, String.valueOf( contract.getId() ), "5", messageType, "CUSTOMER_ID", messageBody, timeExpires );
	}

	protected void send2( final Contact contract, final String title, final String messageBody, final List<DataSource> messageFiles )
		throws BGException
	{
		final ServerContext context = ServerContext.get();

		final Date date = new Date();
		final Date timeExpires = TimeUtils.plusPeriod( date, Calendar.DATE, 1 );

		for( Integer moduleId : tvModuleIdList )
		{
			final TvAccountService tvAccountService = context.getService( TvAccountService.class, moduleId );

			final TvAccount tvAccountRoot = tvAccountService.tvAccountTree( contract.getId() );

			for( TvAccount tvAccount : tvAccountRoot.getChildren() )
			{
				if( !TimeUtils.dateInRange( date, tvAccount.getDateFrom(), tvAccount.getDateTo() ) )
				{
					continue;
				}

				if( tveDeviceIds != null && !tveDeviceIds.contains( tvAccount.getDeviceId() ) )
				{
					continue;
				}

				informingService.sendMessage( title, senderTitle, tvAccount.getDeviceAccountId(), "5", messageType, "CUSTOMER_NAME", messageBody, timeExpires );
			}
		}
	}
}*/
