/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.tariff;

import bitel.billing.module.tariff.directory.DirectoriesManager;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.directory.tariff.common.TariffDirectory;
import ru.bitel.bgbilling.kernel.tariff.client.tree.MultiSelectTariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;

public class ProductTariffTreeNode
extends MultiSelectTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"fugue/present");

    protected String getDirName() {
        return "productSpec";
    }

    protected boolean needMode() {
        return false;
    }

    protected boolean canEmpty() {
        return false;
    }

    protected String getViewLabel() {
        return "\u041f\u0440\u043e\u0434\u0443\u043a\u0442: ";
    }

    protected String getStoreKey() {
        return "productSpecIds";
    }

    protected Icon getIcon() {
        return icon;
    }

    public List<Integer> getProductSpecIds() {
        Map data = this.getDataInHash();
        return Utils.toIntegerList((String)((String)data.get(this.getStoreKey())));
    }

    protected void buildDirectoryCombo(Directory dir, JComboBox<IdTitle> combo) {
        if (dir instanceof DirectoriesManager.LazyDirectory) {
            dir = ((DirectoriesManager.LazyDirectory)dir).getDirectory();
        }
        int moduleId = this.getDirManager().getModuleId();
        TariffDirectory productSpecDirectory = (TariffDirectory)dir;
        for (ProductSpec productSpec : productSpecDirectory.list()) {
            if (productSpec.getModuleId() != 0 && productSpec.getModuleId() != moduleId) continue;
            Object title = Utils.isBlankString((String)productSpec.getIdentifier()) ? productSpec.getTitle() : productSpec.getTitle() + " [" + productSpec.getIdentifier() + "]";
            combo.addItem(new IdTitle(productSpec.getId(), (String)title));
        }
    }

    protected String getValue(int sid) {
        TariffDirectory productSpecDirectory;
        ProductSpec productSpec;
        Directory dir = this.getDirectory();
        if (dir instanceof DirectoriesManager.LazyDirectory) {
            dir = ((DirectoriesManager.LazyDirectory)dir).getDirectory();
        }
        if ((productSpec = (ProductSpec)(productSpecDirectory = (TariffDirectory)dir).get(sid)) == null) {
            return "null";
        }
        if (Utils.isBlankString((String)productSpec.getIdentifier())) {
            return productSpec.getTitle();
        }
        return productSpec.getTitle() + " [" + productSpec.getIdentifier() + "]";
    }
}

