/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.contract;

import bitel.billing.module.common.BGPasswordField;
import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.tv.client.TvDevicePanel;
import ru.bitel.bgbilling.modules.tv.client.contract.ProductPanel;
import ru.bitel.bgbilling.modules.tv.client.contract.TvAccountPanel;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.common.service.TvDeviceService;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;

public class TvAccountForm
extends BGUPanel {
    TvAccountService tvAccountService = null;
    private BGUComboBox<TvAccountSpec> serviceType;
    private BGControlPanelPeriodNoB period;
    private BGUComboBox<IdTitle> status;
    private JPanel loginPasswordPanel;
    private JPanel loginPanel;
    private JPanel passwordPanel;
    private JPanel pinPanel;
    private BGTextField login;
    private JCheckBox autoLogin;
    private BGPasswordField password;
    private JCheckBox autoPassword;
    private BGPasswordField pin;
    private JCheckBox autoPin;
    private JPanel devicePanel;
    private BGTextField device;
    private JPanel ifacePanel;
    private IntTextField iface;
    private JPanel vlanPanel;
    private IntTextField vlan;
    private BGTextField macAddress;
    private JComponent macAddressPanel;
    private BGTextField identifier;
    private JComponent identifierPanel;
    private BGTextArea comment;
    TvAccount parent;
    TvAccount current;
    private final TvAccountPanel panel;
    private BGEditor editor;
    ProductPanel productPanel;
    private JTabbedPane tabbedPane;
    private JLabel state;
    private JPanel statePanel;
    private EntityAttributesForm entityAttributesForm;
    private AtomicReference<TvAccount> currentTypeRef = new AtomicReference();
    private Directory<ProductSpec> productSpecDirectory;
    private volatile boolean onInetServSelected = true;

    public TvAccountForm(TvAccountPanel panel) {
        super((LayoutManager)new BorderLayout());
        this.panel = panel;
    }

    private TvAccountService getTvAccountService() {
        if (this.tvAccountService == null) {
            this.tvAccountService = (TvAccountService)((ClientContext)this.getContext()).getPort(TvAccountService.class);
        }
        return this.tvAccountService;
    }

    protected void jbInit() throws BGException {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)this.getTypePeriodStatusPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.getDevicePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.getLoginPasswordPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.macAddress = new BGTextField();
        this.macAddressPanel = BGSwingUtilites.wrapBorder((JComponent)this.macAddress, (String)"MAC-\u0430\u0434\u0440\u0435\u0441");
        mainPanel.add((Component)this.macAddressPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.identifier = new BGTextField();
        this.identifierPanel = BGSwingUtilites.wrapBorder((JComponent)this.identifier, (String)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440");
        mainPanel.add((Component)this.identifierPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.comment = new BGTextArea();
        mainPanel.add((Component)BGSwingUtilites.wrapBorder((JComponent)new JScrollPane((Component)this.comment), (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.statePanel = new JPanel(new BorderLayout());
        this.state = new JLabel();
        this.statePanel.add((Component)this.state, "West");
        mainPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.statePanel, (String)"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435"), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        ActionListener editorsListener = e -> {
            String command = e.getActionCommand();
            if ("device.selected".equals(command)) {
                TvDevicePanel panel = (TvDevicePanel)((Object)((Object)e.getSource()));
                TvDevice selectedDevice = (TvDevice)panel.getSelectedDevice();
                this.current.setDeviceId(selectedDevice.getId());
                this.device.setText(selectedDevice.getTitle());
            }
        };
        this.productPanel = new ProductPanel((ClientContext)this.getContext(), ((ClientContext)this.getContext()).getContractId(), null);
        this.entityAttributesForm = new EntityAttributesForm(this.currentTypeRef, (ClientContext)this.getContext());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)mainPanel, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.tabbedPane.add((Component)this.entityAttributesForm, "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b");
        this.tabbedPane.add((Component)((Object)this.productPanel), "\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
        this.editor = new BGEditor("main");
        this.editor.addForm((JComponent)this.tabbedPane, (Object)"main");
        this.editor.addForm((JComponent)BGSwingUtilites.wrapBorder((JPanel)((Object)new TvDevicePanel((ClientContext)this.getContext(), 2, editorsListener)), (String)"\u0412\u044b\u0431\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430"));
        this.add((Component)this.editor, "Center");
        this.productSpecDirectory = ((ClientContext)this.getContext()).getDirectory(ProductSpec.class, 0);
    }

    private JPanel getTypePeriodStatusPanel() {
        this.serviceType = new BGUComboBox(false);
        this.serviceType.addActionListener(e -> {
            if (this.onInetServSelected) {
                this.onTvAccountSpecSelected();
            }
        });
        this.period = new BGControlPanelPeriod();
        ArrayList<IdTitle> data = new ArrayList<IdTitle>();
        data.add(new IdTitle(0, "\u041e\u0442\u043a\u0440\u044b\u0442"));
        data.add(new IdTitle(1, "\u0417\u0430\u043a\u0440\u044b\u0442"));
        data.add(new IdTitle(2, "\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
        this.status = new BGUComboBox();
        this.status.setData(data);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapBorder(this.serviceType, (String)"\u0422\u0438\u043f"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.period, (String)"\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder(this.status, (String)"\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getLoginPasswordPanel() {
        if (this.loginPasswordPanel == null) {
            this.login = new BGTextField(30);
            this.autoLogin = new JCheckBox("\u0430\u0432\u0442\u043e");
            this.autoLogin.addChangeListener(e -> this.login.setEditable(!this.autoLogin.isSelected()));
            this.autoLogin.setSelected(true);
            this.loginPanel = new JPanel(new GridBagLayout());
            this.loginPanel.add((Component)this.login, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.loginPanel.add((Component)this.autoLogin, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.password = new BGPasswordField(30);
            this.autoPassword = new JCheckBox("\u0430\u0432\u0442\u043e");
            this.autoPassword.addActionListener(e -> this.password.setEditable(!this.autoPassword.isSelected()));
            this.autoPassword.setSelected(true);
            int gridx = 0;
            this.passwordPanel = new JPanel(new GridBagLayout());
            this.passwordPanel.add((Component)this.password, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.passwordPanel.add((Component)this.autoPassword, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.passwordPanel.add((Component)new ShowButton((JPasswordField)this.password, "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c", "\u041f\u0430\u0440\u043e\u043b\u044c"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pin = new BGPasswordField(30);
            this.autoPin = new JCheckBox("\u0430\u0432\u0442\u043e");
            this.autoPin.addActionListener(e -> this.pin.setEditable(!this.autoPassword.isSelected()));
            this.autoPin.setSelected(true);
            gridx = 0;
            this.pinPanel = new JPanel(new GridBagLayout());
            this.pinPanel.add((Component)this.pin, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pinPanel.add((Component)this.autoPin, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pinPanel.add((Component)new ShowButton((JPasswordField)this.pin, "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c", "PIN"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.loginPasswordPanel = new JPanel(new GridBagLayout());
            this.loginPasswordPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.loginPanel, (String)"\u041b\u043e\u0433\u0438\u043d"), new GridBagConstraints(0, 0, 1, 1, 0.4, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.loginPasswordPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.passwordPanel, (String)"\u041f\u0430\u0440\u043e\u043b\u044c"), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.loginPasswordPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.pinPanel, (String)"PIN"), new GridBagConstraints(2, 0, 1, 1, 0.3, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.loginPasswordPanel;
    }

    private JPanel getDevicePanel() {
        if (this.devicePanel == null) {
            this.device = new BGTextField(30);
            this.device.setEditable(false);
            BGButton deviceSelect = new BGButton("<<<");
            deviceSelect.addActionListener(e -> this.performAction("device.select", String.valueOf(this.current.getDeviceId())));
            JPanel deviceDevicePanel = BGSwingUtilites.wrapBorder((JPanel)new JPanel(new GridBagLayout()), (String)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            deviceDevicePanel.add((Component)this.device, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            deviceDevicePanel.add((Component)deviceSelect, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            BGButton ifaceButton = new BGButton("<<<");
            ifaceButton.addActionListener(e -> this.performAction("ip.resource"));
            this.ifacePanel = BGSwingUtilites.wrapBorder((JPanel)new JPanel(new GridBagLayout()), (String)"\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
            this.iface = new IntTextField(8);
            this.ifacePanel.add((Component)this.iface, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.ifacePanel.add((Component)ifaceButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
            BGButton vlanButton = new BGButton("<<<");
            vlanButton.addActionListener(e -> this.performAction("vlan.resource"));
            this.vlanPanel = BGSwingUtilites.wrapBorder((JPanel)new JPanel(new GridBagLayout()), (String)"VLAN");
            this.vlan = new IntTextField(8);
            this.vlanPanel.add((Component)this.vlan, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.vlanPanel.add((Component)vlanButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
            this.devicePanel = new JPanel(new GridBagLayout());
            this.devicePanel.add((Component)deviceDevicePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.devicePanel.add((Component)this.ifacePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.devicePanel.add((Component)this.vlanPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.devicePanel;
    }

    private void onTvAccountSpecSelected() {
        Preferences tvAccountSpecConfig;
        int constDeviceId;
        TvAccountSpec tvAccountSpec = (TvAccountSpec)this.serviceType.getSelectedItem();
        if (tvAccountSpec == null) {
            return;
        }
        if (this.current.getId() <= 0) {
            // empty if block
        }
        this.loginPanel.setVisible(tvAccountSpec.isNeedLogin());
        this.passwordPanel.setVisible(tvAccountSpec.isNeedPassword());
        this.pinPanel.setVisible(tvAccountSpec.isNeedPin());
        this.loginPasswordPanel.setVisible(tvAccountSpec.isNeedLogin() || tvAccountSpec.isNeedPassword() || tvAccountSpec.isNeedPin());
        this.devicePanel.setVisible(tvAccountSpec.isNeedDevice());
        this.ifacePanel.setVisible(tvAccountSpec.isNeedInterface());
        this.vlanPanel.setVisible(tvAccountSpec.isNeedVlan());
        this.macAddressPanel.setVisible(tvAccountSpec.isNeedMacAddress());
        this.identifierPanel.setVisible(tvAccountSpec.isNeedIdentifier());
        if (this.current.getId() <= 0 && (constDeviceId = (tvAccountSpecConfig = new Preferences(tvAccountSpec.getConfig(), "\n\r")).getInt("const.device.id", -1)) > 0) {
            this.current.setDeviceId(constDeviceId);
            if (tvAccountSpec.isNeedDevice()) {
                try {
                    TvDevice device = (TvDevice)((TvDeviceService)((ClientContext)this.getContext()).getPort(TvDeviceService.class)).deviceGet(constDeviceId);
                    if (device != null) {
                        this.current.setDeviceTitle(device.getTitle());
                        this.device.setText(device.getTitle());
                    }
                }
                catch (BGException ex) {
                    ((ClientContext)this.getContext()).processException((Throwable)ex);
                }
            }
        }
    }

    public void performActionOpen() {
        this.serviceType.setSelectedItem((Object)this.current.getSpecId());
        this.onTvAccountSpecSelected();
        this.period.setDateString1(TimeUtils.formatDate((Date)this.current.getDateFrom()));
        this.period.setDateString2(TimeUtils.formatDate((Date)this.current.getDateTo()));
        this.comment.setText(this.current.getComment());
        if (this.current.getMacAddressList() == null) {
            this.macAddress.setText("");
        } else {
            StringBuilder sb = new StringBuilder();
            for (byte[] macAddress : this.current.getMacAddressList()) {
                sb.append(TvAccount.macAddressToString((byte[])macAddress)).append(", ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
            this.macAddress.setText(sb.toString());
        }
        this.identifier.setText(Utils.maskNull((String)this.current.getIdentifier()));
        this.device.setText(Utils.maskNull((String)this.current.getDeviceTitle()));
        if (this.current.getInterfaceId() >= 0) {
            this.iface.setValue((long)this.current.getInterfaceId());
        } else {
            this.iface.setText("");
        }
        if (this.current.getVlan() > 0) {
            this.vlan.setValue((long)this.current.getVlan());
        } else {
            this.vlan.setText("");
        }
        this.login.setText(Utils.maskNull((String)this.current.getLogin()));
        this.password.setText(Utils.maskNull((String)this.current.getPassword()));
        this.pin.setText(Utils.maskNull((String)this.current.getPin()));
        this.status.setSelectedItem((Object)this.current.getStatus());
        this.status.setEnabled(this.current.getParentId() <= 0);
        if (this.current.getParentId() <= 0) {
            if (!this.tabbedPane.isAncestorOf((Component)((Object)this.productPanel))) {
                this.tabbedPane.add((Component)((Object)this.productPanel), "\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
            }
        } else if (this.tabbedPane.isAncestorOf((Component)((Object)this.productPanel))) {
            this.tabbedPane.remove((Component)((Object)this.productPanel));
        }
        super.performActionOpen();
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (TvAccountForm.this.isShowing()) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                    return;
                }
                ArrayList<TvAccountSpec> servTypeList = TvAccountForm.this.getTvAccountService().tvAccountSpecList();
                TvAccountForm.this.parent = (TvAccount)TvAccountForm.this.panel.model.getSelectedRow();
                if (TvAccountForm.this.parent != null && TvAccountForm.this.parent.getId() <= 0) {
                    TvAccountForm.this.parent = null;
                }
                TvAccountSpec parentType = null;
                if (TvAccountForm.this.parent != null) {
                    int parentTypeId = TvAccountForm.this.parent.getSpecId();
                    for (TvAccountSpec type : servTypeList) {
                        if (type.getId() != parentTypeId) continue;
                        parentType = type;
                        break;
                    }
                }
                if (parentType != null) {
                    ArrayList<TvAccountSpec> newServTypeList = new ArrayList<TvAccountSpec>();
                    for (TvAccountSpec type : servTypeList) {
                        if (!type.getParentTypeIds().contains(parentType.getId())) continue;
                        newServTypeList.add(type);
                    }
                    if (newServTypeList.size() > 0) {
                        servTypeList = newServTypeList;
                    } else {
                        parentType = null;
                    }
                }
                if (parentType == null) {
                    TvAccountForm.this.parent = null;
                    ArrayList<TvAccountSpec> newServTypeList = new ArrayList<TvAccountSpec>();
                    for (TvAccountSpec type : servTypeList) {
                        if (type.getParentTypeIds() != null && type.getParentTypeIds().size() != 0) continue;
                        newServTypeList.add(type);
                    }
                    servTypeList = newServTypeList;
                }
                TvAccountForm.this.current = new TvAccount();
                TvAccountForm.this.current.setContractId(((ClientContext)TvAccountForm.this.getContext()).getContractId());
                TvAccountForm.this.current.setDateFrom(new Date());
                TvAccountForm.this.productPanel.setAccountId(null);
                if (TvAccountForm.this.parent != null) {
                    TvAccountForm.this.current.setParentId(TvAccountForm.this.parent.getId());
                    TvAccountForm.this.current.setDeviceId(TvAccountForm.this.parent.getDeviceId());
                }
                TvAccountForm.this.onInetServSelected = false;
                TvAccountForm.this.serviceType.setData(servTypeList);
                TvAccountForm.this.serviceType.setEnabled(true);
                TvAccountForm.this.onInetServSelected = true;
                TvAccountForm.this.statePanel.setVisible(false);
                TvAccountForm.this.productPanel.performAction("refresh");
                TvAccountForm.this.productPanel.setEnabled(false);
                TvAccountForm.this.performActionOpen();
                TvAccountForm.this.setLoginGenerationMode(true);
                TvAccountForm.this.autoPassword.setSelected(true);
                TvAccountForm.this.password.setEditable(false);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (TvAccountForm.this.isShowing()) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                    return;
                }
                TvAccountForm.this.tabbedPane.setSelectedIndex(0);
                TvAccountForm.this.current = (TvAccount)TvAccountForm.this.panel.model.getSelectedRow();
                if (TvAccountForm.this.current == null || TvAccountForm.this.current.getId() == 0) {
                    return;
                }
                TvAccountForm.this.productPanel.setAccountId(TvAccountForm.this.current.getId());
                TvAccountForm.this.current = TvAccountForm.this.current.clone();
                TvAccountForm.this.parent = TvAccountForm.this.current.getParentId() > 0 ? TvAccountForm.this.getTvAccountService().tvAccountGet(TvAccountForm.this.current.getContractId(), TvAccountForm.this.current.getParentId()) : null;
                TvAccountForm.this.onInetServSelected = false;
                TvAccountForm.this.serviceType.setData(TvAccountForm.this.getTvAccountService().tvAccountSpecList());
                TvAccountForm.this.serviceType.setEnabled(false);
                TvAccountForm.this.onInetServSelected = true;
                TvAccountForm.this.productPanel.performAction("refresh");
                if (TvAccountForm.this.current.getParentId() > 0) {
                    TvAccountForm.this.statePanel.setVisible(false);
                } else {
                    StringBuilder sb = new StringBuilder();
                    switch (TvAccountForm.this.current.getDeviceState()) {
                        case 1: {
                            sb.append("\u0412\u043a\u043b\u044e\u0447\u0435\u043d");
                            break;
                        }
                        case 0: {
                            sb.append("\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
                            break;
                        }
                        case -1: {
                            sb.append("\u0423\u0434\u0430\u043b\u0435\u043d");
                            break;
                        }
                        default: {
                            sb.append("null");
                        }
                    }
                    ((Object)((Object)TvAccountForm.this.productPanel)).hashCode();
                    sb.append(", \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b-\u043e\u043f\u0446\u0438\u0438: ");
                    if (TvAccountForm.this.current.getDeviceOptionIds() != null && TvAccountForm.this.current.getDeviceOptionIds().size() > 0) {
                        for (Integer optionId : TvAccountForm.this.current.getDeviceOptionIds()) {
                            sb.append(TvAccountForm.this.productSpecDirectory.get(optionId.intValue())).append(", ");
                        }
                        sb.setLength(sb.length() - 2);
                    } else {
                        sb.append("-");
                    }
                    TvAccountForm.this.state.setText(sb.toString());
                    TvAccountForm.this.statePanel.setVisible(true);
                }
                TvAccountForm.this.productPanel.setEnabled(true);
                TvAccountForm.this.performActionOpen();
                TvAccountForm.this.autoPin.setSelected(false);
                TvAccountForm.this.autoLogin.setSelected(false);
                TvAccountForm.this.autoPassword.setSelected(false);
                TvAccountForm.this.password.setEditable(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TvAccountSpec _tvAccountSpec = (TvAccountSpec)TvAccountForm.this.serviceType.getSelectedItem();
                if (_tvAccountSpec == null) {
                    return;
                }
                IdTitle _status = (IdTitle)TvAccountForm.this.status.getSelectedItem();
                if (_status == null) {
                    return;
                }
                TvAccountForm.this.current.setSpecId(_tvAccountSpec.getId());
                TvAccountForm.this.current.setDateFrom(TvAccountForm.this.period.getDateFrom());
                TvAccountForm.this.current.setDateTo(TvAccountForm.this.period.getDateTo());
                if (!Utils.isEmptyString((String)TvAccountForm.this.iface.getText())) {
                    TvAccountForm.this.current.setInterfaceId((int)TvAccountForm.this.iface.getValue());
                }
                if (!Utils.isEmptyString((String)TvAccountForm.this.vlan.getText())) {
                    TvAccountForm.this.current.setVlan((int)TvAccountForm.this.vlan.getValue());
                }
                String[] macAddresses = TvAccountForm.this.macAddress.getText().split("\\s*,\\s*");
                ArrayList<byte[]> macAddressList = new ArrayList<byte[]>();
                for (String macAddress : macAddresses) {
                    if (macAddress.length() <= 0) continue;
                    macAddressList.add(TvAccount.parseMacAddress((String)macAddress));
                }
                TvAccountForm.this.current.setMacAddressList(macAddressList);
                TvAccountForm.this.current.setIdentifier(TvAccountForm.this.identifier.getText());
                TvAccountForm.this.current.setLogin(TvAccountForm.this.login.getText());
                TvAccountForm.this.current.setPassword(new String(TvAccountForm.this.password.getPassword()));
                TvAccountForm.this.current.setPin(new String(TvAccountForm.this.pin.getPassword()));
                TvAccountForm.this.current.setStatus(_status.getId());
                TvAccountForm.this.current.setComment(TvAccountForm.this.comment.getText());
                TvAccountForm.this.getTvAccountService().tvAccountUpdate(TvAccountForm.this.current.getContractId(), TvAccountForm.this.current, TvAccountForm.this.autoLogin.isSelected(), TvAccountForm.this.autoPassword.isSelected(), 0L);
                TvAccountForm.this.performActionClose();
                TvAccountForm.this.panel.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (TvAccountForm.this.isShowing()) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                    return;
                }
                TvAccountForm.this.current = (TvAccount)TvAccountForm.this.panel.model.getSelectedRow();
                if (TvAccountForm.this.current == null || TvAccountForm.this.current.getId() == 0) {
                    return;
                }
                if (BGSwingUtilites.confirmDelete((Object)TvAccountForm.this.current)) {
                    TvAccountForm.this.getTvAccountService().tvAccountDelete(TvAccountForm.this.current.getContractId(), TvAccountForm.this.current.getId(), false);
                    TvAccountForm.this.panel.performAction("refresh");
                }
            }
        };
    }

    private void setLoginGenerationMode(boolean autoMode) {
        this.autoLogin.setSelected(autoMode);
        this.login.setEditable(!this.autoLogin.isSelected());
    }

    class ShowButton
    extends JButton {
        private Font font;

        public ShowButton(JPasswordField passwordField, String text, String title) {
            super(text);
            this.font = new Font("Dialog", 1, 25);
            this.addActionListener(e -> {
                JPanel panel = new JPanel();
                for (char ch : passwordField.getPassword()) {
                    JLabel charLabel = new JLabel(String.valueOf(ch));
                    charLabel.setFont(this.font);
                    charLabel.setForeground(Color.GRAY);
                    panel.add(charLabel);
                }
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), panel, title, 1);
            });
        }
    }
}

