/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.contract;

import bitel.billing.module.common.BGControlPanelMonthAndDays;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTimeButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.tv.client.contract.PeriodPanel;
import ru.bitel.bgbilling.modules.tv.client.contract.ProductFormBase;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.order.product.common.service.ProductOrderService;

public class ProductPanel
extends BGUPanel {
    private Integer contractId;
    private Integer accountId;
    private ProductService productService;
    private ProductOrderService productOrderService;
    BGTableModel<Product> model = new ProductTableModel("product");
    BGTableModel<Product> historyModel = new ProductTableModel("productHistory");
    private BGUTable table;
    private BGUTable historyTable;
    private BGControlPanelMonthAndDays monthAndDays;
    ProductForm productForm;
    AbstractBGUPanel.AsyncAction<List<Product>[]> refresh = new AbstractBGUPanel.AsyncAction<List<Product>[]>("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        protected List<Product>[] doInBackground() throws Exception {
            if (ProductPanel.this.accountId != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                ((Calendar)calendar).add(12, -10);
                LocalDate dateFrom = ProductPanel.this.monthAndDays.getBeginDate();
                LocalDateTime dateTo = ProductPanel.this.monthAndDays.getEndDate().atStartOfDay();
                dateTo = dateTo.plusDays(1L);
                dateTo = dateTo.plusNanos(-1L);
                List[] result = new List[]{ProductPanel.this.productService.productList(((ClientContext)ProductPanel.this.getContext()).getModuleId(), ProductPanel.this.contractId.intValue(), ProductPanel.this.accountId.intValue(), false, null, null, calendar.getTime(), null, true, true), ProductPanel.this.productService.productList(((ClientContext)ProductPanel.this.getContext()).getModuleId(), ProductPanel.this.contractId.intValue(), ProductPanel.this.accountId.intValue(), false, null, calendar.getTime(), TimeUtils.convertLocalDateToDate((LocalDate)dateFrom), TimeUtils.convertLocalDateTimeToDate((LocalDateTime)dateTo), true, true)};
                return result;
            }
            return new List[]{new ArrayList(), new ArrayList()};
        }

        protected void done(List<Product>[] result) throws Exception {
            ProductPanel.this.model.setData(result[0]);
            ProductPanel.this.historyModel.setData(result[1]);
        }
    };

    public ProductPanel(ClientContext context, Integer contractId, Integer accountId) throws BGException {
        super(context);
        this.contractId = contractId;
        this.accountId = accountId;
        this.productService = (ProductService)context.getPort(ProductService.class, 0);
        this.productOrderService = (ProductOrderService)context.getPort(ProductOrderService.class, 0);
    }

    protected void jbInit() {
        this.table = new BGUTable(this.model);
        this.historyTable = new BGUTable(this.historyModel);
        this.productForm = new ProductForm((ClientContext)this.getContext());
        BGEditor editor = new BGEditor();
        editor.setVisible(false);
        editor.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        editor.addForm((JComponent)((Object)this.productForm));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)this.productForm));
        toolBar.compact();
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)editor);
        BGSwingUtilites.handleEdit((JTable)this.historyTable, (AbstractBGUPanel)editor);
        this.monthAndDays = new BGControlPanelMonthAndDays(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 0), 0, 0));
        panel.add((Component)this.monthAndDays, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.historyTable), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("\u0422\u0435\u043a\u0443\u0449\u0438\u0435", BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)this.table)));
        tabbedPane.addTab("\u0418\u0441\u0442\u043e\u0440\u0438\u044f", panel);
        JPanel productPanel = new JPanel(new BorderLayout());
        productPanel.add((Component)toolBar, "North");
        productPanel.add((Component)tabbedPane, "Center");
        productPanel.add((Component)editor, "South");
        BGEditor editor2 = new BGEditor("productPanel");
        editor2.addForm((JComponent)productPanel, (Object)"productPanel");
        editor2.addForm((JComponent)((Object)new PeriodPanel(this)));
        this.setLayout(new BorderLayout());
        this.add((Component)editor2, "Center");
        this.monthAndDays.addActionListener(this.refresh);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.productForm.activate.setEnabled(enabled);
        this.productForm.deactivate.setEnabled(enabled);
        this.productForm.add.setEnabled(enabled);
        this.productForm.edit.setEnabled(enabled);
        this.productForm.remove.setEnabled(enabled);
    }

    private Directory<ProductSpec> getProductSpecDirectory() throws BGException {
        return ((ClientContext)this.getContext()).getDirectory(ProductSpec.class, 0);
    }

    public void setAccountId(Integer id) {
        this.accountId = id;
    }

    class ProductTableModel
    extends BGTableModel<Product> {
        private Directory<ProductSpec> productSpecDirectory;

        public ProductTableModel(String name) throws BGException {
            super(name);
            this.productSpecDirectory = null;
            this.productSpecDirectory = ProductPanel.this.getProductSpecDirectory();
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", -1, 180, -1, "product", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, 180, -1, "description", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", 150, 150, 150, "timeFrom", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", 150, 150, 150, "timeTo", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e \u0434\u043e", 150, 150, 150, "subscriptionTimeTo", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 120, 120, 120, "deviceState", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c (\u0438\u0437 MW)", 140, 140, 140, "activationPrice", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 80, 200, -1, "comment", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(Product product, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("product".equals(identifier)) {
                try {
                    return this.productSpecDirectory.get(product.getProductSpecId());
                }
                catch (BGException e) {
                    e.printStackTrace();
                    return e.getMessage();
                }
            }
            if ("deviceState".equals(identifier)) {
                return product.getDeviceState() == 1 ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d" : "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
            }
            return super.getValue((Object)product, column);
        }

        public void setData(List<Product> data) {
            try {
                this.productSpecDirectory = ProductPanel.this.getProductSpecDirectory();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            super.setData(data);
        }
    }

    class ProductForm
    extends ProductFormBase {
        AbstractBGUPanel.DefaultAction activate;
        AbstractBGUPanel.DefaultAction deactivate;
        AbstractBGUPanel.DefaultAction add;
        AbstractBGUPanel.DefaultAction edit;
        AbstractBGUPanel.DefaultAction remove;

        public ProductForm(ClientContext context) {
            super(context);
            this.activate = new AbstractBGUPanel.DefaultAction("activate", "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442", ClientUtils.getIcon((String)"fugue/present--plus")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ProductForm.this.current = new Product();
                    List offerings = ProductPanel.this.productOrderService.productOfferingList(Integer.valueOf(((ClientContext)ProductForm.this.getContext()).getModuleId()), ProductPanel.this.contractId.intValue(), ProductPanel.this.accountId.intValue(), -1, new Date(), true, false);
                    new ProductEditor("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", ProductForm.this.current, offerings, "activate").getDialog().setVisible(true);
                    ProductPanel.this.refresh.perform();
                }
            };
            this.deactivate = new AbstractBGUPanel.DefaultAction("deactivate", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442", ClientUtils.getIcon((String)"fugue/present--minus")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (!ProductPanel.this.table.isShowing()) {
                        return;
                    }
                    ProductForm.this.current = (Product)ProductPanel.this.model.getSelectedRow();
                    if (ProductForm.this.current != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442?", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 0) == 0) {
                        ProductPanel.this.productOrderService.productDeactivate(((ClientContext)ProductForm.this.getContext()).getContractId(), ProductForm.this.current.getId(), null, false, true, false);
                        ProductPanel.this.refresh.perform();
                    }
                }
            };
            this.add = new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", ClientUtils.getIcon((String)"item_add")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ProductForm.this.current = new Product();
                    new ProductEditor("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", ProductForm.this.current, ProductForm.this.toProductOfferingList(ProductPanel.this.getProductSpecDirectory().list()), "add").getDialog().setVisible(true);
                    ProductPanel.this.refresh.perform();
                }
            };
            this.edit = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", ClientUtils.getIcon((String)"item_edit")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    Product product = ProductForm.this.current = ProductPanel.this.table.isShowing() ? (Product)ProductPanel.this.model.getSelectedRow() : (Product)ProductPanel.this.historyModel.getSelectedRow();
                    if (ProductForm.this.current != null) {
                        new ProductEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", ProductForm.this.current, ProductForm.this.toProductOfferingList(ProductPanel.this.getProductSpecDirectory().list()), "edit").getDialog().setVisible(true);
                        ProductPanel.this.refresh.perform();
                    }
                }
            };
            this.remove = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", ClientUtils.getIcon((String)"item_delete")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    Product product = ProductForm.this.current = ProductPanel.this.table.isShowing() ? (Product)ProductPanel.this.model.getSelectedRow() : (Product)ProductPanel.this.historyModel.getSelectedRow();
                    if (ProductForm.this.current != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                        ProductPanel.this.productService.productDelete(ProductForm.this.current.getContractId(), ProductForm.this.current.getId());
                        ProductPanel.this.refresh.perform();
                    }
                }
            };
        }
    }

    class ProductEditor
    extends BGEditorDialog<Product> {
        private String mode;
        private List<ProductOffering> offerings;
        private BGUComboBox<ProductOffering> productSpec;
        private BGUComboBox<ProductOfferingActivationMode> activationMode;
        private BGCalendarButton dateFrom;
        private BGTimeButton timeFrom;
        private BGCalendarButton dateTo;
        private BGTimeButton timeTo;
        private JTextArea comment;
        private JTabbedPane tabbedPane;
        private JTextField description;

        public ProductEditor(String title, Product data, List<ProductOffering> offerings, String mode) {
            super(title, (Object)data);
            this.mode = null;
            this.offerings = null;
            this.productSpec = new BGUComboBox();
            this.activationMode = new BGUComboBox();
            this.dateFrom = new BGCalendarButton();
            this.timeFrom = new BGTimeButton();
            this.dateTo = new BGCalendarButton();
            this.timeTo = new BGTimeButton();
            this.comment = new JTextArea(10, 30);
            this.tabbedPane = new JTabbedPane();
            this.description = new JTextField(30);
            this.offerings = offerings;
            this.mode = mode;
        }

        public void doDialogPanel() {
            this.tabbedPane.add((Component)this.getBasePanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
            this.tabbedPane.add((Component)this.getCommentPanel(), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            try {
                this.productSpec.setData(this.offerings);
                this.productSpec.setSelectedItem((Object)((Product)this.data).getProductSpecId());
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            this.productSpec.setEnabled(((Product)this.data).getProductSpecId() < 1);
            LocalDateTime from = TimeUtils.convertDateToLocalDateTime((Date)((Product)this.data).getTimeFrom());
            this.dateFrom.setLocalDate(from != null ? from.toLocalDate() : null);
            this.timeFrom.setTime(from != null ? from.toLocalTime() : null);
            LocalDateTime to = TimeUtils.convertDateToLocalDateTime((Date)((Product)this.data).getTimeTo());
            this.dateTo.setLocalDate(to != null ? to.toLocalDate() : null);
            this.timeTo.setTime(to != null ? to.toLocalTime() : null);
            boolean toEnabled = !"activate".equals(this.mode);
            this.dateTo.setEnabled(toEnabled);
            this.timeTo.setEnabled(toEnabled);
            this.description.setText(((Product)this.data).getDescription());
            this.comment.setText(((Product)this.data).getComment());
        }

        public boolean doApply() throws Exception {
            ((Product)this.data).setTimeFrom(this.getDate(this.dateFrom.getLocalDate(), this.timeFrom.getTime()));
            ((Product)this.data).setTimeTo(this.getDate(this.dateTo.getLocalDate(), this.timeTo.getTime()));
            if (((Product)this.data).getTimeFrom() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
                return false;
            }
            ProductOffering selectedProduct = (ProductOffering)this.productSpec.getSelectedItem();
            if (!this.checkIncompatible(selectedProduct, (Product)this.data)) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0443\u0436\u0435 \u0438\u043c\u0435\u044e\u0449\u0438\u043c\u0438\u0441\u044f");
                return false;
            }
            if (selectedProduct == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442");
                return false;
            }
            if (this.activationMode.getSelectedItem() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438");
                return false;
            }
            ((Product)this.data).setProductSpecId(selectedProduct.getProductSpec().getId());
            ((Product)this.data).setActivationModeId(((ProductOfferingActivationMode)this.activationMode.getSelectedItem()).getProductSpecActivationMode().getId());
            ((Product)this.data).setAccountId(ProductPanel.this.accountId.intValue());
            ((Product)this.data).setContractId(((ClientContext)ProductPanel.this.getContext()).getContractId());
            ((Product)this.data).setDescription(this.description.getText());
            ((Product)this.data).setComment(this.comment.getText());
            if ("activate".equals(this.mode)) {
                Date time = ((Product)this.data).getTimeFrom() != null && Math.abs(TimeUtils.daysDelta((Date)((Product)this.data).getTimeFrom(), (Date)new Date())) < 210 ? ((Product)this.data).getTimeFrom() : null;
                ProductPanel.this.productOrderService.productActivate((Product)this.data, time, false, true);
            } else {
                ProductPanel.this.productService.productUpdate((Product)this.data);
            }
            return true;
        }

        private boolean checkIncompatible(ProductOffering newProduct, Product product) throws BGException {
            if (newProduct == null) {
                return true;
            }
            List productsOnContract = ProductPanel.this.productService.productList(((ClientContext)ProductPanel.this.getContext()).getModuleId(), ProductPanel.this.contractId.intValue(), ProductPanel.this.accountId.intValue(), false, null, null, new Date(), new Date(), true, true);
            if (productsOnContract.stream().anyMatch(p -> p.getId() == product.getId())) {
                return true;
            }
            Set incompatible = newProduct.getProductSpec().getIncompatible();
            if (Utils.isEmptyCollection((Collection)incompatible)) {
                return true;
            }
            for (Product contractProduct : productsOnContract) {
                int productSpecId = contractProduct.getProductSpecId();
                if (!incompatible.contains(productSpecId) || contractProduct.getTimeTo() != null && !contractProduct.getTimeTo().after(product.getTimeFrom())) continue;
                return false;
            }
            return true;
        }

        private Date getDate(LocalDate localDate, LocalTime localTime) {
            Date date = null;
            if (localDate != null) {
                date = TimeUtils.convertLocalDateTimeToDate((LocalDateTime)LocalDateTime.of(localDate, localTime != null ? localTime : LocalTime.of(0, 0)));
            }
            return date;
        }

        private JPanel getBasePanel() {
            this.productSpec.addActionListener(e -> {
                ProductOffering selected = (ProductOffering)this.productSpec.getSelectedItem();
                if (selected != null) {
                    ProductOfferingActivationMode currentMode;
                    List list = selected.getActivationModeList();
                    this.activationMode.setData(list);
                    if (this.data != null && ((Product)this.data).getActivationModeId() > 0 && (currentMode = (ProductOfferingActivationMode)Utils.maskNull((List)list).stream().filter(a -> a.getProductSpecActivationMode().getId() == ((Product)this.data).getActivationModeId()).findFirst().orElse(null)) != null) {
                        this.activationMode.setSelectedItem((Object)currentMode);
                    }
                }
            });
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.productSpec, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.activationMode, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.description, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getCommentPanel() {
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.comment.setWrapStyleWord(true);
            this.comment.setLineWrap(true);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            return panel;
        }

        private JPanel getPeriodPanel() {
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.dateFrom, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel(":"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.timeFrom, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.dateTo, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel(":"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.timeTo, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }
    }
}

