/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvApplication;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.util.SetCache;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;

public abstract class TvAccountRuntime {
    public static final SetCache<Integer> DEVICE_OPTIONS_SET_CACHE = new SetCache(256);
    volatile TvAccountRuntime parent;
    public final int tvAccountId;
    private volatile TvAccount tvAccount;
    volatile long dateFromMillis;
    volatile long dateToMillis;
    public final AtomicReference<TvAccountSpecRuntime> tvAccountSpecRef;
    private static final ParameterMap EMPTY_PARAMETER_MAP = new Preferences();
    private ParameterMap config;
    private boolean created = false;
    private volatile TvAccountRuntime parentInetServRuntime;
    volatile ContractStatusList contractSuspendPeriods;

    public TvAccountRuntime(int tvAccountId, AtomicReference<TvAccountSpecRuntime> servTypeRef, TvAccountRuntime parent) {
        this.parent = parent;
        this.tvAccountId = tvAccountId;
        this.tvAccountSpecRef = servTypeRef;
    }

    public abstract ContractRuntime getContractRuntime();

    public abstract TariffModuleTreeSet getTariffTreeSet();

    public abstract ProductRuntimeList getProductRuntimeList();

    public abstract ProductPeriodRuntimeList getProductPeriodRuntimeList();

    public abstract ServiceRuntimeList getServiceRuntimeList();

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("ContractId: ");
        result.append(this.getTvAccount().getContractId());
        result.append("; tvAccountId: ");
        result.append(this.tvAccountId);
        result.append("\n\t");
        result.append(TvAccount.toString((TvAccount)this.getTvAccount()));
        result.append("] ");
        result.append(this.getTariffTreeSet());
        result.append("\n\t");
        result.append("Device state: ");
        result.append(this.getTvAccount().getDeviceState());
        result.append("; serviceIds:");
        result.append(Utils.toString((Iterable)this.getTvAccount().getDeviceOptionIds()));
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTvAccount(TvAccount tvAccount) {
        this.lock();
        try {
            TvAccount oldInetServ = this.tvAccount;
            if (oldInetServ != null) {
                tvAccount.setDeviceState(oldInetServ.getDeviceState());
                tvAccount.setDeviceOptionIds(oldInetServ.getDeviceOptionIds());
            } else {
                tvAccount.setDeviceOptionIds(DEVICE_OPTIONS_SET_CACHE.intern(tvAccount.getDeviceOptionIds()));
            }
            tvAccount.setComment(null);
            tvAccount.setContractTitle(null);
            tvAccount.setContractComment(null);
            tvAccount.setDeviceTitle(null);
            tvAccount.setInterfaceTitle(null);
            tvAccount.setSpecTitle(null);
            tvAccount.setAccessCodeTitle(null);
            tvAccount.setTitle("");
            if ("".equals(tvAccount.getLogin())) {
                tvAccount.setLogin("");
            }
            if ("".equals(tvAccount.getPassword())) {
                tvAccount.setPassword("");
            }
            if ("".equals(tvAccount.getConfig())) {
                tvAccount.setConfig("");
            }
            if (tvAccount.getChildren() != null && tvAccount.getChildren().isEmpty()) {
                tvAccount.setChildren(Collections.emptyList());
            }
            this.tvAccount = tvAccount;
            GregorianCalendar utilCalendar = new GregorianCalendar();
            this.dateFromMillis = TvUtils.dateFrom(tvAccount.getDateFrom(), utilCalendar);
            this.dateToMillis = TvUtils.dateTo(tvAccount.getDateTo(), utilCalendar);
            String config = tvAccount.getConfig();
            this.config = Utils.isBlankString((String)config) ? EMPTY_PARAMETER_MAP : new Preferences(config, "\n");
        }
        finally {
            this.unlock();
        }
    }

    public ParameterMap getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceStateAndOptionIds(String deviceAccountId, short deviceState, Set<Integer> deviceOptionIds) {
        this.lock();
        try {
            TvAccount tvAccount = this.tvAccount;
            if (deviceAccountId != null) {
                tvAccount.setDeviceAccountId(deviceAccountId);
            }
            if (deviceState != -1000) {
                tvAccount.setDeviceState(deviceState);
            }
            if (deviceOptionIds != null) {
                tvAccount.setDeviceOptionIds(DEVICE_OPTIONS_SET_CACHE.intern(deviceOptionIds));
            }
        }
        finally {
            this.unlock();
        }
    }

    public TvAccount getTvAccount() {
        return this.tvAccount;
    }

    public TvAccount getParentTvAccount(TvApplication application) {
        return this.getParentTvAccountRuntime(application).getTvAccount();
    }

    public TvAccountRuntime getParentTvAccountRuntime(TvApplication application) {
        TvAccountRuntime parentInetServRuntime = this.parentInetServRuntime;
        if (parentInetServRuntime == null) {
            int parentId = this.tvAccount.getParentId();
            parentInetServRuntime = parentId > 0 ? (this.parentInetServRuntime = application.tvAccountRuntimeMap.get(parentId)) : (this.parentInetServRuntime = this);
        }
        return parentInetServRuntime;
    }

    public ContractStatusList getContractSuspendPeriods() {
        return this.contractSuspendPeriods;
    }

    public abstract void lock();

    public abstract boolean tryLock();

    public abstract boolean tryLock(long var1, TimeUnit var3) throws InterruptedException;

    public abstract void unlock();

    public abstract boolean isHeldByCurrentThread();

    public long getDateFromMillis() {
        return this.dateFromMillis;
    }

    public void setDateFromMillis(long dateFromMillis) {
        this.dateFromMillis = dateFromMillis;
    }

    public long getDateToMillis() {
        return this.dateToMillis;
    }

    public void setDateToMillis(long dateToMillis) {
        this.dateToMillis = dateToMillis;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }
}

