/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.event.worker;

import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.Utils;

public class TinkoffAutopaymentEventWorker
extends EventWorker {
    private static final Logger logger = LogManager.getLogger();
    private final int moduleId;
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private ContractDao contractDao;

    public TinkoffAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), TinkoffAutopaymentEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        logger.info("Starting TinkoffAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "tinkoff-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.contractDao = new ContractDao(((EventListenerContext)this.context).getConnection(), 0);
        try {
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.contractDao.close();
            this.autopaymentManager.close();
            this.transactionManager.close();
            this.contractDao = null;
            this.transactionManager = null;
            this.autopaymentManager = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        Contract contract;
        TinkoffAutopaymentEvent event = (TinkoffAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
        BigDecimal sum = event.getSum();
        if (sum == null) {
            sum = autopayment.getSum();
        }
        if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = (Contract)this.contractDao.get(contractId)) != null) {
            String customerAddress = this.getCustomerAddress(contractId);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            Transaction transaction = this.transactionManager.registerOrder(contractId, contract.getTitle(), customerAddress, sum, dataMap, true, false);
            this.transactionManager.doCharge(transaction, autopayment);
        }
        return null;
    }

    private String getCustomerAddress(int contractId) throws BGException {
        ContractModuleConfigDao contractModuleConfigDao;
        String customerAddress = null;
        try {
            contractModuleConfigDao = new ContractModuleConfigDao(((EventListenerContext)this.context).getConnection(), this.moduleId);
            try {
                customerAddress = contractModuleConfigDao.get(contractId, "customerAddress");
            }
            finally {
                contractModuleConfigDao.close();
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        if (Utils.isBlankString((String)customerAddress)) {
            contractModuleConfigDao = new ContractModuleConfigDao(((EventListenerContext)this.context).getConnection(), 0);
            try {
                customerAddress = contractModuleConfigDao.get(contractId, "payment.phone");
                if (Utils.isBlankString((String)customerAddress)) {
                    customerAddress = contractModuleConfigDao.get(contractId, "payment.email");
                }
            }
            finally {
                contractModuleConfigDao.close();
            }
        }
        return customerAddress;
    }
}

