/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.utils;

import bitel.billing.server.admin.bean.AddressManager;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.Customer;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContactType;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.server.bean.AddressStruct;

public class SormUploadHelper {
    private Preferences config;
    private SormContract currentContract;
    private int currentContractId;
    private int billMid;
    private Connection connection;
    private ContractParameterManager cpm;
    private AddressManager addressManager;
    private CustomerDao customerDao;
    private int superContractId;
    private JSONObject customer;

    public SormUploadHelper(Preferences config, Connection connection, AddressManager addressManager) throws BGException {
        this.config = config;
        this.connection = connection;
        this.cpm = new ContractParameterManager(connection);
        this.addressManager = addressManager;
        this.customerDao = new CustomerDao(connection);
        this.billMid = this.getIntFromConfig("sorm.bill.mid");
    }

    public void setCurrentContract(SormContract sormContract) throws BGException {
        this.currentContract = sormContract;
        this.currentContractId = sormContract.getContractId();
        if (sormContract.isSub()) {
            this.superContractId = this.currentContract.getScid();
        }
        this.setCustomer();
    }

    public void setCurrentContract(Contract contract) throws BGException {
        this.setCurrentContract(this.convertContractToSormContract(contract));
    }

    public SormContract convertContractToSormContract(Contract contract) {
        ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract newContract = contract.getNewContract();
        return new SormContract(newContract.getId(), newContract.getTitle(), newContract.getDateFrom(), newContract.getDateTo(), newContract.getPersonType() == 0, newContract.getStatus(), newContract.isSub(), newContract.getSuperCid());
    }

    private void setCustomer() throws BGException {
        Optional customerLink = this.customerDao.getCustomerLink(this.currentContractId, LocalDateTime.now());
        this.customer = this.customerDao.getCustomerDataJson(customerLink.map(CustomerLink::getCustomerId).orElse(-1).intValue());
    }

    private String getCustomerValueByQuery(String jsonQuery) {
        Object value = this.customer.optQuery(jsonQuery);
        return value != null ? value.toString() : "";
    }

    public String getFirstName() throws BGException {
        String firstName = this.getStringParam("sorm.upload.fiz.firstname");
        if (Utils.isBlankString((String)firstName)) {
            firstName = this.getCustomerValueByQuery(Customer.CustomerFiz.FIRST_NAME.key());
        }
        return firstName;
    }

    public String getLastName() throws BGException {
        String lastName = this.getStringParam("sorm.upload.fiz.lastname");
        if (Utils.isBlankString((String)lastName)) {
            lastName = this.getCustomerValueByQuery(Customer.CustomerFiz.LAST_NAME.key());
        }
        return lastName;
    }

    public String getMiddleName() throws BGException {
        String midlleName = this.getStringParam("sorm.upload.fiz.middlename");
        if (Utils.isBlankString((String)midlleName)) {
            midlleName = this.getCustomerValueByQuery(Customer.CustomerFiz.MIDDLE_NAME.key());
        }
        return midlleName;
    }

    public String getDocumentSerial() throws BGException {
        String documentSerial = this.getStringParam("sorm.upload.fiz.documentserial");
        if (Utils.isBlankString((String)documentSerial)) {
            documentSerial = this.getCustomerValueByQuery(Customer.CustomerFizDocument.SERIAL.key());
        }
        return documentSerial;
    }

    public String getDocumentNumber() throws BGException {
        String documentNumber = this.getStringParam("sorm.upload.fiz.documentnumber");
        if (Utils.isBlankString((String)documentNumber)) {
            documentNumber = this.getCustomerValueByQuery(Customer.CustomerFizDocument.NUMBER.key());
        }
        return documentNumber;
    }

    public String getDocumentWhoGive() throws BGException {
        String documentWhoGive = this.getStringParam("sorm.upload.fiz.documentwhogive");
        if (Utils.isBlankString((String)documentWhoGive)) {
            documentWhoGive = this.getCustomerValueByQuery(Customer.CustomerFizDocument.WHO_GIVE.key());
        }
        return documentWhoGive;
    }

    public String getDocumentWhenGive(String format) {
        String whenGive = this.getDateParam("sorm.upload.fiz.documentwhengive", format);
        if (Utils.isBlankString((String)whenGive) && Utils.notBlankString((String)(whenGive = this.getCustomerValueByQuery(Customer.CustomerFizDocument.WHEN_GIVE.key())))) {
            whenGive = TimeUtils.format((LocalDate)LocalDate.parse(whenGive), (String)"dd.MM.yyyy");
        }
        return whenGive;
    }

    public String getBirthday(String format) {
        String birthday = this.getDateParam("sorm.upload.fiz.birthday", format);
        if (Utils.isBlankString((String)birthday) && Utils.notBlankString((String)(birthday = this.getCustomerValueByQuery(Customer.CustomerFiz.BIRTHDAY.key())))) {
            birthday = TimeUtils.format((LocalDate)LocalDate.parse(birthday), (String)format);
        }
        return birthday;
    }

    public String getStringParam(String configKey) {
        return this.getStringParam(this.getIntFromConfig(configKey), true);
    }

    public String getStringParam(String configKey, boolean checkSuperContract) {
        return this.getStringParam(this.getIntFromConfig(configKey), checkSuperContract);
    }

    public String getStringParam(int pid, boolean checkSuperContract) {
        String result = this.cpm.getStringParam(this.currentContractId, pid);
        if (Utils.isBlankString((String)result) && this.currentContract.isSub() && checkSuperContract) {
            result = this.cpm.getStringParam(this.superContractId, pid);
        }
        if (Utils.isBlankString((String)result)) {
            return "";
        }
        return result.trim();
    }

    public String getEmail(boolean isFiz) {
        int emailPid = Utils.parseInt((String)(isFiz ? this.config.get("sorm.upload.fiz.email") : this.config.get("sorm.upload.org.email")), (int)-1);
        if (emailPid < 0) {
            return "";
        }
        return Utils.maskBlank((String)this.cpm.getStringParam(this.currentContractId, emailPid), (String)"");
    }

    public String getDateParam(String configKey) {
        return this.getDateParam(configKey, null);
    }

    public String getDateParam(String configKey, String format) {
        Calendar date = this.cpm.getDateParam(this.currentContractId, this.getIntFromConfig(configKey));
        if (date == null && this.currentContract.isSub()) {
            date = this.cpm.getDateParam(this.superContractId, this.getIntFromConfig(configKey));
        }
        if (date == null) {
            return "";
        }
        if (Utils.isBlankString((String)format)) {
            return TimeUtils.formatFullDate((Date)date.getTime());
        }
        return TimeUtils.format((Calendar)date, (String)format);
    }

    private int getIntFromConfig(String configKey) {
        return this.config.getInt(configKey, -1);
    }

    public String getBankTitle() throws BGException {
        String bankTitle = this.getStringParam("sorm.upload.org.banktitle");
        if (Utils.isBlankString((String)bankTitle)) {
            bankTitle = this.getAttributeFromBill("sorm.bill.attr.banktitle");
        }
        return Utils.maskBlank((String)bankTitle, (String)"").trim();
    }

    public String getBankAccount() throws BGException {
        String bankAccount = this.getStringParam("sorm.upload.org.account");
        if (Utils.isBlankString((String)bankAccount)) {
            bankAccount = this.getAttributeFromBill("sorm.bill.attr.account");
        }
        if (Utils.isBlankString((String)bankAccount)) {
            bankAccount = this.getCustomerValueByQuery(Customer.Bank.ACCOUNT.key());
        }
        return Utils.maskBlank((String)bankAccount, (String)"").trim();
    }

    public String getFullTitleOrg() throws BGException {
        String fullTitle = this.getStringParam("sorm.upload.org.fulltitle");
        if (Utils.isBlankString((String)fullTitle)) {
            fullTitle = this.getAttributeFromBill("sorm.bill.attr.fulltitle");
        }
        if (Utils.isBlankString((String)fullTitle)) {
            fullTitle = this.getCustomerValueByQuery(Customer.CustomerJur.NAME.key());
        }
        return Utils.maskBlank((String)fullTitle, (String)"").trim();
    }

    public String getINN() throws BGException {
        String inn = this.getStringParam("sorm.upload.org.inn");
        if (Utils.isBlankString((String)inn)) {
            inn = this.getAttributeFromBill("sorm.bill.attr.inn");
        }
        if (Utils.isBlankString((String)inn)) {
            inn = this.getCustomerValueByQuery(Customer.CustomerJur.INN.key());
        }
        return Utils.maskBlank((String)inn, (String)"").trim();
    }

    public String getBIK() throws BGException {
        String bik = this.getStringParam("sorm.upload.org.bankbik");
        if (Utils.isBlankString((String)bik)) {
            this.getAttributeFromBill("sorm.bill.attr.bik");
        }
        if (Utils.isBlankString((String)bik)) {
            bik = this.customer.optString(Customer.Bank.BIK.key(), "");
        }
        return Utils.maskBlank((String)bik, (String)"").trim();
    }

    public String getPhoneParam(String configKey) {
        String phoneNumber;
        int phonePid = this.getIntFromConfig(configKey);
        if (phonePid < 0) {
            return "";
        }
        PhoneParamValue phoneParam = this.cpm.getPhoneParam(this.currentContractId, phonePid);
        if (phoneParam == null && this.currentContract.isSub()) {
            phoneParam = this.cpm.getPhoneParam(this.superContractId, phonePid);
        }
        String string = phoneNumber = phoneParam != null ? phoneParam.getPhoneItem(0).getPhone() : this.cpm.getStringParam(this.currentContractId, phonePid);
        if (Utils.isBlankString((String)phoneNumber) && this.currentContract.isSub()) {
            phoneNumber = this.cpm.getStringParam(this.superContractId, phonePid);
        }
        if (Utils.isBlankString((String)phoneNumber)) {
            phoneNumber = this.getCustomerValueByQuery(CustomerContactType.PHONE.key);
        }
        return Utils.maskBlank((String)phoneNumber, (String)"");
    }

    public String getContactFacePhone() {
        PhoneParamValue phoneParam;
        String phone = this.getStringParam("sorm.upload.org.contactfacenumber");
        if (Utils.isBlankString((String)phone)) {
            phoneParam = this.cpm.getPhoneParam(this.currentContractId, this.getIntFromConfig("sorm.upload.org.contactfacenumber"));
            String string = phone = phoneParam == null ? "" : phoneParam.getPhoneItem(0).getPhone();
        }
        if (Utils.isBlankString((String)phone)) {
            phoneParam = this.cpm.getPhoneParam(this.superContractId, this.getIntFromConfig("sorm.upload.org.contactfacenumber"));
            phone = phoneParam == null ? "" : phoneParam.getPhoneItem(0).getPhone();
        }
        return Utils.maskBlank((String)phone, (String)"").trim();
    }

    public AddressStruct getAddressByPid(int pid) {
        AddressStruct address = this.addressManager.getAddress(this.currentContractId, pid);
        if (!SormUtils.checkValidAddress(address) && this.currentContract.isSub()) {
            address = this.addressManager.getAddress(this.superContractId, pid);
        }
        if (!SormUtils.checkValidAddress(address)) {
            return null;
        }
        return address;
    }

    public AddressStruct getAddress() {
        int addressPid = this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.address") : this.getIntFromConfig("sorm.upload.org.address");
        return this.getAddressByPid(addressPid);
    }

    public String getUnstructAddress() {
        int addressUnstructPid = this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.unstructaddress") : this.getIntFromConfig("sorm.upload.org.unstructaddress");
        String unstructAddress = this.getStringParam(addressUnstructPid, false);
        if (Utils.isBlankString((String)unstructAddress)) {
            unstructAddress = this.getCustomerValueByQuery(this.currentContract.isFiz() ? Customer.CustomerFizDocument.ADDRESS.key() : Customer.CustomerJur.ADDRESS.key());
        }
        if (Utils.isBlankString((String)unstructAddress) && this.currentContract.isSub()) {
            unstructAddress = this.getStringParam(addressUnstructPid, true);
        }
        if (Utils.isBlankString((String)unstructAddress)) {
            unstructAddress = this.getUserAddressValueFromAddressParameter(this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.address") : this.getIntFromConfig("sorm.upload.org.address"));
        }
        return Utils.maskBlank((String)unstructAddress, (String)"");
    }

    private String getUserAddressValueFromAddressParameter(int addressPid) {
        AddressStruct address = this.addressManager.getAddress(this.currentContractId, addressPid);
        if (SormUtils.checkValidAddress(address)) {
            return "";
        }
        return address != null ? address.getFullAddress() : "";
    }

    public AddressStruct getCommutatorsAddress() {
        int addressPid = this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.addressinstallcommutator") : this.getIntFromConfig("sorm.upload.org.addresscommutators");
        return this.getAddressByPid(addressPid);
    }

    public String getUnstructCommutatorsAddress() {
        int unstructAddressPid = this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.unstructaddressinstallcommutator") : this.getIntFromConfig("sorm.upload.org.addresscommutatorsunstruct");
        return this.getStringParam(unstructAddressPid, true);
    }

    public AddressStruct getAddressBills() {
        return this.getAddressByPid(this.currentContract.isFiz() ? -1 : this.getIntFromConfig("sorm.upload.org.addressbills"));
    }

    public String getUnstructAddressBills() {
        int addressUnstructPid = this.currentContract.isFiz() ? -1 : this.getIntFromConfig("sorm.upload.org.addressbillsunstruct");
        return this.getStringParam(addressUnstructPid, true);
    }

    public String getAttributeFromBill(String attributeName) throws BGException {
        String result = this.getAttributeFromBill(attributeName, this.currentContractId);
        if (Utils.isBlankString((String)result) && this.currentContract.isSub()) {
            result = this.getAttributeFromBill(attributeName, this.superContractId);
        }
        return result;
    }

    public String getAttributeFromBill(String attributeName, int contractId) throws BGException {
        String attr = this.config.get(attributeName, "");
        if (Utils.isBlankString((String)attr)) {
            return "";
        }
        String result = "";
        String tableName = ServerUtils.getModuleTableName((String)"bill_attribute", (int)this.billMid);
        if (ServerUtils.tableExists((Connection)this.connection, (String)tableName)) {
            String query = "SELECT value FROM " + tableName + " WHERE name=? AND cid=?";
            try (PreparedStatement ps = this.connection.prepareStatement(query);){
                int index = 1;
                ps.setString(index++, attr);
                ps.setInt(index, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = rs.getString("value");
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    public boolean contractIsActive() {
        Date contractDateTo = this.currentContract.getDateTo();
        if (contractDateTo == null) {
            return true;
        }
        return contractDateTo.after(new Date());
    }

    public SormContract getCurrentContract() {
        return this.currentContract;
    }
}

