/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.server.service;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyProduct;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransaction;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransactionLog;
import ru.bitel.bgbilling.modules.softkey.common.service.SoftkeyService;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyParams;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyTransactionManager;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.softkey.common.service.SoftkeyService")
public class SoftkeyServiceImpl
extends AbstractService
implements SoftkeyService {
    private static SoftkeyParams params = null;
    private SoftkeyTransactionManager transactionManager = null;
    private List<SoftkeyProduct> productList = new ArrayList<SoftkeyProduct>();

    @PostConstruct
    public void init() {
        params = new SoftkeyParams(Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
        this.transactionManager = new SoftkeyTransactionManager(this.getConnection(), this.moduleId);
    }

    public List<SoftkeyTransaction> getTransactionList(String contractTitle, int status, Date fromDate, Date toDate) throws BGException {
        List<SoftkeyTransaction> result = this.transactionManager.getTransactionlist(contractTitle, status, fromDate, toDate);
        return result;
    }

    public SoftkeyTransaction getTransactionById(int transactionId) throws BGException {
        SoftkeyTransaction result = this.transactionManager.getTransactionById(transactionId);
        return result;
    }

    public SoftkeyTransaction getTransactionByCid(int contractId, int optionId) throws BGException {
        SoftkeyTransaction result = this.transactionManager.getTransactionByCid(contractId, optionId);
        return result;
    }

    public List<SoftkeyTransactionLog> getTransactionLog(int transactionId) throws BGException {
        return this.transactionManager.getTransactionLog(transactionId);
    }

    public List<SoftkeyProduct> getProductList() throws BGException, IOException {
        this.productList = this.transactionManager.getProductList();
        return this.productList;
    }

    public void activate(int contractId, int count, int optionId) throws BGException, IOException {
        ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);
        Contract contract = (Contract)contractDao.get(contractId);
        contractDao.close();
        BalanceUtils bu = new BalanceUtils(this.getConnection());
        BigDecimal clientRest = bu.getBalance(new Date(), contract.getId());
        SoftkeyProduct product = this.transactionManager.getProductByOptionId(optionId);
        if (clientRest.compareTo(BigDecimal.ZERO) > 0 && clientRest.compareTo(product.getAmount()) <= 0) {
            bu.close();
            throw new BGMessageException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0447\u0435\u0442\u0443");
        }
        ContractParameterManager parameterManager = new ContractParameterManager(this.getConnection());
        String fio = parameterManager.getStringParam(contract.getId(), params.getFioPid());
        String email = parameterManager.getEmailParam(contract.getId(), params.getEmailPid()).getEmail();
        Pattern patternEmail = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2);
        Matcher matcherEmail = patternEmail.matcher(email);
        String emailString = null;
        if (matcherEmail.find()) {
            emailString = matcherEmail.group();
        }
        SoftkeyTransaction transaction = new SoftkeyTransaction();
        transaction.setStatus(0);
        transaction.setContractId(contractId);
        transaction.setDt(new Date());
        transaction.setOptionId(optionId);
        transaction.setSubscribeCount(count);
        transaction.setOptionTitle(this.getOptionTitle(optionId));
        transaction.setSubscribeAmount(product.getAmount());
        HashMap<String, String> dataParams = new HashMap<String, String>();
        dataParams.put("ac", String.valueOf(params.getAc()));
        dataParams.put("action", "ss-create_subscription");
        dataParams.put("option_id", String.valueOf(optionId));
        dataParams.put("isp_account_id", String.valueOf(contract.getId()));
        dataParams.put("isp_account_name", fio);
        dataParams.put("isp_account_email", emailString);
        dataParams.put("quantity", String.valueOf(count));
        dataParams.put("period", String.valueOf(1));
        Document answerDoc = SoftkeyUtils.send(dataParams, params, true);
        if (answerDoc != null) {
            if (SoftkeyUtils.hasError(answerDoc)) {
                SoftkeyUtils.setError(answerDoc);
                bu.close();
                throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430!");
            }
            if ((answerDoc = this.sendConfirmation(answerDoc)) != null) {
                if (SoftkeyUtils.hasError(answerDoc)) {
                    SoftkeyUtils.setError(answerDoc);
                    bu.close();
                    throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430!");
                }
                Element resultElement = XMLUtils.selectElement((Node)answerDoc, (String)"//result");
                String orderId = XMLUtils.selectElement((Node)resultElement, (String)"//order_id").getTextContent();
                String amount = XMLUtils.selectElement((Node)resultElement, (String)"//amount").getTextContent();
                String currency = XMLUtils.selectElement((Node)resultElement, (String)"//currency").getTextContent();
                String activationCode = XMLUtils.selectElement((Node)resultElement, (String)"//ActivationCode").getTextContent();
                BigDecimal clientAmount = Utils.parseBigDecimal((String)amount, (BigDecimal)BigDecimal.ZERO);
                Charge charge = new Charge();
                charge.setDate(new Date(System.currentTimeMillis()));
                charge.setContractId(contractId);
                charge.setSum(clientAmount);
                charge.setComment("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
                charge.setUserId(-1);
                charge.setTypeId(params.getChargeTypeId());
                new ChargeDao(this.getConnection()).update((Object)charge);
                ServerUtils.commitConnection((Connection)this.getConnection());
                bu.updateBalance(new Date(), contractId);
                this.context.publishAfterCommit((Event)new ChargeEvent(0, charge));
                this.context.publishAfterCommit((Event)new ContractBalanceChangedEvent(contract.getId(), 4, charge.getSum()));
                transaction.setOrderId(Utils.parseInt((String)orderId));
                transaction.setKey(activationCode);
                this.transactionManager.addTransaction(transaction);
                this.confirm(transaction, amount, currency);
            }
        }
        bu.close();
    }

    private void confirm(SoftkeyTransaction transaction, String amount, String currency) throws BGException, IOException {
        HashMap<String, String> dataParams = new HashMap<String, String>();
        dataParams.put("ac", String.valueOf(params.getAc()));
        dataParams.put("action", "ss-confirm_subscription");
        dataParams.put("isp_account_id", String.valueOf(transaction.getContractId()));
        dataParams.put("order_id", String.valueOf(transaction.getOrderId()));
        dataParams.put("currency", currency);
        dataParams.put("amount", amount);
        Document answerDoc = SoftkeyUtils.send(dataParams, params, true);
        if (answerDoc != null) {
            if (SoftkeyUtils.hasError(answerDoc)) {
                SoftkeyUtils.setError(answerDoc);
                throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
            }
            if ((answerDoc = this.sendConfirmation(answerDoc)) != null) {
                if (SoftkeyUtils.hasError(answerDoc)) {
                    SoftkeyUtils.setError(answerDoc);
                    throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
                }
                transaction.setPayDt(new Date());
                transaction.setStatus(1);
                this.transactionManager.updateTransaction(transaction);
            }
        }
    }

    public void pause(int contractId, int optionId) throws BGException, IOException {
        SoftkeyTransaction transaction = this.getTransactionByCid(contractId, optionId);
        HashMap<String, String> dataParams = new HashMap<String, String>();
        dataParams.put("ac", String.valueOf(params.getAc()));
        dataParams.put("action", "ss-pause");
        dataParams.put("isp_account_id", String.valueOf(contractId));
        Document answerDoc = SoftkeyUtils.send(dataParams, params, true);
        if (answerDoc != null) {
            if (SoftkeyUtils.hasError(answerDoc)) {
                SoftkeyUtils.setError(answerDoc);
                throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443!");
            }
            if ((answerDoc = this.sendConfirmation(answerDoc)) != null) {
                if (SoftkeyUtils.hasError(answerDoc)) {
                    SoftkeyUtils.setError(answerDoc);
                    throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
                }
                transaction.setStatus(2);
                this.transactionManager.updateTransaction(transaction);
            }
        }
    }

    public void continueSubscription(int contractId, int optionId) throws BGException, IOException {
        SoftkeyTransaction transaction = this.getTransactionByCid(contractId, optionId);
        Calendar statusCalendar = GregorianCalendar.getInstance();
        Calendar currentCalendar = GregorianCalendar.getInstance();
        currentCalendar.setTime(new Date(System.currentTimeMillis()));
        statusCalendar.setTime(transaction.getDt());
        int transactionDay = statusCalendar.get(5);
        int currentDay = currentCalendar.get(5);
        if (transactionDay == currentDay) {
            throw new BGMessageException("\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u0440\u0430\u043d\u0435\u0435, \u0447\u0435\u043c \u0432 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0441\u0443\u0442\u043a\u0438! \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u0437\u0430\u0432\u0442\u0440\u0430.");
        }
        HashMap<String, String> dataParams = new HashMap<String, String>();
        dataParams.put("ac", String.valueOf(params.getAc()));
        dataParams.put("action", "ss-continue");
        dataParams.put("isp_account_id", String.valueOf(contractId));
        Document answerDoc = SoftkeyUtils.send(dataParams, params, true);
        if (answerDoc != null) {
            if (SoftkeyUtils.hasError(answerDoc)) {
                SoftkeyUtils.setError(answerDoc);
                throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
            }
            if ((answerDoc = this.sendConfirmation(answerDoc)) != null) {
                if (SoftkeyUtils.hasError(answerDoc)) {
                    SoftkeyUtils.setError(answerDoc);
                    throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
                }
                transaction.setStatus(1);
                this.transactionManager.updateTransaction(transaction);
            }
        }
    }

    public void stop(int contractId, int optionId) throws BGException, IOException {
        SoftkeyTransaction transaction = this.transactionManager.getTransactionByCid(contractId, optionId);
        Calendar statusCalendar = GregorianCalendar.getInstance();
        Calendar currentCalendar = GregorianCalendar.getInstance();
        currentCalendar.setTime(new Date(System.currentTimeMillis()));
        statusCalendar.setTime(transaction.getDt());
        int transactionDay = statusCalendar.get(5);
        int currentDay = currentCalendar.get(5);
        if (transactionDay == currentDay) {
            throw new BGMessageException("\u041f\u0440\u0435\u043a\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u0440\u0430\u043d\u0435\u0435, \u0447\u0435\u043c \u0432 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0441\u0443\u0442\u043a\u0438! \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u0437\u0430\u0432\u0442\u0440\u0430.");
        }
        HashMap<String, String> dataParams = new HashMap<String, String>();
        dataParams.put("ac", String.valueOf(params.getAc()));
        dataParams.put("action", "ss-stop");
        dataParams.put("isp_account_id", String.valueOf(contractId));
        Document answerDoc = SoftkeyUtils.send(dataParams, params, true);
        if (answerDoc != null) {
            if (SoftkeyUtils.hasError(answerDoc)) {
                SoftkeyUtils.setError(answerDoc);
                throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
            }
            if ((answerDoc = this.sendConfirmation(answerDoc)) != null) {
                if (SoftkeyUtils.hasError(answerDoc)) {
                    SoftkeyUtils.setError(answerDoc);
                    throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
                }
                transaction.setStatus(3);
                this.transactionManager.updateTransaction(transaction);
            }
        }
    }

    public String getSubscribeStatus(int contractId) throws BGException, IOException {
        String status = null;
        HashMap<String, String> dataParams = new HashMap<String, String>();
        dataParams.put("ac", String.valueOf(params.getAc()));
        dataParams.put("action", "ss-get_list");
        dataParams.put("isp_account_id", String.valueOf(contractId));
        Document answerDoc = SoftkeyUtils.send(dataParams, params, false);
        if (answerDoc != null) {
            if (SoftkeyUtils.hasError(answerDoc)) {
                SoftkeyUtils.setError(answerDoc);
                throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430! \u0421\u043c. \u043b\u043e\u0433\u0438");
            }
            String code = this.getConfirmationCode(answerDoc);
            dataParams.clear();
            dataParams.put("iconfirmationcode", code);
            answerDoc = SoftkeyUtils.send(dataParams, params, false);
            if (answerDoc != null) {
                if (SoftkeyUtils.hasError(answerDoc)) {
                    SoftkeyUtils.setError(answerDoc);
                    throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430! \u0421\u043c. \u043b\u043e\u0433\u0438");
                }
                Element resultElement = XMLUtils.selectElement((Node)answerDoc, (String)"//result");
                status = XMLUtils.selectElement((Node)resultElement, (String)"//STATUS").getTextContent();
            }
        }
        return status;
    }

    private String getConfirmationCode(Document doc) {
        Element result = XMLUtils.selectElement((Node)doc, (String)"//result");
        Element confirmationCodeElement = XMLUtils.selectElement((Node)result, (String)"//confirmation_code");
        String code = confirmationCodeElement.getTextContent();
        return code;
    }

    private Document sendConfirmation(Document doc) throws BGException, IOException {
        HashMap<String, String> dataParams = new HashMap<String, String>();
        String code = this.getConfirmationCode(doc);
        dataParams.put("iconfirmationcode", code != null ? code : "");
        doc = SoftkeyUtils.send(dataParams, params, true);
        return doc;
    }

    private String getOptionTitle(int optionId) throws BGException {
        String result = this.transactionManager.getProductByOptionId(optionId).getSubscribeName();
        return result;
    }

    public void test() throws BGException, IOException {
        HashMap<String, String> dataParams = new HashMap<String, String>();
        dataParams.put("ac", String.valueOf(params.getAc()));
        dataParams.put("action", "test_action");
        dataParams.put("val", "5");
        SoftkeyUtils.send(dataParams, params, true);
    }
}

