/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostAccountDao
extends AbstractDao<ForpostAccount> {
    private Logger logger = LogManager.getLogger();
    private String tableNameAccountContract;

    public ForpostAccountDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_account");
        this.tableNameAccountContract = "smarthouse_forpost_account_contract_" + moduleId;
    }

    public List<ForpostAccount> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public List<Integer> getIds() throws BGException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        String sql = "SELECT id FROM " + this.tableName;
        try (Statement st = this.con.createStatement();){
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return ids;
    }

    protected ForpostAccount getFromRS(ResultSet rs) throws SQLException, BGException {
        ForpostAccount result = new ForpostAccount();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setMaxCameraCount(rs.getInt("max_camera_count"));
        result.setMaxLoginCount(rs.getInt("max_login_count"));
        result.setIsActive(rs.getInt("is_active"));
        result.setData(rs.getString("data"));
        return result;
    }

    protected void updateImpl(ForpostAccount forpostAccount) throws BGException {
        if (forpostAccount != null) {
            long now = System.currentTimeMillis();
            String sqlField = "name=?, max_camera_count=?, max_login_count=?, is_active=?, data=?, sync_datetime=?";
            String sql = "INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField;
            try (PreparedStatement ps = this.con.prepareStatement(sql);){
                int parameterIndex = 1;
                ps.setInt(parameterIndex++, forpostAccount.getId());
                ps.setString(parameterIndex++, forpostAccount.getName());
                ps.setInt(parameterIndex++, forpostAccount.getMaxCameraCount());
                ps.setInt(parameterIndex++, forpostAccount.getMaxLoginCount());
                ps.setInt(parameterIndex++, forpostAccount.getIsActive());
                ps.setString(parameterIndex++, forpostAccount.getData());
                ps.setLong(parameterIndex++, now);
                ps.setString(parameterIndex++, forpostAccount.getName());
                ps.setInt(parameterIndex++, forpostAccount.getMaxCameraCount());
                ps.setInt(parameterIndex++, forpostAccount.getMaxLoginCount());
                ps.setInt(parameterIndex++, forpostAccount.getIsActive());
                ps.setString(parameterIndex++, forpostAccount.getData());
                ps.setLong(parameterIndex++, now);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(ps.toString());
                }
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void updateAccountContract(int accountId, int contractId) throws BGException {
        int parameterIndex = 1;
        long now = System.currentTimeMillis();
        String sql = "INSERT INTO " + this.tableNameAccountContract + " SET account_id=?, contract_id=?, sync_datetime=? ON DUPLICATE KEY UPDATE sync_datetime=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setInt(parameterIndex++, accountId);
            ps.setInt(parameterIndex++, contractId);
            ps.setLong(parameterIndex++, now);
            ps.setLong(parameterIndex++, now);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ps.toString());
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostAccounts(SearchResult<ForpostAccount> searchResult, int contractId, String accountName) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS t1.*, t2.contract_id, t3.title as contract_title FROM " + this.tableName + " as t1 LEFT JOIN " + this.tableNameAccountContract + " AS t2 ON t1.id=t2.account_id LEFT JOIN contract AS t3 ON t3.id=t2.contract_id WHERE true" + (contractId > -1 ? (contractId > 0 ? " AND t2.contract_id=?" : " AND ISNULL(t2.contract_id)") : "") + (page != null ? page.sqlLimit() : ""), 1);){
            int parameterIndex = 1;
            if (contractId > 0) {
                ps.setInt(parameterIndex++, contractId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ForpostAccount forpostAccount = this.getFromRS(rs);
                forpostAccount.setContractId(rs.getInt("contract_id"));
                forpostAccount.setContractTitle(rs.getString("contract_title"));
                list.add(forpostAccount);
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void doSync(ForpostAccount[] accounts) throws BGException {
        int parameterIndex;
        PreparedStatement psDelete;
        if (accounts == null) {
            return;
        }
        long now = System.currentTimeMillis();
        String sqlField = "name=?, max_camera_count=?, max_login_count=?, data=?, sync_datetime=?";
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField);){
            psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>?");
            try {
                for (ForpostAccount forpostAccount : accounts) {
                    parameterIndex = 1;
                    psInsert.setInt(parameterIndex++, forpostAccount.getId());
                    psInsert.setString(parameterIndex++, forpostAccount.getName());
                    psInsert.setInt(parameterIndex++, forpostAccount.getMaxCameraCount());
                    psInsert.setInt(parameterIndex++, forpostAccount.getMaxLoginCount());
                    psInsert.setString(parameterIndex++, forpostAccount.getData());
                    psInsert.setLong(parameterIndex++, now);
                    psInsert.setString(parameterIndex++, forpostAccount.getName());
                    psInsert.setInt(parameterIndex++, forpostAccount.getMaxCameraCount());
                    psInsert.setInt(parameterIndex++, forpostAccount.getMaxLoginCount());
                    psInsert.setString(parameterIndex++, forpostAccount.getData());
                    psInsert.setLong(parameterIndex++, now);
                    psInsert.executeUpdate();
                }
                psDelete.setLong(1, now);
                psDelete.executeUpdate();
            }
            finally {
                if (psDelete != null) {
                    psDelete.close();
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        try (PreparedStatement psUpdate = this.con.prepareStatement("UPDATE " + this.tableNameAccountContract + " SET sync_datetime=? WHERE account_id=?");){
            psDelete = this.con.prepareStatement("DELETE FROM " + this.tableNameAccountContract + " WHERE sync_datetime<>?");
            try {
                for (ForpostAccount forpostAccount : accounts) {
                    parameterIndex = 1;
                    psUpdate.setLong(parameterIndex++, now);
                    psUpdate.setInt(parameterIndex++, forpostAccount.getId());
                    psUpdate.executeUpdate();
                }
                psDelete.setLong(1, now);
                psDelete.executeUpdate();
            }
            finally {
                if (psDelete != null) {
                    psDelete.close();
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostAccount getForpostAccount(int forpostAccountId) throws BGException {
        try {
            return (ForpostAccount)this.getById(forpostAccountId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteForpostAccount(int forpostAccountId) throws BGException {
        try (PreparedStatement psDelete1 = this.con.prepareStatement("DELETE FROM " + this.tableNameAccountContract + " WHERE account_id=?");
             PreparedStatement psDelete2 = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");){
            psDelete1.setInt(1, forpostAccountId);
            psDelete1.executeUpdate();
            psDelete2.setInt(1, forpostAccountId);
            psDelete2.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void unlinkForpostAccount(int forpostAccountId) throws BGException {
        try (PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableNameAccountContract + " WHERE account_id=?");){
            psDelete.setInt(1, forpostAccountId);
            psDelete.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

