/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.robokassa.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.modules.robokassa.common.bean.Transaction;
import ru.bitel.bgbilling.modules.robokassa.common.service.RobokassaService;
import ru.bitel.bgbilling.modules.robokassa.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.robokassa.common.service.RobokassaService")
public class RobokassaServiceImpl
extends AbstractService
implements RobokassaService {
    private static final Logger logger = LogManager.getLogger();
    private static final String PARAM_SIGNATURE_VALUE = "SignatureValue";
    private static final String PARAM_DESC = "Description";
    private static final String PARAM_INV_ID = "InvoiceID";
    private static final String PARAM_OUT_SUM = "OutSum";
    private static final String PARAM_MRCH_LOGIN = "MerchantLogin";
    private TransactionManager manager;

    @PostConstruct
    private void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(int contractId, String contractTitle, String status, Period period, String[] sort, Page page) throws BGException {
        SearchResult transactionSearchResult = new SearchResult(period, page, sort);
        this.manager.searchTransaction((SearchResult<Transaction>)transactionSearchResult, contractId, contractTitle, status);
        return transactionSearchResult;
    }

    public void checkTransaction(int transactiontId) throws BGException {
        this.manager.doCheckRequest(transactiontId);
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        if (contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (amount == null) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        if ((amount = amount.setScale(2, RoundingMode.HALF_EVEN)).compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.", "contractModule.notEnabled");
        }
        Connection con = this.getConnection();
        ModuleSetup moduleSetup = this.getModuleSetup();
        if (mode != null) {
            mode.value = "post";
        }
        if (url != null) {
            url.value = moduleSetup.get("robokassa.gate.url", "https://merchant.roboxchange.com/Index.aspx");
        }
        BigDecimal sum = amount;
        BigDecimal sumMin = moduleSetup.getBigDecimal("robokassa.sum.min", new BigDecimal(100));
        BigDecimal sumMax = moduleSetup.getBigDecimal("robokassa.sum.max", new BigDecimal(5000));
        if (sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            throw new BGException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
        }
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(con, Integer.valueOf(contractId));
        if (contractRuntime == null) {
            throw new BGException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!", "contract.notFound");
        }
        String description = moduleSetup.get("robokassa.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractRuntime.getContractTitle());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (paramsHolder != null) {
            paramsHolder.value = new MapHolder(dataMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> String.valueOf(e.getValue()))));
        }
        try (TransactionManager transactionManager = new TransactionManager(con, this.moduleId);){
            Transaction transaction = new Transaction();
            transaction.setSum(sum);
            transaction.setContractId(contractId);
            transaction.setCreateDate(new Date());
            transactionManager.update(transaction);
            dataMap.put(PARAM_INV_ID, String.valueOf(transaction.getId()));
        }
        Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
        String email = (String)params.get("email");
        dataMap.put(PARAM_MRCH_LOGIN, moduleSetup.get("robokassa.merchant.login", ""));
        dataMap.put(PARAM_OUT_SUM, new DecimalFormat("###########0.00").format(sum).replace(",", "."));
        dataMap.put(PARAM_DESC, description);
        if (Utils.notBlankString((String)email)) {
            dataMap.put("Email", email);
        }
        TransactionManager.addReceipt((ParameterMap)this.getModuleSetup(), contractRuntime.getContractTitle(), dataMap, sum);
        ArrayList<String> signList = new ArrayList<String>();
        signList.add((String)dataMap.get(PARAM_MRCH_LOGIN));
        signList.add((String)dataMap.get(PARAM_OUT_SUM));
        signList.add((String)dataMap.get(PARAM_INV_ID));
        signList.add((String)dataMap.get("Receipt"));
        signList.add(moduleSetup.get("robokassa.merchant.password.1", ""));
        String signData = signList.stream().filter(a -> a != null).collect(Collectors.joining(":"));
        try {
            dataMap.put(PARAM_SIGNATURE_VALUE, Utils.getDigest((String)signData, (String)"UTF-8"));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("MerchantLogin: " + dataMap.get(PARAM_MRCH_LOGIN));
            logger.debug("OutSum: " + dataMap.get(PARAM_OUT_SUM));
            logger.debug("Description: " + dataMap.get(PARAM_DESC));
            logger.debug("InvoiceID: " + dataMap.get(PARAM_INV_ID));
            logger.debug("Receipt: " + dataMap.get("Receipt"));
            logger.debug("SignatureValue: " + dataMap.get(PARAM_SIGNATURE_VALUE));
        }
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
    }
}

