/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class Report_Problem
extends BGJasperReport {
    private PreparedStatement psExecutors;

    public Report_Problem() {
        this.id = "ru.bitel.bgbilling.plugins.crm_register_problem";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try (UserManager userManager = new UserManager(this.con);){
            Map usersMap = userManager.getUsersMap();
            Period period = this.getPeriod();
            String groups = this.getStringParam("group");
            String category = this.getStringParam("category");
            String executors = this.getStringParam("executor");
            if (period.getDateFrom() != null && period.getDateTo() != null) {
                StringBuffer query = new StringBuffer();
                query.append("SELECT register_problem.id,");
                query.append("register_problem.open_uid,");
                query.append("register_problem.open_dt,");
                query.append("register_problem.close_uid,");
                query.append("register_problem.close_dt,");
                query.append("register_category.title,");
                query.append("register_problem.comment, ");
                query.append("GROUP_CONCAT(contract.title SEPARATOR ', ') AS contracts ");
                query.append("FROM register_problem ");
                query.append("LEFT JOIN register_call ON register_call.rpid=register_problem.id ");
                query.append("LEFT JOIN contract ON register_call.cid=contract.id ");
                query.append("LEFT OUTER JOIN register_category ON register_problem.cat=register_category.id ");
                if (Utils.notEmptyString((String)groups)) {
                    query.append("INNER JOIN register_problem_group ON register_problem.id=register_problem_group.riid  AND register_problem_group.gid IN ( ");
                    query.append(groups);
                    query.append(" ) ");
                }
                if (Utils.notEmptyString((String)executors)) {
                    query.append("INNER JOIN register_problem_executor ON register_problem.id=register_problem_executor.rid  AND register_problem_executor.eid IN ( ");
                    query.append(executors);
                    query.append(" ) ");
                }
                query.append("WHERE TO_DAYS(register_problem.open_dt)>=TO_DAYS('");
                query.append(TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd"));
                query.append("') AND TO_DAYS(register_problem.open_dt)<=TO_DAYS('");
                query.append(TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd"));
                query.append("') ");
                if (Utils.notEmptyString((String)category)) {
                    query.append("AND register_problem.cat IN ( ");
                    query.append(category);
                    query.append(" ) ");
                }
                query.append("GROUP BY register_problem.id ORDER BY register_problem.open_dt");
                BGDataSource data = new BGDataSource();
                float weightSum = 0.0f;
                StringBuffer executorsSb = new StringBuffer(100);
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query.toString());
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("col1", rs.getString("contracts"));
                    int problemID = rs.getInt(1);
                    row.put("col2", String.valueOf(problemID));
                    List<String> executorsList = this.getExecutors(this.con, problemID);
                    float weight = executorsList.size() > 0 ? 1.0f / (float)executorsList.size() : 0.0f;
                    weightSum += weight;
                    row.put("col4", Utils.formatCost((float)weight));
                    row.put("col5", this.formatUser(usersMap, rs.getInt(2), TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(3))));
                    row.put("col6", this.formatUser(usersMap, rs.getInt(4), TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(5))));
                    row.put("col7", rs.getString(6));
                    executorsSb.setLength(0);
                    for (String executor : executorsList) {
                        if (executorsSb.length() > 0) {
                            executorsSb.append(", ");
                        }
                        executorsSb.append(executor);
                    }
                    row.put("col8", executorsSb.toString());
                    row.put("col9", rs.getString(7));
                    data.addRow(row);
                }
                rs.close();
                st.close();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("sum1", String.valueOf(data.rows()));
                params.put("sum2", Utils.formatCost((float)weightSum));
                this.fillReportToStream(this.id, out, params, (JRDataSource)data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String formatUser(Map<Integer, User> users, int uid, Calendar date) {
        StringBuffer result = new StringBuffer(100);
        result.append(TimeUtils.format((Calendar)date, (String)"dd.MM.yy HH:mm"));
        User user = users.get(uid);
        if (user != null) {
            result.append(" (");
            result.append(user.getName());
            result.append(")");
        }
        return result.toString();
    }

    private List<String> getExecutors(Connection con, int problemID) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.psExecutors == null) {
            String query = "SELECT re.title FROM register_problem_executor AS rpe LEFT JOIN register_executor AS re ON rpe.eid=re.id WHERE rpe.rid=?";
            this.psExecutors = con.prepareStatement(query);
        }
        this.psExecutors.setInt(1, problemID);
        ResultSet rs = this.psExecutors.executeQuery();
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        rs.close();
        return result;
    }
}

