/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.service;

import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.modules.phone.common.bean.Gate;
import ru.bitel.bgbilling.modules.phone.common.bean.GateType;
import ru.bitel.bgbilling.modules.phone.common.service.GatesService;
import ru.bitel.bgbilling.modules.phone.server.bean.GateManager;
import ru.bitel.bgbilling.modules.phone.server.bean.GateTypeManager;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.phone.common.service.GatesService")
public class GatesServiceImpl
extends AbstractService
implements GatesService {
    public List<Gate> listGates() throws BGException {
        return new GateManager(this.getConnection(), this.moduleId).list();
    }

    public void updateGate(Gate gate) throws BGException {
        new GateManager(this.getConnection(), this.moduleId).update(gate);
    }

    public void deleteGate(int gateId) throws BGException {
        if (new GateManager(this.getConnection(), this.moduleId).isGateUsed(gateId)) {
            throw new BGMessageException("\u042d\u0442\u043e\u0442 \u0448\u043b\u044e\u0437 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445, \u0432\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c");
        }
        new GateManager(this.getConnection(), this.moduleId).delete(gateId);
    }

    public List<GateType> listTypes() throws BGException {
        return new GateTypeManager(this.getConnection(), this.moduleId).list();
    }

    public GateType getType(int id) throws BGException {
        return new GateTypeManager(this.getConnection(), this.moduleId).getTypeById(id);
    }

    public int updateType(GateType type, boolean checkScript) throws BGException {
        if (checkScript) {
            Script s = new Script();
            s.setScript(type.getScript());
            try {
                ScriptInstance.validateScript((Script)s);
            }
            catch (ScriptInstance.ValidationException e) {
                throw new BGException(e.getMessage());
            }
        }
        new GateTypeManager(this.getConnection(), this.moduleId).update(type);
        return type.getId();
    }

    public void deleteType(int id) throws BGException {
        if (new GateManager(this.getConnection(), this.moduleId).isGateTypeUsed(id)) {
            throw new BGMessageException("\u0415\u0441\u0442\u044c \u0448\u043b\u044e\u0437\u044b \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430, \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u043d\u0430\u0447\u0430\u043b\u0435 \u0438\u0445 ");
        }
        new GateTypeManager(this.getConnection(), this.moduleId).delete(id);
    }

    public List<Gate> getContractGates(int cid) throws BGException {
        return new GateManager(this.getConnection(), this.moduleId).getContractGates(cid);
    }

    public void addContractGate(int cid, int gid) throws BGException {
        new GateManager(this.getConnection(), this.moduleId).addContractGate(cid, gid);
    }

    public void deleteContractGate(int cid, int gid) throws BGException {
        new GateManager(this.getConnection(), this.moduleId).deleteContractGate(cid, gid);
    }
}

