/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.oper.komstar;

import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.Operator;
import ru.bitel.bgbilling.modules.phone.server.oper.komstar.KomstarDbfForm;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class KomstarDbf42
implements KomstarDbfForm {
    protected List<Dbf42Record> record42List = new ArrayList<Dbf42Record>();

    @Override
    public void prepare(Connection con, Operator oper, Calendar month) throws SQLException {
        int billMid = oper.getOperatorSetup().getInt("bill.module.id", -1);
        String form41InvoiceTypes = oper.getOperatorSetup().get("form.42.bill.types", null);
        int innPid = oper.getOperatorSetup().getInt("form.42.inn.pid", 1);
        int addressPid = oper.getOperatorSetup().getInt("form.42.address.pid", 19);
        int titlePid = oper.getOperatorSetup().getInt("form.42.fio.pid", 1);
        String operCode = oper.getOperatorSetup().get("oper.code", "OPER");
        int yy = month.get(1);
        int mm = month.get(2);
        StringBuilder query = new StringBuilder(100);
        query.append("SELECT contract.title, contract.comment, bill.format_number, bill.create_dt, titleParam.val, ");
        query.append("bill.summ, bill.type, innParam.val, addressParam.address");
        query.append(" FROM bill_data_");
        query.append(billMid);
        query.append(" as bill LEFT JOIN contract ON contract.id=bill.cid ");
        query.append(" LEFT JOIN contract_parameter_type_1 as titleParam ON IF(contract.scid>0,contract.scid,contract.id)=titleParam.cid AND titleParam.pid=");
        query.append(titlePid);
        query.append(" LEFT JOIN contract_parameter_type_1 as innParam ON IF(contract.scid>0,contract.scid,contract.id)=innParam.cid AND innParam.pid=");
        query.append(innPid);
        query.append(" LEFT JOIN contract_parameter_type_2 as addressParam ON addressParam.cid=IF(contract.scid>0,contract.scid,contract.id) AND addressParam.pid=");
        query.append(addressPid);
        query.append(" WHERE 1 = 1 ");
        if (Utils.notBlankString((String)form41InvoiceTypes)) {
            query.append(" AND bill.type IN ( ");
            query.append(form41InvoiceTypes);
            query.append(" ) ");
        }
        query.append(" AND yy = ");
        query.append(yy);
        query.append(" AND mm = ");
        query.append(mm);
        String reportPeriod = String.valueOf(mm) + String.valueOf(yy);
        PreparedStatement ps = con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Dbf42Record record = new Dbf42Record();
            record.reportPeriod = reportPeriod;
            record.operCode = operCode;
            record.subscriberId = rs.getString("contract.title");
            record.billNum = rs.getString("bill.format_number");
            record.customerInn = Utils.parseLong((String)rs.getString("innParam.val"));
            record.customerAddress = rs.getString("addressParam.address");
            BigDecimal total = rs.getBigDecimal("bill.summ");
            BigDecimal noNds = total.divide(new BigDecimal(1.2), 2, RoundingMode.HALF_UP);
            record.total = total.doubleValue();
            record.costNds = total.subtract(noNds).doubleValue();
            record.payMode = 2.0;
            record.customerFio = titlePid == -1 ? rs.getString("contract.comment") : rs.getString("titleParam.val");
            this.record42List.add(record);
            record.summaFull = total;
        }
        rs.close();
        ps.close();
    }

    @Override
    public void writeReport(OutputStream out) throws Exception {
        DBFReader reader = new DBFReader(this.getClass().getResourceAsStream("/ru/bitel/bgbilling/modules/phone/server/oper/komstar/templates/XXXXZZZZZ42UU.DBF"));
        DBFField[] fields = new DBFField[reader.getFieldCount()];
        for (int i = 0; i < reader.getFieldCount(); ++i) {
            fields[i] = reader.getField(i);
            System.out.println(fields[i].getName());
        }
        DBFWriter writer = new DBFWriter();
        writer.setCharactersetName("cp866");
        writer.setFields(fields);
        for (Dbf42Record record : this.record42List) {
            Object[] values = new Object[13];
            values[0] = 42.0;
            values[1] = record.reportPeriod;
            values[2] = record.operCode;
            values[3] = record.subscriberId;
            values[4] = record.customerFio;
            values[5] = record.customerAddress;
            values[6] = record.customerInn;
            values[7] = record.billNum;
            values[8] = record.total;
            values[9] = record.costNds;
            values[10] = record.payMode;
            writer.addRecord(values);
        }
        writer.write(out);
        out.flush();
    }

    @Override
    public String getTitle() {
        return "\u041a\u043e\u043c\u0441\u0442\u0430\u0440 DBF \u0444\u043e\u0440\u043c\u0430 42";
    }

    @Override
    public String getFileName(Operator oper, Date month) {
        String operator = oper.getOperatorSetup().get("oper.code", "OPER");
        return operator + TimeUtils.format((Date)month, (String)"yyyyMM") + "4201.DBF";
    }

    static class Dbf42Record {
        static final double FORM_NUM = 42.0;
        String reportPeriod;
        String operCode;
        String subscriberId;
        String customerFio;
        String customerAddress;
        double customerInn;
        String billNum;
        double total;
        double costNds;
        double payMode;
        BigDecimal summaFull;

        Dbf42Record() {
        }
    }
}

