/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.RangeParser;
import ru.bitel.bgbilling.kernel.base.phone.server.RangeMapCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.modules.phone.server.LogRecord;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.common.Utils;

public class CalculateClientItem {
    private static Logger log = LogManager.getLogger((String)"dataloader");
    public int serviceId;
    public List<String> keys = new ArrayList<String>(2);
    public Calendar date1;
    public Calendar date2;
    public boolean tariffInit = false;
    public int itemId;
    public ContractInfo contract;
    public Set<ContractInfo> subContracts;
    public List<TariffModuleTree> tariffTreeListNew;
    public Map<Integer, List<TariffModuleTree>> subContractTariffTreeMapNew;
    private Set<String> fromPorts;
    private Set<String> toPorts;
    private Pattern fromPortsPattern;
    private Pattern toPortsPattern;
    private Pattern fromNumberPattern;
    private Pattern toNumberPattern;
    private Pattern notFromNumberPattern;
    private Pattern notToNumberPattern;
    private RangeParser rangeFromParser;
    private RangeParser rangeNotFromParser;
    private RangeParser rangeToParser;
    private RangeParser rangeNotToParser;
    private Set<Integer> fromRangeMapIds;
    private Set<Integer> toRangeMapIds;
    private Set<Integer> notFromRangeMapIds;
    private Set<Integer> notToRangeMapIds;

    public Pattern getNotFromNumberPattern() {
        return this.notFromNumberPattern;
    }

    public void setNotFromNumberPattern(Pattern notFromNumberPattern) {
        this.notFromNumberPattern = notFromNumberPattern;
    }

    public Pattern getNotToNumberPattern() {
        return this.notToNumberPattern;
    }

    public void setNotToNumberPattern(Pattern notToNumberPattern) {
        this.notToNumberPattern = notToNumberPattern;
    }

    public CalculateClientItem(ClientItem item, ContractInfo contract, Set<ContractInfo> subContracts) {
        this.itemId = item.getId();
        this.contract = contract;
        this.subContracts = subContracts;
        if (item.getType() == 2) {
            this.serviceId = item.getOperServiceId();
            if (item.getOperFromPorts().size() != 0) {
                this.fromPorts = new HashSet<String>(item.getOperFromPorts());
            }
            if (item.getOperToPorts().size() != 0) {
                this.toPorts = new HashSet<String>(item.getOperToPorts());
            }
            if (Utils.notBlankString((String)item.getOperFromPrefs())) {
                this.fromNumberPattern = Pattern.compile(item.getOperFromPrefs());
            }
            if (Utils.notBlankString((String)item.getOperToPrefs())) {
                this.toNumberPattern = Pattern.compile(item.getOperToPrefs());
            }
            if (Utils.notBlankString((String)item.getOperNotFromPrefs())) {
                this.notFromNumberPattern = Pattern.compile(item.getOperNotFromPrefs());
            }
            if (Utils.notBlankString((String)item.getOperNotToPrefs())) {
                this.notToNumberPattern = Pattern.compile(item.getOperNotToPrefs());
            }
            if (Utils.notBlankString((String)item.getOperFromPortsRegexp())) {
                this.fromPortsPattern = Pattern.compile(item.getOperFromPortsRegexp());
            }
            if (Utils.notBlankString((String)item.getOperToPortsRegexp())) {
                this.toPortsPattern = Pattern.compile(item.getOperToPortsRegexp());
            }
            if (Utils.notBlankString((String)item.getOperFromRangeMapIds())) {
                this.fromRangeMapIds = Utils.toIntegerSet((String)item.getOperFromRangeMapIds());
            }
            if (Utils.notBlankString((String)item.getOperToRangeMapIds())) {
                this.toRangeMapIds = Utils.toIntegerSet((String)item.getOperToRangeMapIds());
            }
            if (Utils.notBlankString((String)item.getOperNotFromRangeMapIds())) {
                this.notFromRangeMapIds = Utils.toIntegerSet((String)item.getOperNotFromRangeMapIds());
            }
            if (Utils.notBlankString((String)item.getOperNotToRangeMapIds())) {
                this.notToRangeMapIds = Utils.toIntegerSet((String)item.getOperNotToRangeMapIds());
            }
            if (Utils.notBlankString((String)item.getOperFromRange())) {
                try {
                    this.rangeFromParser = new RangeParser(item.getOperFromRange());
                }
                catch (BGException e) {
                    log.error(e.toString());
                }
            }
            if (Utils.notBlankString((String)item.getOperNotFromRange())) {
                try {
                    this.rangeNotFromParser = new RangeParser(item.getOperNotFromRange());
                }
                catch (BGException e) {
                    log.error(e.toString());
                }
            }
            if (Utils.notBlankString((String)item.getOperToRange())) {
                try {
                    this.rangeToParser = new RangeParser(item.getOperToRange());
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
            if (Utils.notBlankString((String)item.getOperNotToRange())) {
                try {
                    this.rangeNotToParser = new RangeParser(item.getOperNotToRange());
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
        }
    }

    public boolean check(LogRecord record, RangeMapCache rangeMapCache) {
        boolean result;
        if (this.fromPorts != null && this.fromPorts.size() != 0 && !this.fromPorts.contains(record.fromPort)) {
            return false;
        }
        if (this.toPorts != null && this.toPorts.size() != 0 && !this.toPorts.contains(record.toPort)) {
            return false;
        }
        if (this.fromPortsPattern != null && !this.fromPortsPattern.matcher(record.fromPort).find()) {
            return false;
        }
        if (this.toPortsPattern != null && !this.toPortsPattern.matcher(record.toPort).find()) {
            return false;
        }
        if (this.fromNumberPattern != null && !this.fromNumberPattern.matcher(record.fromNumber164).find()) {
            return false;
        }
        if (this.notFromNumberPattern != null && this.notFromNumberPattern.matcher(record.fromNumber164).find()) {
            return false;
        }
        if (this.toNumberPattern != null && !this.toNumberPattern.matcher(record.toNumber164).find()) {
            return false;
        }
        if (this.notToNumberPattern != null && this.notToNumberPattern.matcher(record.toNumber164).find()) {
            return false;
        }
        if (this.rangeToParser != null && !this.rangeToParser.checkPrefix(record.toNumber164)) {
            return false;
        }
        if (this.rangeNotToParser != null && this.rangeNotToParser.checkPrefix(record.toNumber164)) {
            return false;
        }
        if (this.rangeFromParser != null && !this.rangeFromParser.checkPrefix(record.fromNumber164)) {
            return false;
        }
        if (this.rangeNotFromParser != null && this.rangeNotFromParser.checkPrefix(record.fromNumber164)) {
            return false;
        }
        if (this.fromRangeMapIds != null) {
            result = false;
            for (Integer rangeMapId : this.fromRangeMapIds) {
                if (!rangeMapCache.contains(rangeMapId, record.fromNumber164)) continue;
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
        }
        if (this.toRangeMapIds != null) {
            result = false;
            for (Integer rangeMapId : this.toRangeMapIds) {
                if (!rangeMapCache.contains(rangeMapId, record.toNumber164)) continue;
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
        }
        if (this.notFromRangeMapIds != null) {
            for (Integer rangeMapId : this.notFromRangeMapIds) {
                if (!rangeMapCache.contains(rangeMapId, record.fromNumber164)) continue;
                return false;
            }
        }
        if (this.notToRangeMapIds != null) {
            for (Integer rangeMapId : this.notToRangeMapIds) {
                if (!rangeMapCache.contains(rangeMapId, record.toNumber164)) continue;
                return false;
            }
        }
        return true;
    }

    public Pattern getFromPortsPattern() {
        return this.fromPortsPattern;
    }

    public void setFromPortsPattern(Pattern fromPortsPattern) {
        this.fromPortsPattern = fromPortsPattern;
    }

    public Pattern getToPortsPattern() {
        return this.toPortsPattern;
    }

    public void setToPortsPattern(Pattern toPortsPattern) {
        this.toPortsPattern = toPortsPattern;
    }

    public static class ContractInfo {
        public int id;
        public String title;

        public ContractInfo(int cid, String title) {
            this.id = cid;
            this.title = title;
        }
    }
}

