/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import bitel.billing.server.ActionConType;
import java.sql.SQLException;
import java.util.Calendar;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.phone.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.phone.server.bean.DataLog;
import ru.bitel.bgbilling.modules.phone.server.bean.ReportManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionDataLog
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", 0);
        Calendar month = TimeUtils.convertStringToCalendar((String)this.getParameter("hour"), (String)"dd.MM.yyyy HH:mm:ss");
        if (this.mid <= 0 || id <= 0 || month == null) {
            throw new BGIllegalArgumentException();
        }
        DataLog dataLog = new ReportManager(this.con, this.mid).getDataLog(id, month);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        if (dataLog != null) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(dataLog.getId()));
            row.setAttribute("source", dataLog.getSource());
            row.setAttribute("session_start", TimeUtils.format((Calendar)dataLog.getSessionStart(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("session_time", Utils.formatSessionTime((int)dataLog.getSessionTime()));
            row.setAttribute("fromNumber", dataLog.getFromNumber());
            row.setAttribute("fromNumber164", dataLog.getFromNumber164());
            row.setAttribute("toNumber", dataLog.getToNumber());
            row.setAttribute("toNumber164", dataLog.getToNumber164());
            row.setAttribute("fromPort", dataLog.getFromPort());
            row.setAttribute("toPort", dataLog.getToPort());
            row.setAttribute("cat", String.valueOf(dataLog.getCategory()));
        }
    }
}

