/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payture.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.payture.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payture.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.payture.server.bean.Constants;
import ru.bitel.bgbilling.modules.payture.server.bean.TransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Payture")
public class ActionDoTransaction
extends AbstractAction {
    private static final Logger logger = LogManager.getLogger();
    private final String moduleName = "payture";

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm("payture", Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(this.getPeriod(), this.getPage());
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws BGException {
        String sessionId;
        StringBuilder dataString;
        Object serverUrl;
        block18: {
            if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
                throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
            }
            BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal sumMin = this.moduleSetup.getBigDecimal("payture.sum.min", new BigDecimal(100));
            BigDecimal sumMax = this.moduleSetup.getBigDecimal("payture.sum.max", new BigDecimal(5000));
            if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                this.execute();
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
            }
            this.setResultParam("mode", 1);
            Transaction transaction = new Transaction();
            transaction.setContractId(this.contractId);
            transaction.setTransactionDate(new Date());
            transaction.setStatus(TransactionStatus.NEW.getCode());
            transaction.setSum(sum);
            TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
            transactionManager.update(transaction);
            transactionManager.close();
            serverUrl = this.moduleSetup.get("payture.url.gate", "https://sandbox.payture.com/");
            Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
            serverUrl = ((String)serverUrl).lastIndexOf("/") == ((String)serverUrl).length() - 1 ? serverUrl : (String)serverUrl + "/";
            dataString = new StringBuilder();
            dataString.append("SessionType=Pay;");
            dataString.append("OrderId=" + transaction.getId() + ";");
            dataString.append("Amount=" + transaction.getSum().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_UP) + ";");
            dataString.append("IP=" + this.context.getRequest().getLocalAddr() + ";");
            dataString.append("Url=" + this.moduleSetup.get("payture.url.return.ok") + ";");
            dataString.append("Product=" + this.moduleSetup.get("payture.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()) + ";");
            dataString.append("Total=" + Utils.formatBigDecimalSumm((BigDecimal)transaction.getSum()));
            String key = this.moduleSetup.get("payture.key");
            if (logger.isDebugEnabled()) {
                String debugMessage = "\u0421\u0442\u0440\u043e\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0435\u0440\u0432\u0438\u0441\u0443 Payture.com: " + (String)serverUrl + "apim/Init?Key=" + key + "&Data=" + dataString.toString();
                logger.debug(debugMessage);
            }
            sessionId = null;
            try {
                String spec = (String)serverUrl + "apim/Init?Key=" + key + "&Data=" + URLEncoder.encode(dataString.toString(), "UTF-8");
                URL url = new URL(spec);
                URLConnection connection = url.openConnection();
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.connect();
                StringBuilder resultXml = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    if (br.ready()) {
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            resultXml.append(line);
                        }
                    }
                }
                logger.debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 Payture.com: " + resultXml);
                Document xmlDocument = XMLUtils.parseDocument((String)resultXml.toString());
                Element initElement = XMLUtils.getElement((Document)xmlDocument, (String)"Init");
                if (initElement == null) break block18;
                String success = XMLUtils.getAttribute((Element)initElement, (String)"Success");
                if (success.equalsIgnoreCase("true")) {
                    sessionId = XMLUtils.getAttribute((Element)initElement, (String)"SessionId");
                    break block18;
                }
                String errCode = XMLUtils.getAttribute((Element)initElement, (String)"ErrCode");
                logger.error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + errCode);
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436!");
            }
            catch (IOException e) {
                throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0438\u0441\u0443 Payture. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438: " + e.getMessage(), (Throwable)e);
            }
        }
        if (Utils.notBlankString(sessionId)) {
            dataString = new StringBuilder((String)serverUrl + "apim/Pay?");
            dataString.append("SessionId=" + sessionId);
            logger.debug("URL \u0434\u043b\u044f iFrame: " + dataString.toString());
            try {
                this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(dataString.toString());
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        } else {
            this.execute();
        }
    }
}

