/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client;

import bitel.billing.module.common.IntTextField;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class EntityServicePropertiesPanel
extends ServicePanel {
    private int npayModuleId = -1;
    private int serviceObjectId;
    private Map<String, Object> currentRow;
    private List<Map<String, Object>> currentData;
    private BGUTable table = null;
    private BGControlPanelPeriodNoB servicePeriod = new BGControlPanelPeriodNoB();
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private HashSet<Integer> deleted = new HashSet();
    private EntityPayServiceTableModel tableModel = new EntityPayServiceTableModel();
    private ModuleService moduleService = null;

    public EntityServicePropertiesPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.toolBar.setDefaultButtons(e -> this.actionPerformed(e));
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EntityServicePropertiesPanel.this.editItem();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
    }

    public void setData() {
        Integer npayMid = (Integer)this.params.get("npayMid");
        if (npayMid != null && npayMid > 0) {
            this.npayModuleId = npayMid;
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ServiceObjectTable");
            request.setModuleId(this.npayModuleId);
            request.setContractId(this.getContractId());
            request.setAttribute("entityMid", this.getModuleId());
            request.setAttribute("entityId", this.id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.currentData = new ArrayList<Map<String, Object>>();
                for (Element rowElement : XMLUtils.selectElements((Node)doc, (String)"//table/data/row")) {
                    HashMap<String, Object> rowMap = new HashMap<String, Object>();
                    rowMap.put("uid", String.valueOf(System.currentTimeMillis()));
                    rowMap.put("id", Utils.parseInt((String)rowElement.getAttribute("id")));
                    rowMap.put("sid", Utils.parseInt((String)rowElement.getAttribute("sid")));
                    rowMap.put("col", Utils.parseInt((String)rowElement.getAttribute("col")));
                    rowMap.put("service", rowElement.getAttribute("service"));
                    rowMap.put("period", rowElement.getAttribute("period"));
                    rowMap.put("date1", rowElement.getAttribute("date1"));
                    rowMap.put("date2", rowElement.getAttribute("date2"));
                    this.currentData.add(rowMap);
                }
                this.tableModel.setData(this.currentData);
            }
        }
    }

    public void deleteItem() {
        Map rowData = (Map)this.tableModel.getSelectedRow();
        if (rowData == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            this.serviceObjectId = (Integer)rowData.get("id");
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.currentData.remove(rowData);
                if (this.serviceObjectId > 0) {
                    this.deleted.add(this.serviceObjectId);
                }
                this.tableModel.setData(this.currentData);
            }
        }
    }

    public void editItem() {
        Map rowData = (Map)this.tableModel.getSelectedRow();
        if (rowData == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            this.serviceObjectId = (Integer)rowData.get("id");
            this.startEdit(rowData);
        }
    }

    public void newItem() {
        this.serviceObjectId = -1;
        this.startEdit(new HashMap<String, Object>());
    }

    private void startEdit(Map<String, Object> rowData) {
        try {
            if (this.npayModuleId < 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041c\u043e\u0434\u0443\u043b\u044c NPAY \u043d\u0435 \u0441\u043e\u043e\u0442\u043d\u0435\u0441\u0435\u043d \u0441 \u043c\u043e\u0434\u0443\u043b\u0435\u043c VOICE!");
                return;
            }
            if (!((ContractService)this.getContext().getPort(ContractService.class)).hasModuleInstance(this.getContractId(), this.npayModuleId)) {
                ClientUtils.showErrorMessageDialog((String)("\u041a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u043c\u043e\u0434\u0443\u043b\u044f NPAY \u0441 \u043a\u043e\u0434\u043e\u043c " + this.npayModuleId + ". \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0435\u0433\u043e \u0432 \u0441\u043f\u0438\u0441\u043e\u043a \u043c\u043e\u0434\u0443\u043b\u0435\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!"));
                return;
            }
            this.currentRow = rowData;
            if (this.serviceObjectId == -1) {
                this.currentRow.put("id", -1);
                this.currentRow.put("sid", -1);
                this.currentRow.put("col", "1");
                this.currentRow.put("date1", TimeUtils.format((LocalDate)LocalDate.now(), (String)"dd.MM.yyyy"));
                this.currentRow.put("date2", "");
                new ServiceEditorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", this.currentRow).getDialog().setVisible(true);
            } else {
                new ServiceEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", this.currentRow).getDialog().setVisible(true);
            }
        }
        catch (BGException e) {
            this.getContext().processException((Throwable)e);
        }
    }

    public boolean updateData() {
        if (this.npayModuleId <= 0 || this.currentData == null) {
            return true;
        }
        String objectId = (String)this.params.get("objectId");
        if (Utils.isEmptyString((String)objectId)) {
            objectId = "0";
        }
        for (Integer n : this.deleted) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ServiceObjectDelete");
            request.setModuleId(this.npayModuleId);
            request.setContractId(this.getContractId());
            request.setAttribute("id", (Object)n);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) continue;
            return false;
        }
        this.deleted.clear();
        for (Map map : this.currentData) {
            Date accountDateTo = null;
            try {
                accountDateTo = (Date)this.getAttrs().get("accountDateTo");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String date2 = (String)map.get("date2");
            Date serviceObject_getDate2 = TimeUtils.parseDate((String)date2, (String)"dd.MM.yyyy");
            if (accountDateTo != null && (serviceObject_getDate2 == null || serviceObject_getDate2.after(accountDateTo))) {
                date2 = TimeUtils.format((Date)accountDateTo, (String)"dd.MM.yyyy");
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ServiceObjectUpdate");
            request.setModuleId(this.npayModuleId);
            request.setContractId(this.getContractId());
            request.setAttribute("entityMid", this.getModuleId());
            request.setAttribute("entityId", this.id);
            request.setAttribute("id", map.get("id"));
            request.setAttribute("sid", map.get("sid"));
            request.setAttribute("oid", objectId);
            request.setAttribute("col", map.get("col"));
            request.setAttribute("date1", map.get("date1"));
            request.setAttribute("date2", date2);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) continue;
            return false;
        }
        return true;
    }

    private ModuleService getModuleService() {
        if (this.moduleService == null) {
            this.moduleService = (ModuleService)this.getContext().getPort(ModuleService.class, 0);
        }
        return this.moduleService;
    }

    class EntityPayServiceTableModel
    extends BGTableModel<Map<String, Object>> {
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SID = "sid";
        public static final String COLUMN_COL = "col";
        public static final String COLUMN_DATE1 = "date1";
        public static final String COLUMN_DATE2 = "date2";
        public static final String COLUMN_PERIOD = "period";
        public static final String COLUMN_SERVICE = "service";

        public EntityPayServiceTableModel() {
            super("phoneEntityPayService");
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, COLUMN_PERIOD, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", -1, -1, -1, COLUMN_SERVICE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 80, 80, 80, COLUMN_COL, true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
        }
    }

    class ServiceEditorDialog
    extends BGEditorDialog<Map<String, Object>> {
        private IntTextField colTf;
        private BGUList<IdTitle> serviceList;

        public ServiceEditorDialog(String title, Map<String, Object> data) {
            super(title, data);
            this.colTf = new IntTextField();
            this.serviceList = new BGUList();
        }

        public void doDialogPanel() {
            ArrayList services = new ArrayList();
            try {
                EntityServicePropertiesPanel.this.getModuleService().moduleServiceList(EntityServicePropertiesPanel.this.npayModuleId).forEach(a -> services.add(new IdTitle(a.getId(), a.getTitle())));
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.serviceList.setData(services);
            this.serviceList.setEnabled(EntityServicePropertiesPanel.this.serviceObjectId == -1);
            this.serviceList.setSelectionMode(0);
            this.serviceList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.colTf.setMinValue(1L);
            this.colTf.setMaxValue(1000L);
            JScrollPane scrollserviceList = new JScrollPane((Component)this.serviceList);
            scrollserviceList.setMinimumSize(new Dimension((int)scrollserviceList.getMinimumSize().getWidth(), 200));
            scrollserviceList.setPreferredSize(new Dimension((int)scrollserviceList.getPreferredSize().getWidth(), 200));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)EntityServicePropertiesPanel.this.servicePeriod, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.colTf, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)scrollserviceList, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.panel.validate();
            this.serviceList.setSelectedId(((Integer)((Map)this.data).get("sid")).intValue(), true);
            this.colTf.setText(((Map)this.data).get("col").toString());
            EntityServicePropertiesPanel.this.servicePeriod.setDateString1(((Map)this.data).get("date1").toString());
            EntityServicePropertiesPanel.this.servicePeriod.setDateString2(((Map)this.data).get("date2").toString());
        }

        public boolean doApply() throws Exception {
            IdTitle item = (IdTitle)this.serviceList.getSelectedValue();
            if (item == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443!");
                return false;
            }
            String col = this.colTf.getText();
            String serviceTitle = item.toString();
            if (Utils.isBlankString((String)col)) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
                return false;
            }
            EntityServicePropertiesPanel.this.currentRow.put("id", EntityServicePropertiesPanel.this.serviceObjectId);
            EntityServicePropertiesPanel.this.currentRow.put("sid", item.getId());
            EntityServicePropertiesPanel.this.currentRow.put("col", Utils.parseInt((String)col));
            EntityServicePropertiesPanel.this.currentRow.put("date1", EntityServicePropertiesPanel.this.servicePeriod.getDateString1());
            EntityServicePropertiesPanel.this.currentRow.put("date2", EntityServicePropertiesPanel.this.servicePeriod.getDateString2());
            EntityServicePropertiesPanel.this.currentRow.put("period", EntityServicePropertiesPanel.this.servicePeriod.getDateString1() + "-" + EntityServicePropertiesPanel.this.servicePeriod.getDateString2());
            EntityServicePropertiesPanel.this.currentRow.put("service", serviceTitle);
            if (EntityServicePropertiesPanel.this.currentRow.get("uid") == null) {
                EntityServicePropertiesPanel.this.currentRow.put("uid", String.valueOf(System.currentTimeMillis()));
                EntityServicePropertiesPanel.this.currentData.add(EntityServicePropertiesPanel.this.currentRow);
            }
            EntityServicePropertiesPanel.this.tableModel.setData(EntityServicePropertiesPanel.this.currentData);
            return true;
        }
    }
}

