/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.npay.server.event.DebetStatusManageOpenGetAdditionalCharge;
import ru.bitel.bgbilling.modules.npay.server.task.Calculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DebetStatusManageConfig {
    private static final Logger log = LogManager.getLogger();
    private boolean enable = false;
    private Set<Integer> contractLabelIds;
    private int serviceSet = 0;
    private String activeStatusString;
    private String lockedStatusString;
    private List<Integer> activeStatus;
    private List<Integer> lockedStatus;
    private Map<Integer, Integer> statusRuleMap;
    private String tariffIds;
    private boolean processDependentSub;
    private boolean checkServiceObjectList;
    private boolean activeFromMonthStart = false;

    public DebetStatusManageConfig(Preferences moduleSetup) {
        this.enable = moduleSetup.getInt("debet.npay.status.manage", 0) == 1;
        this.serviceSet = moduleSetup.getInt("debet.npay.service.set", 0);
        this.activeStatusString = moduleSetup.get("debet.npay.active.status", "0");
        this.activeStatus = Utils.toIntegerList((String)this.activeStatusString);
        this.lockedStatusString = moduleSetup.get("debet.npay.locked.status", "3");
        this.lockedStatus = Utils.toIntegerList((String)this.lockedStatusString);
        this.statusRuleMap = this.parseStatusRule(moduleSetup.get("debet.npay.status.rule", null));
        this.processDependentSub = moduleSetup.getInt("debet.npay.processDependentSub", 0) > 0;
        this.checkServiceObjectList = moduleSetup.getInt("debet.npay.checkServiceObjectList", 1) > 0;
        this.activeFromMonthStart = moduleSetup.getBoolean("debet.npay.payment.active.full.month", false);
        List ids = Utils.toIntegerList((String)moduleSetup.get("debet.npay.status.manage.tariff.ids", null));
        if (!ids.isEmpty()) {
            this.tariffIds = Utils.toString((Iterable)ids);
        }
        Set groupsIds = Utils.toIntegerSet((String)moduleSetup.get("debet.npay.status.manage.groups", ""));
        String labelIds = "";
        if (!groupsIds.isEmpty()) {
            labelIds = Utils.toString((Iterable)groupsIds.stream().map(a -> a + 2).collect(Collectors.toList()));
        }
        this.contractLabelIds = Utils.toIntegerSet((String)moduleSetup.get("debet.npay.status.manage.label.ids", labelIds));
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isEnableForContractLabelIds(List<Integer> chechContractLabelIds) {
        boolean fl = this.contractLabelIds.isEmpty();
        if (!fl && chechContractLabelIds != null && !chechContractLabelIds.isEmpty()) {
            for (Integer id : chechContractLabelIds) {
                if (!this.contractLabelIds.contains(id)) continue;
                fl = true;
                break;
            }
        }
        return fl;
    }

    public Set<Integer> getContractLabelIds() {
        HashSet<Integer> ids = new HashSet<Integer>();
        this.contractLabelIds.forEach(a -> ids.add((Integer)a));
        return ids;
    }

    public List<Integer> getLockStatusList() {
        return this.lockedStatus;
    }

    public boolean checkLockStatus(int status) {
        return this.lockedStatus.contains(status);
    }

    public String getLockStatusString() {
        return this.lockedStatusString;
    }

    public List<Integer> getActiveStatusList() {
        return this.activeStatus;
    }

    public String getActiveStatusString() {
        return this.activeStatusString;
    }

    public int getServiceSet() {
        return this.serviceSet;
    }

    public String getTariffIds() {
        return this.tariffIds;
    }

    public boolean isProcessDependentSub() {
        return this.processDependentSub;
    }

    public boolean isCheckServiceObjectList() {
        return this.checkServiceObjectList;
    }

    public BigDecimal getSummaForUnlock(Connection con, int moduleId, Contract contract) throws BGException {
        BigDecimal result = null;
        if (contract.getBalanceMode() == 1 && this.checkLockStatus(contract.getStatus())) {
            GregorianCalendar now = new GregorianCalendar();
            ContractManager contractManager = new ContractManager(con);
            ModuleCache cache = ModuleCache.getInstance();
            if (!this.processDependentSub && contract.getSuperId() > 0 && contract.isDependSub()) {
                return this.getSummaForUnlock(con, moduleId, contractManager.getContractById(contract.getSuperId()));
            }
            Object cids = String.valueOf(contract.getId());
            if (!this.processDependentSub && contract.isSuper() && Utils.notBlankString((String)contract.getDependSubList())) {
                cids = (String)cids + "," + contract.getDependSubList();
            }
            Calculator calculator = new Calculator();
            calculator.setExecutingTime(now);
            calculator.setPreCalc();
            calculator.initTask(Setup.getSetup(), 0, "mid=" + moduleId + "\nservice.set=" + this.serviceSet);
            calculator.setCids((String)cids);
            if (this.activeFromMonthStart) {
                Calendar startMonth = TimeUtils.getStartMonth((Calendar)now);
                calculator.setActiveFromDate(startMonth);
                Calendar endMonth = TimeUtils.getEndMonth((Calendar)now);
                calculator.setExecutingTime(endMonth);
            }
            calculator.runLocal();
            BigDecimal planAccount = BigDecimal.ZERO;
            HashMap<Integer, Map<String, String>> configList = new HashMap<Integer, Map<String, String>>();
            Map planAccountMap = calculator.getCostCache().getContractAccounts();
            for (Integer contractId : Utils.toIntegerList((String)cids)) {
                BigDecimal contractPlanAccount = Utils.maskNull((BigDecimal)((BigDecimal)planAccountMap.get(contractId)));
                planAccount = planAccount.add(contractPlanAccount);
                if (log.isDebugEnabled()) {
                    log.debug("Plan account cid: " + contractId + "; planAccount: " + contractPlanAccount);
                }
                configList.put(contractId, calculator.getConfigCache().getConfigs(contractId));
            }
            BalanceUtils bu = new BalanceUtils(con);
            BigDecimal currentAccount = bu.getAccountSumma(contract.getId(), (Calendar)now, cache.getModuleServicesString(moduleId));
            if (log.isDebugEnabled()) {
                log.debug("currentAccount: " + currentAccount + "; planAccount: " + planAccount);
            }
            BigDecimal accountDiff = planAccount.subtract(currentAccount);
            BigDecimal currentBalance = bu.getBalanceOut(now.getTime(), contract.getId());
            BigDecimal currentLimit = contract.getBalanceLimit();
            result = currentBalance.subtract(currentLimit).subtract(accountDiff).negate();
            if (log.isDebugEnabled()) {
                log.debug("accountDif: " + accountDiff + "; currentBalance: " + currentBalance + "; currentLimit: " + currentLimit + "; result: " + result);
            }
            DebetStatusManageOpenGetAdditionalCharge event = new DebetStatusManageOpenGetAdditionalCharge(moduleId, contract.getId());
            event.setCurrentAccount(currentAccount);
            event.setPlanAccount(planAccount);
            event.setCurrentBalance(currentBalance);
            event.setLimit(currentLimit);
            event.setConfigList(configList);
            event.setResult(result);
            event = (DebetStatusManageOpenGetAdditionalCharge)EventProcessor.getInstance().request((QueueEvent)event);
            if (event.getSumma() != null) {
                result = event.getMode() == 1 ? result.add(event.getSumma()) : event.getSumma();
            }
            if (result.compareTo(BigDecimal.ZERO) < 0) {
                result = BigDecimal.ZERO;
            }
            bu.close();
            contractManager.close();
        }
        return result;
    }

    public int getNextStatus(int status) {
        Integer result = this.statusRuleMap.get(status);
        if (result == null) {
            result = this.lockedStatus.contains(status) ? this.activeStatus.get(0) : this.lockedStatus.get(0);
        }
        return result;
    }

    private Map<Integer, Integer> parseStatusRule(String statusRule) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (statusRule != null) {
            String[] pairList;
            for (String pair : pairList = statusRule.split(",")) {
                String[] str = pair.split(":");
                if (str.length <= 1) continue;
                result.put(Utils.parseInteger((String)str[0], null), Utils.parseInteger((String)str[1], null));
            }
        }
        return result;
    }
}

