/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.moneta.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.moneta.common.bean.Transaction;
import ru.bitel.bgbilling.modules.moneta.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractIdDao<Transaction> {
    private static final Logger logger = LogManager.getLogger();

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "moneta_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.create_date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.create_date<?");
                }
            }
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                query.append(" AND pt.status=?");
            }
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND c.id=").append(contractId);
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = null;
                ps = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title" + query.toString() + this.getSQLOrder(sort, this.fields) + (page != null ? page.sqlLimit() : ""));
                int index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs, true));
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement("SELECT SUM(pt.sum), COUNT(*) " + query.toString());
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal sum;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((sum = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(sum);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, false);
    }

    protected Transaction getFromRS(ResultSet rs, boolean initContractTitle) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("contract_id"));
        if (initContractTitle) {
            transaction.setContractTitle(rs.getString("contract_title"));
        }
        transaction.setPaymentId(rs.getInt("payment_id"));
        transaction.setCreateDate((Date)rs.getTimestamp("create_date"));
        transaction.setTransactionDate((Date)rs.getTimestamp("transaction_date"));
        transaction.setTransactionId(rs.getString("transaction_id"));
        transaction.setStatus(rs.getString("status"));
        transaction.setParameters(rs.getString("params"));
        transaction.setSum(rs.getBigDecimal("sum"));
        return transaction;
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            int id = transaction.getId();
            boolean update = id > 0;
            String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, status=?, params=?, sum=?";
            StringBuilder query = new StringBuilder(update ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, status=?, params=?, sum=?").append(update ? " WHERE id=?" : "");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                int index = 1;
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getTransactionId());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                if (update) {
                    ps.setInt(index++, id);
                }
                ps.executeUpdate();
                if (!update) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public Transaction doSign(int contractId, BigDecimal sum, boolean autopaymentTransaction, String signCheckCode, Map<String, Object> dataMap) throws BGException {
        Transaction transaction = new Transaction();
        transaction.setSum(sum);
        transaction.setContractId(contractId);
        transaction.setCreateDate(new Date());
        transaction.setAutopayment(autopaymentTransaction);
        transaction.setTransactionId("");
        transaction.setParameters("");
        this.update(transaction);
        dataMap.put("MNT_TRANSACTION_ID", String.valueOf(transaction.getId()));
        String signData = dataMap.get("MNT_ID") + dataMap.get("MNT_TRANSACTION_ID") + dataMap.get("MNT_AMOUNT") + dataMap.get("MNT_CURRENCY_CODE") + String.valueOf(contractId) + dataMap.get("MNT_TEST_MODE") + signCheckCode;
        String sign = Utils.getDigest((String)signData, (String)"UTF-8");
        if (logger.isDebugEnabled()) {
            logger.debug("SIGNATURE DATA: " + signData);
            logger.debug("SIGNATURE: " + sign);
        }
        dataMap.put("MNT_SIGNATURE", sign);
        return transaction;
    }
}

