/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action;

import bitel.billing.server.ActionBase;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.license.common.LicenseUtils;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ActionCreatePackage
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int copyId = this.getIntParameter("copy_id", -1);
        this.cid = this.getIntParameter("cid", -1);
        List selectedIds = Utils.toList((String)this.getParameter("ids", ""));
        if (copyId < 0 || this.cid < 0) {
            throw new BGIllegalArgumentException();
        }
        int i = 0;
        int[] ids = new int[selectedIds.size()];
        for (String id : selectedIds) {
            int copyItemId = Utils.parseInt((String)id, (int)-1);
            if (copyItemId > 0) {
                ids[i++] = copyItemId;
                continue;
            }
            throw new BGIllegalArgumentException();
        }
        License p = new License();
        p.setCopyId(copyId);
        p.setUserId(this.userId.intValue());
        p.setCopyItemIds(ids);
        p.setData("");
        LicenseManager licenseManager = new LicenseManager(this.con, this.mid);
        Copy copy = licenseManager.getCopy(copyId);
        int packageId = licenseManager.createLicense(p);
        List<ConfirmedOrder> licenseItems = licenseManager.getLicenseItems(p.getId(), true);
        String licText = LicenseUtils.getLicenseText(licenseItems, (LicenseManager)licenseManager, (int)this.cid, (Preferences)this.moduleSetup, (Copy)copy);
        if (!Utils.notBlankString((String)licText)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0442\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        p.setOriginalData(licText);
        String encryptedLicense = "";
        try {
            encryptedLicense = LicenseUtils.encryptLicenseText((String)licText, (Preferences)this.moduleSetup);
        }
        catch (IOException e) {
            throw new BGException("error while license encrypting", (Throwable)e);
        }
        if (Utils.isBlankString((String)encryptedLicense)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        p.setData(encryptedLicense);
        licenseManager.updateLicenseData(p);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        Element row = this.createElement(data, "row");
        row.setAttribute("package_id", String.valueOf(packageId));
    }
}

