/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client.device.type;

import bitel.billing.module.common.BSHEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGConfigEditor;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.service.EntityService;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceService;

public abstract class DeviceTypePanel<D extends Device<D, T>, T extends DeviceType>
extends BGUPanel {
    protected TableModel model = new TableModel(TableModel.class.getName(), this.getDeviceTypeClass());
    protected BGEditor editor;
    protected AtomicReference<T> currentRef = new AtomicReference();

    public DeviceTypePanel(ClientContext ctx) {
        super((LayoutManager)new BorderLayout(), ctx);
    }

    @Override
    protected abstract void jbInit();

    protected abstract Class<T> getDeviceTypeClass();

    @Override
    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DeviceTypePanel.this.model.setData(DeviceTypePanel.this.getWs().deviceTypeList());
            }
        };
    }

    protected abstract DeviceService<D, T> getWs();

    protected abstract T newDeviceType();

    protected abstract Map<String, String> getParams();

    class TableModel
    extends BGTableModel<T> {
        public TableModel(String name, Class<T> clazz) {
            super(name, clazz);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    protected abstract class DeviceTypeFormScript
    extends BGUPanel {
        protected abstract BSHEditor getScriptEditor();

        protected abstract String getScript();

        protected abstract void setScript(String var1);

        public DeviceTypeFormScript() {
            super(new BorderLayout());
        }

        @Override
        protected void jbInit() {
            BGSwingUtilites.wrapEmptyBorder(this);
            this.add((Component)this.getScriptEditor(), "Center");
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DeviceTypeFormScript.this.getScriptEditor().setText("");
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DeviceTypeFormScript.this.getScriptEditor().setText(DeviceTypeFormScript.this.getScript());
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DeviceTypeFormScript.this.setScript(DeviceTypeFormScript.this.getScriptEditor().getText());
                }
            };
        }
    }

    protected class DeviceTypeFormMain
    extends BGUPanel {
        private BGTextField title;
        private BGUComboBox<EntitySpec> entitySpec;
        private JTextArea comment;
        private BGConfigEditor config;
        private JCheckBox source;
        private DynamicClassChooser saClass;
        private DynamicClassChooser protocolClass;
        private DynamicClassChooser managerClass;
        protected boolean showDeviceManager;
        protected boolean showEntity;
        protected boolean showSource;
        protected boolean showProtocolHandler;

        public DeviceTypeFormMain() {
            super(new BorderLayout());
            this.showDeviceManager = true;
            this.showEntity = true;
            this.showSource = true;
            this.showProtocolHandler = true;
        }

        public DeviceTypeFormMain(boolean showEntity, boolean showDeviceManager, boolean showProtocolHandler, boolean showSource) {
            super(new BorderLayout());
            this.showDeviceManager = true;
            this.showEntity = true;
            this.showSource = true;
            this.showProtocolHandler = true;
            this.showEntity = showEntity;
            this.showDeviceManager = showDeviceManager;
            this.showProtocolHandler = showProtocolHandler;
            this.showSource = showSource;
        }

        @Override
        protected void jbInit() {
            BGSwingUtilites.wrapEmptyBorder(this);
            Map<String, String> params = DeviceTypePanel.this.getParams();
            String iface = params.get("om.iface");
            this.saClass = new DynamicClassChooser(true);
            this.saClass.setIfaceName(iface);
            this.saClass.setSuperclassName(params.get("om.super"));
            this.saClass.setDerivingIfaces(Collections.singleton(iface));
            iface = params.get("ph.iface");
            this.protocolClass = new DynamicClassChooser(true);
            this.protocolClass.setIfaceName(iface);
            this.protocolClass.setSuperclassName(params.get("ph.super"));
            this.protocolClass.setDerivingIfaces(Collections.singleton(iface));
            iface = params.get("dm.iface");
            this.managerClass = new DynamicClassChooser(true);
            this.managerClass.setIfaceName(iface);
            this.managerClass.setSuperclassName(params.get("dm.super"));
            this.managerClass.setDerivingIfaces(Collections.singleton(iface));
            this.title = new BGTextField();
            this.entitySpec = new BGUComboBox();
            this.comment = new JTextArea(8, 0);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.config = new BGConfigEditor();
            this.source = new JCheckBox();
            this.source.setText(params.get("is.source"));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            if (this.showSource) {
                panel.add((Component)this.source, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            }
            if (this.showEntity) {
                panel.add((Component)new JLabel("\u041d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432:"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
                panel.add(this.entitySpec, new GridBagConstraints(0, 7, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            }
            panel.add((Component)new JLabel(params.get("om.title") + ":"), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
            panel.add((Component)this.saClass, new GridBagConstraints(0, 9, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            panel.add((Component)new JLabel(params.get("protocol.handler.title") + ":"), new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
            panel.add((Component)this.protocolClass, new GridBagConstraints(0, 11, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            if (!this.showProtocolHandler) {
                BGSwingUtilites.setEnabled(this.protocolClass, false);
            }
            if (this.showDeviceManager) {
                panel.add((Component)new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c:"), new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
                panel.add((Component)this.managerClass, new GridBagConstraints(0, 13, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            }
            JPanel extraPanel = this.addExtraPanel();
            panel.add((Component)extraPanel, new GridBagConstraints(0, 14, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 16, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 0, 0, 3), 0, 0));
            JPanel panel2 = new JPanel(new GridBagLayout());
            panel2.add((Component)new JLabel("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel2.add((Component)this.config, new GridBagConstraints(0, 1, 1, 13, 1.0, 1.0, 10, 1, new Insets(3, 5, 0, 0), 0, 0));
            this.add((Component)new BGSplitPaneNoBorder(1, panel, (Component)panel2, 400L), "Center");
            ArrayList<IdTitle> data = new ArrayList<IdTitle>();
            data.add(new IdTitle(DeviceType.MGMT_TYPE_OTHER, "\u0414\u0440\u0443\u0433\u043e\u0435"));
            data.add(new IdTitle(DeviceType.MGMT_TYPE_SNMP, "SNMP"));
            data.add(new IdTitle(DeviceType.MGMT_TYPE_TELNET, "Telnet"));
            data.add(new IdTitle(DeviceType.MGMT_TYPE_SSH, "SSH"));
            data.add(new IdTitle(-1, "---"));
            data.add(new IdTitle(DeviceType.MGMT_TYPE_BGRADIUS, "BGRadius"));
        }

        protected JPanel addExtraPanel() {
            return new JPanel(new BorderLayout());
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    Object current = DeviceTypePanel.this.newDeviceType();
                    DeviceTypeFormMain.this.title.setText("");
                    DeviceTypeFormMain.this.comment.setText("");
                    DeviceTypeFormMain.this.config.setText("");
                    DeviceTypeFormMain.this.saClass.performAction("refresh");
                    DeviceTypeFormMain.this.protocolClass.performAction("refresh");
                    if (DeviceTypeFormMain.this.showDeviceManager) {
                        DeviceTypeFormMain.this.managerClass.performAction("refresh");
                    }
                    DeviceTypePanel.this.currentRef.set(current);
                    DeviceTypeFormMain.this.showExtraValues();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DeviceType current = (DeviceType)DeviceTypePanel.this.currentRef.get();
                    DeviceTypeFormMain.this.title.setText(current.getTitle());
                    List entitySpecList = ((ClientContext)DeviceTypeFormMain.this.getContext()).getPort(EntityService.class, 0).entitySpecList();
                    EntitySpec nullEntitySpec = new EntitySpec();
                    nullEntitySpec.setTitle(" --- ");
                    entitySpecList.add(0, nullEntitySpec);
                    DeviceTypeFormMain.this.entitySpec.setData(entitySpecList);
                    DeviceTypeFormMain.this.entitySpec.setSelectedItem(current.getDeviceEntitySpecId());
                    DeviceTypeFormMain.this.saClass.performAction("refresh");
                    if (current.getSaHandlerClass() != null) {
                        DeviceTypeFormMain.this.saClass.setSelectedItem(current.getSaHandlerClass());
                    } else if (DeviceTypeFormMain.this.saClass.getClassNamesBox().getItemCount() > 0) {
                        DeviceTypeFormMain.this.saClass.setSelectedIndex(0);
                    }
                    DeviceTypeFormMain.this.protocolClass.performAction("refresh");
                    if (current.getProtocolHandlerClass() != null) {
                        DeviceTypeFormMain.this.protocolClass.setSelectedItem(current.getProtocolHandlerClass());
                    } else if (DeviceTypeFormMain.this.protocolClass.getClassNamesBox().getItemCount() > 0) {
                        DeviceTypeFormMain.this.protocolClass.setSelectedIndex(0);
                    }
                    if (DeviceTypeFormMain.this.showDeviceManager) {
                        DeviceTypeFormMain.this.managerClass.performAction("refresh");
                        if (current.getDeviceManagerClass() != null) {
                            DeviceTypeFormMain.this.managerClass.setSelectedItem(current.getDeviceManagerClass());
                        } else {
                            DeviceTypeFormMain.this.managerClass.setSelectedIndex(0);
                        }
                    }
                    DeviceTypeFormMain.this.comment.setText(current.getComment());
                    DeviceTypeFormMain.this.config.setText(current.getConfig());
                    DeviceTypeFormMain.this.source.setSelected(current.isSource());
                    DeviceTypeFormMain.this.showExtraValues();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DeviceType current = (DeviceType)DeviceTypePanel.this.currentRef.get();
                    current.setTitle(DeviceTypeFormMain.this.title.getText());
                    current.setComment(DeviceTypeFormMain.this.comment.getText());
                    current.setConfig(DeviceTypeFormMain.this.config.getText());
                    current.setSaHandlerClass(DeviceTypeFormMain.this.saClass.getSelectedClass());
                    current.setProtocolHandlerClass(DeviceTypeFormMain.this.protocolClass.getSelectedClass());
                    current.setDeviceManagerClass(DeviceTypeFormMain.this.managerClass.getSelectedClass());
                    if (DeviceTypeFormMain.this.entitySpec.getSelectedItem() != null) {
                        current.setDeviceEntitySpecId(((EntitySpec)DeviceTypeFormMain.this.entitySpec.getSelectedItem()).getId());
                    }
                    current.setSource(DeviceTypeFormMain.this.source.isSelected());
                    DeviceTypeFormMain.this.saveExtraValues();
                }
            };
        }

        protected void showExtraValues() {
        }

        protected void saveExtraValues() {
        }
    }

    protected abstract class DeviceTypeForm
    extends BGUPanel {
        protected JTabbedPane pane;
        protected List<BGUPanel> panels;

        public DeviceTypeForm() {
            super(new BorderLayout());
            this.setName("deviceTypeForm");
        }

        @Override
        protected abstract void jbInit();

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    for (BGUPanel panel : DeviceTypeForm.this.panels) {
                        panel.performAction("new");
                    }
                    DeviceTypeForm.this.pane.setSelectedIndex(0);
                    DeviceTypeForm.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DeviceType selected = (DeviceType)DeviceTypePanel.this.model.getSelectedRow();
                    if (selected != null) {
                        selected = DeviceTypePanel.this.getWs().deviceTypeGet(selected.getId());
                        DeviceTypePanel.this.currentRef.set(selected);
                        for (BGUPanel panel : DeviceTypeForm.this.panels) {
                            panel.performAction("edit");
                        }
                        DeviceTypeForm.this.pane.setSelectedIndex(0);
                        DeviceTypeForm.this.performActionOpen();
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (!this.isEnabled()) {
                        ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                        return;
                    }
                    DeviceTypePanel.this.currentRef.set((DeviceType)DeviceTypePanel.this.model.getSelectedRow());
                    if (DeviceTypePanel.this.currentRef.get() == null) {
                        return;
                    }
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0442\u0438\u043f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                        DeviceTypePanel.this.getWs().deviceTypeDelete(((DeviceType)DeviceTypePanel.this.currentRef.get()).getId());
                        DeviceTypePanel.this.performAction("refresh");
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    for (BGUPanel panel : DeviceTypeForm.this.panels) {
                        panel.performAction("ok");
                    }
                    int id = DeviceTypePanel.this.getWs().deviceTypeUpdate((DeviceType)DeviceTypePanel.this.currentRef.get());
                    DeviceTypePanel.this.performAction("refresh");
                    DeviceTypePanel.this.model.setSelectedRow(id);
                    DeviceTypeForm.this.performActionClose();
                }
            };
        }
    }
}

