/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import bitel.billing.module.common.ActionPerformer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGButtonPanel
extends JPanel
implements ActionPerformer {
    public static final String COMMAND_OK = "ok";
    public static final String COMMAND_HELP = "help";
    public static final String COMMAND_CLEAR = "clear";
    public static final String COMMAND_CLOSE = "close";
    public static final String COMMAND_CANCEL = "cancel";
    private transient Vector<ActionListener> actionListeners;
    public static ButtonItem GLUE = new ButtonItem(null, null);
    public static ButtonItem SELECTALL = new ButtonItem("\u0412\u0441\u0435", "select");
    public static ButtonItem CLEAR = new ButtonItem("\u0421\u0431\u0440\u043e\u0441", "clear");
    public static ButtonItem OK = new ButtonItem("\u041e\u043a", "ok");
    public static ButtonItem CANCEL = new ButtonItem("\u041e\u0442\u043c\u0435\u043d\u0430", "cancel");
    public static ButtonItem CLOSE = new ButtonItem("\u0417\u0430\u043a\u0440\u044b\u0442\u044c", "close");
    public static ButtonItem HELP = new ButtonItem("\u0421\u043f\u0440\u0430\u0432\u043a\u0430", "help");
    public static ButtonItem RESET = new ButtonItem("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c", "reset");
    public static ButtonItem PRINT_M = new ButtonItem("", "print", ClientUtils.getIcon("print.png"));
    public static ButtonItem SAVE_M = new ButtonItem("", "save", ClientUtils.getIcon("save.png"));
    public static ButtonItem EMAIL_M = new ButtonItem("", "email", ClientUtils.getIcon("mail.png"));
    public static ButtonItem DO_M = new ButtonItem("", "do", ClientUtils.getIcon("do.gif"));

    public BGButtonPanel(ButtonItem ... buttonItems) {
        this.setLayout(new GridBagLayout());
        if (buttonItems != null) {
            int index = 0;
            for (ButtonItem item : buttonItems) {
                if (item.text != null || item.command != null || item.icon != null) {
                    JButton button = new JButton();
                    button.setIcon(item.icon);
                    button.setActionCommand(item.command);
                    button.setText(item.text);
                    button.addActionListener(e -> this.fireActionPerformed(e));
                    this.add((Component)button, new GridBagConstraints(index, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, index == 0 ? 0 : 4, 0, 0), 0, 0));
                    ++index;
                    continue;
                }
                this.add(Box.createGlue(), new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component component : this.getComponents()) {
            if (!(component instanceof JButton)) continue;
            ((JButton)component).setEnabled(enabled);
        }
    }

    public JButton getButton(String command) {
        JButton result = null;
        for (Component component : this.getComponents()) {
            JButton button;
            if (!(component instanceof JButton) || !command.equals((button = (JButton)component).getActionCommand())) continue;
            result = button;
        }
        return result;
    }

    public JButton getButton(ButtonItem item) {
        for (Component component : this.getComponents()) {
            JButton button;
            if (!(component instanceof JButton) || !item.command.equals((button = (JButton)component).getActionCommand())) continue;
            return button;
        }
        return null;
    }

    public void setSelected(ButtonItem item) {
        JButton button = this.getButton(item);
        if (button != null) {
            button.setSelected(true);
        }
    }

    @Override
    public void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector<ActionListener> listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).actionPerformed(e);
            }
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector<ActionListener> v = new Vector<ActionListener>();
            v.addAll(this.actionListeners);
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector<ActionListener> v = new Vector<ActionListener>();
        if (this.actionListeners != null) {
            v.addAll(this.actionListeners);
        }
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    public static class ButtonItem {
        public String text;
        public String command;
        public Icon icon;

        public ButtonItem(String text, String command) {
            this(text, command, null);
        }

        public ButtonItem(String text, String command, Icon icon) {
            this.text = text;
            this.command = command;
            this.icon = icon;
        }

        public boolean equals(Object obj) {
            if (obj instanceof String) {
                String actionCommand = (String)obj;
                return this.command.equals(actionCommand);
            }
            if (obj instanceof ButtonItem) {
                ButtonItem otherButtonItem = (ButtonItem)obj;
                return this.command.equals(otherButtonItem.command);
            }
            return super.equals(obj);
        }

        public String getActionCommand() {
            return this.command;
        }
    }
}

