/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectType;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;

public class ContractObjectDao
extends AbstractEntityAttrDao<ContractObject> {
    public ContractObjectDao(Connection con, int userId) {
        super(con, 0, userId, "object", "object", CONTRACT_OBJECT_SUPPORT);
    }

    public Directory<? extends EntitySpec> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractObjectType.class, this.con, 0, true);
        }
        return this.entitySpecDirectory;
    }

    protected Directory<? extends EntitySpecAttr> getEntitySpecAttrDirectory() throws BGException {
        if (this.entitySpecAttrDirectory == null) {
            this.entitySpecAttrDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractObjectParam.class, this.con, 0, true);
        }
        return this.entitySpecAttrDirectory;
    }

    protected ContractObject getFromRS(ResultSet rs, boolean loadAttributes) throws SQLException, BGException {
        ContractObject result = new ContractObject();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setTitle(rs.getString("title"));
        result.setTypeId(rs.getInt("type_id"));
        result.setDateFrom(TimeUtils.convertDateToCalendar(rs.getDate("date1")));
        result.setDateTo(TimeUtils.convertDateToCalendar(rs.getDate("date2")));
        result.setPosition(rs.getInt("pos"));
        return result;
    }

    protected void updateImpl(ContractObject b) throws BGException, SQLException {
    }

    public List<ContractObject> list(int contractId) throws BGException {
        return super.list("cid=?", "pos", new Object[]{contractId});
    }
}

