/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.MonitorStatusResult;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.server.ServerStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.contract.status.server.WebStatusChangeRules;
import ru.bitel.bgbilling.kernel.contract.status.server.bean.ContractStatusMonitorDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.GetContractStatusChangeDatesEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService")
public class ContractStatusServiceImpl
extends AbstractService
implements ContractStatusService {
    protected static Calendar balanceDumpTime;

    @Override
    public List<Status> statusList() throws BGException, BGMessageException {
        return StatusCache.getInstance().getStatusList();
    }

    @Override
    public List<ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus> contractStatusList(int contractId, Date date) throws BGException, BGMessageException {
        List<ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus> list;
        ContractStatusDao contractStatusDao = new ContractStatusDao(this.getConnection());
        try {
            list = contractStatusDao.list(contractId, date);
        }
        catch (Throwable throwable) {
            try {
                try {
                    contractStatusDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
        contractStatusDao.close();
        return list;
    }

    @Override
    public ContractStatusService.ContractStatusChangeParameters contractStatusChangeParametersGet(int contractId) throws BGException, BGMessageException {
        Date curdate = new Date();
        WebStatusChangeRules changeRules = StatusCache.getInstance().getWebStatusChangeRules();
        Set<Integer> changeableStatusSet = changeRules.getChangeableStatusIds();
        int status = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId).getStatus();
        GetContractStatusChangeDatesEvent dateListEvent = new GetContractStatusChangeDatesEvent(this.userId, contractId, status, curdate);
        dateListEvent = EventProcessor.getInstance().request(dateListEvent);
        List<Date> changeDateList = dateListEvent.getDateList();
        Calendar changeFrom = TimeUtils.convertDateToCalendar(changeRules.getFromStatusChangeDate(status));
        if (changeDateList != null) {
            ArrayList<Date> _changeDateList = new ArrayList<Date>();
            for (Date date : changeDateList) {
                _changeDateList.add(TimeUtils.clear_HOUR_MIN_MIL_SEC(date));
            }
            changeDateList = _changeDateList;
        }
        ContractStatusService.ContractStatusChangeParameters result = new ContractStatusService.ContractStatusChangeParameters();
        result.setChangeableStatuses(changeableStatusSet);
        if (changeDateList != null) {
            if (!changeDateList.isEmpty()) {
                result.setDateList(changeDateList);
            }
        } else {
            result.setDate(changeFrom != null ? changeFrom.getTime() : null);
        }
        boolean hasFutureChange = false;
        boolean hasManyFutureChanges = false;
        boolean canCancel = false;
        ContractStatusDao contractStatusDao = new ContractStatusDao(this.getConnection());
        for (ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus contractStatus : contractStatusDao.list(contractId, null)) {
            if (!TimeUtils.dateBefore(curdate, contractStatus.getDateFrom())) continue;
            if (hasFutureChange) {
                canCancel = false;
                hasManyFutureChanges = true;
                break;
            }
            hasFutureChange = true;
            if (!changeableStatusSet.contains(contractStatus.getStatus())) continue;
            canCancel = true;
        }
        contractStatusDao.close();
        result.setHasFutureChange(hasFutureChange);
        result.setHasManyFutureChanges(hasManyFutureChanges);
        result.setCanCancel(canCancel);
        return result;
    }

    @Override
    public MapHolder<String, String> contractStatusChange(int contractId, ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus contractStatus, boolean customer, boolean confirmChecked) throws BGException, BGMessageException {
        if (contractStatus == null || contractStatus.getStatus() < 0) {
            throw new BGIllegalArgumentException("contractStatus");
        }
        if (contractStatus.getContractId() <= 0 || contractStatus.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        if (contractStatus.getDateFrom() == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430.", "contractStatusChange.dateFrom");
        }
        if (contractStatus.getDateTo() != null && !TimeUtils.dateBeforeOrEq(contractStatus.getDateFrom(), contractStatus.getDateTo())) {
            throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", "contractStatusChange.wrongPeriod");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (!ServerStatusUtil.checkStatusChange(contractId, this.userId, contractStatus, confirmChecked, result)) {
            return new MapHolder<String, String>(result);
        }
        if (!customer) {
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractStatusChange", (int)0, (int)this.userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, null, (Date)contractStatus.getDateFrom(), (Date)contractStatus.getDateTo());
            }
            ContractStatusManager statusManager = new ContractStatusManager(this.getConnection());
            contractStatus.setId(0);
            statusManager.changeStatus(new ContractStatus(contractStatus), Integer.valueOf(this.userId));
            statusManager.recycle();
            result.put("statusId", String.valueOf(contractStatus.getId()));
            return new MapHolder<String, String>(result);
        }
        return this.contractStatusChangeByCustomer(contractStatus);
    }

    private MapHolder<String, String> contractStatusChangeByCustomer(ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus contractStatus) throws BGException, BGMessageException {
        if (contractStatus.getDateTo() != null) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.forbidden");
        }
        WebStatusChangeRules changeRules = StatusCache.getInstance().getWebStatusChangeRules();
        ContractManager contractManager = new ContractManager(this.getConnection());
        Contract contract = contractManager.getContractById(contractStatus.getContractId());
        contractManager.close();
        int currentStatus = contract.getStatus();
        Date curdate = new Date();
        ContractStatusService.ContractStatusChangeParameters changeParams = this.contractStatusChangeParametersGet(contractStatus.getContractId());
        if (TimeUtils.dateEqual(contractStatus.getDateFrom(), curdate) && currentStatus == contractStatus.getStatus()) {
            contractStatus.setDateTo(null);
            if (!changeParams.isCanCancel()) {
                if (changeParams.isHasFutureChange()) {
                    throw new BGMessageException("\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.", "contractStatusChangeCancel.blockedByFutureChange");
                }
                if (changeParams.isHasManyFutureChanges()) {
                    throw new BGMessageException("\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.", "contractStatusChangeCancel.blockedByFutureChange");
                }
                throw new BGMessageException("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441\u043e \u0441\u043c\u0435\u043d\u044f\u0435\u043c\u044b\u043c.", "contractStatusChangeCancel.notFound");
            }
        } else {
            if (!changeRules.isStatusChangeAllow(currentStatus, contractStatus.getStatus())) {
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.forbidden");
            }
            if (changeParams.isHasFutureChange()) {
                throw new BGMessageException("\u0421\u043c\u0435\u043d\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0443\u0436\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442.", "contractStatusChange.hasFutureChange");
            }
            if (changeParams.getDateList() != null && changeParams.getDateList().size() > 0) {
                if (!changeParams.getDateList().contains(contractStatus.getDateFrom())) {
                    throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
                }
            } else if (changeParams.getDate() != null) {
                if (!TimeUtils.dateBeforeOrEq(changeParams.getDate(), contractStatus.getDateFrom())) {
                    throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
                }
            } else {
                throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
            }
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractStatus", (int)0, (int)-1);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, null, (Date)contractStatus.getDateFrom(), (Date)contractStatus.getDateTo());
        }
        ContractStatusManager statusManager = new ContractStatusManager(this.getConnection());
        contractStatus.setId(0);
        statusManager.changeStatus(new ContractStatus(contractStatus), Integer.valueOf(-1));
        statusManager.recycle();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("statusId", String.valueOf(contractStatus.getId()));
        return new MapHolder<String, String>(result);
    }

    @Override
    public void createBalanceDump() throws BGException, BGMessageException {
        ContractStatusMonitorDao dao = new ContractStatusMonitorDao(this.getConnection());
        balanceDumpTime = dao.createBalanceDump();
        dao.close();
    }

    @Override
    public SearchResult<MonitorStatusResult> contractSearch(int mode, int statusPeriod, String statusPeriodUnit, Set<Integer> label, Set<Integer> notLabel, String status, String saldoFrom, String saldoTo, String sort, int subContract, Page page, int saldoAccountMonths, BigDecimal saldoAcconuntsMore, Set<Integer> serviceAccountMaxServices, float serviceMaxVal, int balanceLimit, int balancePrevLimit) throws BGException, BGMessageException {
        if (balanceDumpTime == null) {
            throw new BGMessageException("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0441\u0440\u0435\u0437 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432!");
        }
        if (TimeUtils.daysDelta(balanceDumpTime, new GregorianCalendar()) >= 1) {
            throw new BGMessageException("\u0421\u0440\u0435\u0437 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432 \u0443\u0441\u0442\u0430\u0440\u0435\u043b, \u0441\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u0435\u0433\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e");
        }
        int saldoShowMode = this.getSetup().getInt("contract.status.monitor.saldo.show.mode", 1);
        try (ContractStatusMonitorDao dao = new ContractStatusMonitorDao(this.getConnection());){
            SearchResult<MonitorStatusResult> searchResult = dao.contractSearch(saldoShowMode, saldoAccountMonths, serviceMaxVal, Utils.toString(serviceAccountMaxServices), status, mode, subContract, balanceLimit, balancePrevLimit, statusPeriod, statusPeriodUnit, label, notLabel, saldoFrom, saldoTo, saldoAcconuntsMore, sort, page);
            return searchResult;
        }
    }

    @Override
    public List<Status> getStatusList(boolean onlyManual) throws BGException, BGMessageException {
        List<Status> statusList = null;
        statusList = onlyManual ? StatusCache.getInstance().getManualStatusList() : StatusCache.getInstance().getStatusList();
        return statusList;
    }

    @Override
    public MapHolder<String, String> changeContractStatus(int[] cids, int statusId, Date dateFrom, Date dateTo, String comment, boolean confirmChecked) throws BGException, BGMessageException {
        if (cids.length <= 0 || statusId < 0 || dateFrom == null) {
            throw new BGIllegalArgumentException();
        }
        if (dateTo != null && !TimeUtils.dateBeforeOrEq(dateFrom, dateTo)) {
            throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (cids.length == 1 && !ServerStatusUtil.checkStatusChange(cids[0], this.userId, statusId, dateFrom, dateTo, comment, confirmChecked, result)) {
            return new MapHolder<String, String>(result);
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractStatusChange", (int)0, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, null, (Date)dateFrom, (Date)dateTo);
        }
        ContractStatusManager statusManager = new ContractStatusManager(this.getConnection());
        for (int i = 0; i < cids.length; ++i) {
            ContractStatus status = new ContractStatus();
            status.setComment(comment);
            status.setContractId(cids[i]);
            status.setDateFrom(dateFrom);
            status.setDateTo(dateTo);
            status.setStatus(statusId);
            statusManager.changeStatus(status.clone(), Integer.valueOf(this.userId));
        }
        result.put("status", "ok");
        return new MapHolder<String, String>(result);
    }
}

