/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.load;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import bitel.billing.module.services.load.SourceEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class ServiceConfigSources
extends ServiceConfigTabbedPanel {
    private SourceEditor sourceEditor = new SourceEditor();
    private BGTable table = new BGTable();

    public ServiceConfigSources() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.table.setHeader(this.rb_name, "source");
    }

    private void jbInit() throws Exception {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() > 1) {
                    ServiceConfigSources.this.editItem();
                }
            }
        });
        this.sourceEditor.setVisible(false);
        this.sourceEditor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceConfigSources.this.editor_componentHidden(e);
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.sourceEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule("load");
        request.setModuleId(this.getModuleId());
        request.setAction("SourceInfo");
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            this.table.updateData(XMLUtils.selectNode(doc, "//table"));
        }
    }

    @Override
    public void newItem() {
        this.sourceEditor.init(this.module, this.getModuleId());
        this.sourceEditor.setId("new");
        this.sourceEditor.setData();
        this.sourceEditor.setVisible(true);
    }

    @Override
    public void editItem() {
        this.id = ClientUtils.getRowId(this.table);
        if (this.id == null) {
            return;
        }
        this.sourceEditor.init(this.module, this.getModuleId());
        this.sourceEditor.setId(this.id);
        this.sourceEditor.setData();
        this.sourceEditor.setVisible(true);
    }

    @Override
    public void deleteItem() {
        this.id = ClientUtils.getRowId(this.table);
        if (this.id == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule("load");
            request.setAction("DeleteSource");
            request.setAttribute("id", this.id);
            request.setModuleId(this.getModuleId());
            ClientUtils.checkStatus(this.getDocument(request));
            this.setData();
        }
    }

    private void editor_componentHidden(ComponentEvent e) {
        this.setData();
    }
}

