/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentTypeItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.treetable.BGTreeTableModel;

public class TreeTypesEditor
extends BGPanel {
    private int id = -1;
    private int upId = 0;
    private int mode;
    private String nameEditor;
    private BGButtonPanelRestoreOkCancelHelp okCancelHelp = new BGButtonPanelRestoreOkCancelHelp();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton rbElGroup = new JRadioButton("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0433\u0440\u0443\u043f\u043f\u044b");
    private JRadioButton rbGroup = new JRadioButton("\u0413\u0440\u0443\u043f\u043f\u0430");
    private JTextField title = new JTextField("");
    private JCheckBox editable = new JCheckBox("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
    private JPanel editPanel = new JPanel();
    private JPanel tablePanel = new JPanel();
    private JPanel subEditPanel = new JPanel();
    private BooleanRenderer renderer = new BooleanRenderer();
    private List<Integer> cutIdList = new ArrayList<Integer>();
    private BGUTreeTable treeTable;
    private BGTreeTableModel<PaymentTypeItem> model = new BGTreeTableModel<PaymentTypeItem>("payments"){

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", PaymentTypeItem.class, 300, -1, -1, "title", true);
            this.addColumn("\u041a\u043e\u0434", 80, 80, 80, "id", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439", 150, 150, 150, "editable", true);
        }

        @Override
        public Object getValue(PaymentTypeItem val, int column) throws BGException {
            if (column == 1 && val == this.root) {
                return "";
            }
            return super.getValue(val, column);
        }

        @Override
        public TableCellRenderer getTableCellRenderer(int columnIndex) {
            if (columnIndex == 2) {
                return TreeTypesEditor.this.renderer;
            }
            return super.getTableCellRenderer(columnIndex);
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((PaymentTypeItem)node).getType() == 0;
        }
    };

    public TreeTypesEditor(String nameEditor, int mode) {
        this.nameEditor = nameEditor;
        this.mode = mode;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.getContext().processException(e);
        }
        this.editPanel.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.treeTable = new BGUTreeTable(this.model);
        this.treeTable.setRowSorter(null);
        this.treeTable.setSelectionMode(0);
        this.editPanel.setLayout(new GridBagLayout());
        this.editPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.subEditPanel.setLayout(new GridBagLayout());
        this.title.setMinimumSize(new Dimension(4, 24));
        this.title.setPreferredSize(new Dimension(4, 24));
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new BGTitleBorder(this.nameEditor));
        this.okCancelHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    switch (e.getActionCommand()) {
                        case "ok": {
                            if (TreeTypesEditor.this.title.getText().trim().length() == 0) {
                                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                                return;
                            }
                            if (TreeTypesEditor.this.mode == 0) {
                                TreeTypesEditor.this.getContext().getDirectory(PaymentType.class).update(new PaymentType(TreeTypesEditor.this.id, TreeTypesEditor.this.title.getText().trim(), TreeTypesEditor.this.rbGroup.isSelected() ? 1 : 0, TreeTypesEditor.this.editable.isSelected(), TreeTypesEditor.this.upId));
                            } else if (TreeTypesEditor.this.mode == 1 || TreeTypesEditor.this.mode == 16) {
                                TreeTypesEditor.this.getContext().getDirectory(ChargeType.class).update(new ChargeType(TreeTypesEditor.this.id, TreeTypesEditor.this.title.getText().trim(), TreeTypesEditor.this.rbGroup.isSelected() ? 1 : 0, TreeTypesEditor.this.editable.isSelected(), TreeTypesEditor.this.upId, TreeTypesEditor.this.mode == 16));
                            }
                            TreeTypesEditor.this.setData();
                            TreeTypesEditor.this.treeTable.setEnabled(true);
                            TreeTypesEditor.this.editPanel.setVisible(false);
                            break;
                        }
                        case "reset": {
                            TreeTypesEditor.this.editItem();
                            break;
                        }
                        case "cancel": {
                            TreeTypesEditor.this.editPanel.setVisible(false);
                            TreeTypesEditor.this.treeTable.setEnabled(true);
                            break;
                        }
                        case "help": {
                            TreeTypesEditor.this.openHelp(this.getClass().getName());
                        }
                    }
                }
                catch (BGException e1) {
                    TreeTypesEditor.this.getContext().processException(e1);
                }
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TreeTypesEditor.this.editItem();
                }
            }
        });
        this.editPanel.add((Component)this.okCancelHelp, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 10, 5, 10), 0, 0));
        this.editPanel.add((Component)this.subEditPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.subEditPanel.add((Component)this.title, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.subEditPanel.add((Component)this.editable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.subEditPanel.add((Component)this.rbGroup, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.subEditPanel.add((Component)this.rbElGroup, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.subEditPanel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.tablePanel.add((Component)new JScrollPane(this.treeTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonGroup.add(this.rbGroup);
        this.buttonGroup.add(this.rbElGroup);
        this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(1000);
        this.treeTable.getColumnModel().getColumn(1).setMinWidth(40);
        this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(40);
        JPopupMenu menu = new JPopupMenu();
        ActionListener actionListener = e -> {
            if ("cutItem".equals(e.getActionCommand())) {
                this.cutIdList.clear();
                this.model.getSelectedRows().forEach(item -> this.cutIdList.add(item.getId()));
            } else if ("insertItem".equals(e.getActionCommand())) {
                PaymentTypeItem node = (PaymentTypeItem)this.model.getSelectedRow();
                this.upId = node != null ? node.getId() : 0;
                try {
                    if (this.mode == 0) {
                        this.getContext().getPort(PaymentService.class).paymentTypeMove(this.upId, this.cutIdList);
                    } else if (this.mode == 1 || this.mode == 16) {
                        this.getContext().getPort(ChargeService.class).chargeTypeMove(this.upId, this.cutIdList);
                    }
                }
                catch (BGException e1) {
                    this.getContext().processException(e1);
                }
                this.cutIdList.clear();
                this.setData();
            }
        };
        JMenuItem cutItem = new JMenuItem("\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c");
        cutItem.setActionCommand("cutItem");
        cutItem.addActionListener(actionListener);
        JMenuItem insertItem = new JMenuItem("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c");
        insertItem.setActionCommand("insertItem");
        insertItem.addActionListener(actionListener);
        menu.add(cutItem);
        menu.add(insertItem);
        this.addPopupMenu(menu);
    }

    public final void addPopupMenu(final JPopupMenu menu) {
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    menu.show(TreeTypesEditor.this.treeTable, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void setData() {
        try {
            if (this.mode == 0) {
                this.model.setData(this.getContext().getPort(PaymentService.class).paymentTypeTree(-1, true));
            } else {
                this.model.setData(this.getContext().getPort(ChargeService.class).chargeTypeTree(-1, this.mode == 16, true));
            }
            this.treeTable.expand();
        }
        catch (BGException ex) {
            this.getContext().processException(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "newItem": {
                PaymentTypeItem node = (PaymentTypeItem)this.model.getSelectedRow();
                if (node == null || 0 == node.getType()) {
                    ClientUtils.showErrorMessageDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
                    return;
                }
                this.editPanel.setVisible(true);
                this.id = -1;
                this.upId = node.getId();
                this.title.setText("");
                this.editable.setSelected(true);
                this.buttonGroup.setSelected(this.rbElGroup.getModel(), true);
                this.rbGroup.setEnabled(true);
                this.rbElGroup.setEnabled(true);
                break;
            }
            case "editItem": {
                this.editItem();
                break;
            }
            case "deleteItem": {
                this.deleteItem();
                break;
            }
            case "refresh": {
                this.setData();
            }
        }
    }

    @Override
    public void deleteItem() {
        PaymentTypeItem node = (PaymentTypeItem)this.model.getSelectedRow();
        if (node == null || 0 == node.getId()) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
            return;
        }
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
            return;
        }
        if (!ClientUtils.confirmDelete(node.getTitle())) {
            return;
        }
        try {
            if (this.mode == 0) {
                this.getContext().getDirectory(PaymentType.class).delete(node.getId());
            } else if (this.mode == 1 || this.mode == 16) {
                this.getContext().getDirectory(ChargeType.class).delete(node.getId());
            }
        }
        catch (BGException e) {
            this.getContext().processException(e);
        }
        this.setData();
    }

    @Override
    public void editItem() {
        PaymentTypeItem node = (PaymentTypeItem)this.model.getSelectedRow();
        if (node == null || 0 == node.getId()) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        this.editPanel.setVisible(true);
        this.treeTable.setEnabled(false);
        this.id = node.getId();
        this.upId = node.getParentId();
        this.title.setText(node.getTitle());
        this.editable.setSelected(node.getEditable());
        this.buttonGroup.setSelected(node.getType() == 1 ? this.rbGroup.getModel() : this.rbElGroup.getModel(), true);
        this.rbElGroup.setEnabled(node.getType() != 1 || node.getChildren().isEmpty());
    }

    private class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private JPanel component = new JPanel();
        private JComponent curruntComponent;

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.curruntComponent = row == 0 ? this.component : this;
            this.curruntComponent.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.curruntComponent.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.curruntComponent.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : this.noFocusBorder);
            this.setSelected(value != null && (Boolean)value != false);
            return this.curruntComponent;
        }
    }
}

