/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.subscription.common.bean.Subscription;

public class SubscriptionDao
extends AbstractIdDao<Subscription> {
    public SubscriptionDao(Connection con, int mid, int userId) {
        super(con, mid, "inv_subscription");
    }

    private Subscription getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        Subscription result = new Subscription();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("contractId"));
        result.setServId(rs.getInt("servId"));
        result.setTypeId(rs.getInt("typeId"));
        result.setTimeFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeFrom")));
        result.setTimeTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeTo")));
        result.setSubscribeMode(rs.getInt("subscriptionModeId"));
        result.setSubscribeTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("subscriptionTime")));
        result.setUnsubscribeTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("unsubscriptionTime")));
        result.setUserId(rs.getInt("userId"));
        if (titleLoad) {
            result.setTypeTitle(rs.getString("type.title"));
        }
        return result;
    }

    protected Subscription getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    public void update(Subscription subscription, boolean checkDeactivated) throws BGException {
        try {
            this.updateImpl(subscription, checkDeactivated);
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected void updateImpl(Subscription subscription) throws BGException, SQLException {
        this.updateImpl(subscription, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImpl(Subscription subscription, boolean checkDeactivated) throws BGException, SQLException {
        block11: {
            if (subscription.getId() <= 0) {
                String query = "INSERT INTO " + this.tableName + " (contractId, servId, typeId, subscribeMode, timeFrom, timeTo, subscriptionTime, unsubscriptionTime, userId) VALUES (?,?,?,?,?,?,?,?,?)";
                PreparedStatement ps = this.con.prepareStatement(query, 1);
                ps.setInt(1, subscription.getContractId());
                ps.setInt(2, subscription.getServId());
                ps.setInt(3, subscription.getSubscribeMode());
                ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeFrom()));
                ps.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeTo()));
                ps.setTimestamp(6, TimeUtils.convertDateToTimestamp((Date)subscription.getSubscribeTime()));
                ps.setTimestamp(7, TimeUtils.convertDateToTimestamp((Date)subscription.getUnsubscribeTime()));
                ps.setInt(8, subscription.getUserId());
                ps.executeUpdate();
                subscription.setId(ServerUtils.lastInsertId(ps));
                ps.close();
            } else {
                if (subscription.getTimeTo() != null) {
                    String query = checkDeactivated ? "UPDATE " + this.tableName + " SET timeTo=?, unsubscriptionTime=? WHERE id=? AND timeTo IS NULL" : "UPDATE " + this.tableName + " SET timeTo=?, unsubscriptionTime=? WHERE id=?";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeTo()));
                    ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeTo()));
                    ps.setInt(3, subscription.getId());
                    try {
                        if (ps.executeUpdate() == 0) {
                            throw new BGMessageException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0443\u0436\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.");
                        }
                        break block11;
                    }
                    finally {
                        ps.close();
                    }
                }
                String query = "UPDATE " + this.tableName + " SET timeTo=?, unsubscriptionTime=? WHERE id=? AND (timeTo IS NOT NULL AND unsubscriptionTime IS NOT NULL)";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeTo()));
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)subscription.getUnsubscribeTime()));
                ps.setInt(3, subscription.getId());
                try {
                    if (ps.executeUpdate() == 0) {
                        throw new BGMessageException("\u042d\u0442\u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0435\u043b\u044c\u0437\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c!");
                    }
                }
                finally {
                    ps.close();
                }
            }
        }
    }

    public List<Subscription> list(int contractId, Date time) throws BGException {
        return this.list(contractId, time, false, true);
    }

    public List<Subscription> list(int contractId, Date date, boolean history, boolean needNonActive) throws BGException {
        try {
            ArrayList<Subscription> result = new ArrayList<Subscription>();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT subscription.*, subscription_type.title FROM ").append(this.tableName).append(" AS subscription");
            sb.append(" LEFT JOIN inv_subscription_type as subscription_type ON subscription.typeId=subscription_type.id ");
            sb.append(" WHERE subscription.contractId=?");
            if (date != null) {
                if (history) {
                    sb.append("\n AND (subscription.timeTo IS NOT NULL AND ?>subscription.timeTo)");
                } else {
                    sb.append("\n AND (subscription.timeTo IS NULL OR ?<=subscription.timeTo)");
                }
            }
            if (!needNonActive) {
                sb.append("\n AND (subscription.timeTo IS NULL OR subscription.timeFrom<subscription.timeTo)");
            }
            sb.append("\n ORDER BY subscription.timeFrom");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, contractId);
            if (date != null) {
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, true));
            }
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

