/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Node;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;

public class IpCategoryDao
extends AbstractIdDao<IpCategory> {
    public IpCategoryDao(Connection con, int mid) {
        super(con, 0, "inv_ip_category_" + mid);
    }

    protected IpCategory getFromRS(ResultSet rs) throws SQLException, BGException {
        IpCategory result = new IpCategory();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    protected void updateImpl(IpCategory b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b == null || Utils.isBlankString((String)b.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (parentId, title, comment) VALUES (?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=?, title=?, comment=? WHERE id=?");
            ps.setInt(4, b.getId());
        }
        ps.setInt(1, b.getParentId());
        ps.setString(2, b.getTitle());
        ps.setString(3, b.getComment());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public IpCategory root() throws BGException {
        IpCategory root = new IpCategory();
        root.setId(0);
        root.setTitle("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 IP \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
        return (IpCategory)TreeUtils.tree((List)this.list(null, null, new Object[0]), (Node)root);
    }

    public List<IpCategory> list() throws BGException {
        return this.list(null, null, new Object[0]);
    }
}

